/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.search;

import junit.framework.TestCase;

public class TextSearcherTest extends TestCase {
    public void testIsWholeWordSepararator() {
        String nonSeparators = "a0_";
        for ( int i = 0; i < nonSeparators.length(); i++ ) {
            assertFalse( TextSearcher.isWholeWordSepararator( nonSeparators, i ) );
        }

        String separators = " ,.\n-\t=+:;";
        for ( int i = 0; i < separators.length(); i++ ) {
            assertTrue( TextSearcher.isWholeWordSepararator( separators, i ) );
        }
    }

    public void testIndexOf_WholeWordsOnly() throws Exception {
        assertEquals( 1, TextSearcher.indexOf( true, " bcd ", "bcd", 0, true, true ) );
        assertEquals( -1, TextSearcher.indexOf( true, "abcde", "bcd", 0, true, true ) );

        assertEquals( 1, TextSearcher.indexOf( true, " bcd", "bcd", 0, true, true ) );
        assertEquals( -1, TextSearcher.indexOf( true, "abcd", "bcd", 0, true, true ) );

        assertEquals( 0, TextSearcher.indexOf( true, "abc ", "abc", 0, true, true ) );
        assertEquals( -1, TextSearcher.indexOf( true, "abcd", "abc", 0, true, true ) );
    }
}