/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.util.exceptions;

import junit.framework.TestCase;

import java.io.IOException;

public class ThrowableCollectorTest extends TestCase {

    public void test_getMessage() {
        ThrowableCollector collector = new ThrowableCollector();

        assertFalse( collector.isNotEmpty() );

        collector.add( "reading file", new IOException( "crashed!" ) );
        collector.add( "running on firecamp", new RuntimeException( "burned!" ) );
        collector.add( "stealing memory", new OutOfMemoryError( "busted!" ) );
        collector.add( "counting UFOs", new Throwable( "captured!" ) );

        assertTrue( collector.isNotEmpty() );

        assertEquals( "4 throwables collected:\n" +
                "when reading file: java.io.IOException: crashed!\n" +
                "when running on firecamp: java.lang.RuntimeException: burned!\n" +
                "when stealing memory: java.lang.OutOfMemoryError: busted!\n" +
                "when counting UFOs: java.lang.Throwable: captured!",
                collector.getMessage() );
    }
}