/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.gui.resources;

import ja.JaTestCase;

public class ResourcesTest extends JaTestCase {
    private Resources resources;

    protected void setUp() {
        resources = Resources.forProperties( ResourcesTest.class );
    }

    public void testGetLabel_simple() {
        assertEquals( "test ok", resources.text( "test" ) );
    }
    public void testGetLabel_pattern() {
        String name1 = "Carl";
        String name2 = "July";
        String name3 = "Kent";

        String message1 = resources.text( "hello_x", name1 );
        String message2 = resources.text( "hello_x_and_y", name1, name2 );
        String message3 = resources.text( "hello_x_and_y_with_z", name1, name2, name3 );
        String message4 = resources.text( "hello_x_and_y_with_z", new Object[]{name1, name2, name3} );

        assertEquals( "Hello " + name1 + "!", message1 );
        assertEquals( "Hello " + name1 + " and " + name2 + "!", message2 );
        assertEquals( "Hello " + name1 + " and " + name2 + " with " + name3 + "!", message3 );
        assertEquals( "Hello " + name1 + " and " + name2 + " with " + name3 + "!", message4 );
    }

    public void testGetLabel_backslash() {
        assertEquals( "c:\\temp", resources.text( "backslash" ));
        assertEquals( "Hello c:\\temp!", resources.text( "hello_x", "c:\\temp" ) );
    }

    public void testGetLabel_quotes() {
        assertEquals( "'quote a' b", resources.text( "quote", "a", "b" ) );
        assertEquals( "\"double quote a\" b", resources.text( "double_quote", "a", "b" ) );
    }

    public void testGetLabel_incorrectKey() {
        try {
            resources.text( "space in key" );
            failExpected( IllegalArgumentException.class );
        } catch ( IllegalArgumentException e ) {
        }
    }
}
