/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.centre.gui.actionbinder.examples;

import ja.centre.gui.actionbinder.ActionBinder;
import ja.centre.gui.actionbinder.config.NListenerGroup;
import ja.centre.gui.actionbinder.config.NListener;

import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

/**
 * Example of binding with @NListenerGroup and nested "document" property
 */
public class Example3 {
@NListenerGroup ( {
    @NListener ( type = KeyListener.class, mappings = "keyPressed > onKeyPressed" ),
    @NListener ( property = "document", type = DocumentListener.class, mappings = {
        "insertUpdate > onDocumentInsert",
        "removeUpdate > onDocumentRemove" } ),
    @NListener( type = MouseListener.class, mappings = {
            "mouseClicked > onMouseClick",
            "mouseEntered > onMouseEnter",
            "mouseExited  > onMouseExit" } )
} )
    private JTextField field = new JTextField();

    public Example3() {
        ActionBinder.bind( this );
    }

    public void onKeyPressed( KeyEvent e ) {
        System.out.println( "onKeyPressed: " + e );
    }
    public void onDocumentInsert( DocumentEvent e ) {
        System.out.println( "onDocumentInsert: " + e );
    }
    public void onDocumentRemove( DocumentEvent e ) {
        System.out.println( "onDocumentRemove: " + e );
    }
    public void onMouseClick( MouseEvent e ) {
        System.out.println( "onMouseClick: " + e );
    }
    public void onMouseEnter( MouseEvent e ) {
        System.out.println( "onMouseEnter: " + e );
    }
    public void onMouseExit( MouseEvent e ) {
        System.out.println( "onMouseExit: " + e );
    }

    public static void main( String[] args ) {
        JFrame frame = new JFrame( "Example3" );
        frame.setContentPane( new Example3().field );
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        frame.pack();
        frame.setLocationRelativeTo( null );
        frame.setVisible( true );
    }
}
