/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.application.util;

import ja.centre.util.assertions.Arguments;

import javax.swing.*;
import java.awt.*;

public class WasEverShownHelper <T extends Window> {
    private T window;
    private Dimension size;
    private boolean wasEverShown;

    public WasEverShownHelper( T window, int width, int height ) {
        Arguments.assertNotNull( "window", window );

        this.window = window;
        this.size = new Dimension( width, height );
    }

    public WasEverShownHelper( T window ) {
        Arguments.assertNotNull( "window", window );

        this.window = window;
    }

    public void show() {
        if ( !wasEverShown ) {
            if ( size != null ) {
                window.setSize( size );
            }
            window.setLocationRelativeTo( SwingUtilities.getWindowAncestor( window ) );
            wasEverShown = true;
        }
        window.setVisible( true );
    }

    public T getWindow() {
        return window;
    }

}
