/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.titledtab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.PanelUI;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RotatableLabel;
import net.infonode.gui.TranslatingShape;
import net.infonode.gui.border.FocusBorder;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.gui.hover.hoverable.Hoverable;
import net.infonode.gui.icon.IconProvider;
import net.infonode.gui.layout.StackableLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;
import net.infonode.util.Alignment;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TitledTab
extends Tab
implements IconProvider {
    private static PanelUI UI = new PanelUI(){};
    private TitledTabProperties properties = TitledTabProperties.getDefaultProperties();
    private HoverListener hoverListener = this.properties.getHoverListener();
    private HoverablePanel eventPanel = new HoverablePanel((LayoutManager)new BorderLayout()){

        public boolean contains(int n, int n2) {
            return this.getComponentCount() > 0 && this.getComponent(0).contains(n, n2);
        }

        public boolean inside(int n, int n2) {
            return this.getComponentCount() > 0 && this.getComponent(0).inside(n, n2);
        }
    };
    private StatePanel normalStatePanel;
    private StatePanel highlightedStatePanel;
    private StatePanel disabledStatePanel;
    private ArrayList mouseListeners;
    private ArrayList mouseMotionListeners;
    private StackableLayout layout;
    private StatePanel currentStatePanel;
    private FocusBorder focusBorder;
    private Direction lastTabAreaOrientation = Direction.UP;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            TitledTab.this.doUpdateTab(map);
        }
    };
    private PropertyChangeListener tabbedPanelPropertiesListener = new PropertyChangeListener(){

        public void propertyChanged(Property property, Object object, Object object2, Object object3) {
            TitledTab.this.updateTabAreaOrientation((Direction)object3);
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            if (TitledTab.this.properties.getFocusable()) {
                TitledTab.this.repaint();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (TitledTab.this.properties.getFocusable()) {
                TitledTab.this.repaint();
            }
        }
    };

    public boolean contains(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this, new Point(n, n2), this.eventPanel);
        return this.eventPanel.contains(point.x, point.y);
    }

    public boolean inside(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this, new Point(n, n2), this.eventPanel);
        return this.eventPanel.inside(point.x, point.y);
    }

    public TitledTab(String string, Icon icon, JComponent jComponent, JComponent jComponent2) {
        super(jComponent);
        super.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                TitledTab.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                TitledTab.this.repaint();
            }
        });
        this.focusBorder = new FocusBorder(this);
        this.normalStatePanel = new StatePanel(this.focusBorder);
        this.highlightedStatePanel = new StatePanel(this.focusBorder);
        this.disabledStatePanel = new StatePanel(this.focusBorder);
        this.layout = new StackableLayout(this){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                StatePanel statePanel = (StatePanel)this.getVisibleComponent();
                statePanel.activateTitleComponent();
            }
        };
        this.setLayout(this.layout);
        this.add(this.normalStatePanel);
        this.add(this.highlightedStatePanel);
        this.add(this.disabledStatePanel);
        this.setText(string);
        this.setIcon(icon);
        this.setTitleComponent(jComponent2);
        this.eventPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.updateFocus(TabSelectTrigger.MOUSE_PRESS);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.updateFocus(TabSelectTrigger.MOUSE_RELEASE);
            }

            private void updateFocus(TabSelectTrigger tabSelectTrigger) {
                if (TitledTab.this.isEnabled() && TitledTab.this.properties.getFocusable() && TitledTab.this.getTabbedPanel() != null && TitledTab.this.getTabbedPanel().getProperties().getTabSelectTrigger() == tabSelectTrigger) {
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (component instanceof TitledTab && ((TitledTab)component).getTabbedPanel() == TitledTab.this.getTabbedPanel()) {
                        TitledTab.this.requestFocusInWindow();
                    } else if (TitledTab.this.isSelected() || TabbedUtils.getParentTabbedPanel(component) != TitledTab.this.getTabbedPanel()) {
                        TitledTab.this.requestFocusInWindow();
                    }
                }
            }
        });
        this.setEventComponent(this.eventPanel);
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseClicked(mouseEvent2);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mousePressed(mouseEvent2);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseReleased(mouseEvent2);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseEntered(mouseEvent2);
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseListener)objectArray[i]).mouseExited(mouseEvent2);
                    }
                }
            }
        };
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseMotionListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseMotionListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseMotionListener)objectArray[i]).mouseDragged(mouseEvent2);
                    }
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (TitledTab.this.mouseMotionListeners != null) {
                    MouseEvent mouseEvent2 = TitledTab.this.convertMouseEvent(mouseEvent);
                    Object[] objectArray = TitledTab.this.mouseMotionListeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((MouseMotionListener)objectArray[i]).mouseMoved(mouseEvent2);
                    }
                }
            }
        };
        this.eventPanel.addMouseListener(mouseListener);
        this.eventPanel.addMouseMotionListener(mouseMotionListener);
        PropertyMapWeakListenerManager.addWeakTreeListener(this.properties.getMap(), this.propertiesListener);
        this.addTabListener(new TabAdapter(){

            public void tabAdded(TabEvent tabEvent) {
                PropertyMapWeakListenerManager.addWeakPropertyChangeListener(TitledTab.this.getTabbedPanel().getProperties().getMap(), TabbedPanelProperties.TAB_AREA_ORIENTATION, TitledTab.this.tabbedPanelPropertiesListener);
                TitledTab.this.updateTabAreaOrientation(TitledTab.this.getTabbedPanel().getProperties().getTabAreaOrientation());
            }

            public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
                PropertyMapWeakListenerManager.removeWeakPropertyChangeListener(tabRemovedEvent.getTabbedPanel().getProperties().getMap(), TabbedPanelProperties.TAB_AREA_ORIENTATION, TitledTab.this.tabbedPanelPropertiesListener);
            }
        });
        this.doUpdateTab(null);
        this.updateCurrentStatePanel();
    }

    public JComponent getNormalStateTitleComponent() {
        return this.normalStatePanel.getTitleComponent();
    }

    public JComponent getHighlightedStateTitleComponent() {
        return this.highlightedStatePanel.getTitleComponent();
    }

    public JComponent getDisabledStateTitleComponent() {
        return this.disabledStatePanel.getTitleComponent();
    }

    public void setTitleComponent(JComponent jComponent) {
        this.normalStatePanel.setTitleComponent(jComponent, this.properties.getNormalProperties());
        this.highlightedStatePanel.setTitleComponent(jComponent, this.properties.getHighlightedProperties());
        this.disabledStatePanel.setTitleComponent(jComponent, this.properties.getDisabledProperties());
    }

    public void setNormalStateTitleComponent(JComponent jComponent) {
        this.normalStatePanel.setTitleComponent(jComponent, this.properties.getNormalProperties());
    }

    public void setHighlightedStateTitleComponent(JComponent jComponent) {
        this.highlightedStatePanel.setTitleComponent(jComponent, this.properties.getHighlightedProperties());
    }

    public void setDisabledStateTitleComponent(JComponent jComponent) {
        this.disabledStatePanel.setTitleComponent(jComponent, this.properties.getDisabledProperties());
    }

    public void setHighlighted(boolean bl) {
        super.setHighlighted(bl);
        this.updateCurrentStatePanel();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateCurrentStatePanel();
    }

    public String getText() {
        return this.properties.getNormalProperties().getText();
    }

    public void setText(String string) {
        this.properties.getNormalProperties().setText(string);
    }

    public Icon getIcon() {
        return this.properties.getNormalProperties().getIcon();
    }

    public void setIcon(Icon icon) {
        this.properties.getNormalProperties().setIcon(icon);
    }

    public TitledTabProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getText();
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new ArrayList(2);
        }
        this.mouseListeners.add(mouseListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(mouseListener);
            if (this.mouseListeners.size() == 0) {
                this.mouseListeners = null;
            }
        }
    }

    public synchronized MouseListener[] getMouseListeners() {
        MouseListener[] mouseListenerArray = new MouseListener[]{};
        if (this.mouseListeners != null) {
            Object[] objectArray = this.mouseListeners.toArray();
            mouseListenerArray = new MouseListener[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                mouseListenerArray[i] = (MouseListener)objectArray[i];
            }
        }
        return mouseListenerArray;
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.mouseMotionListeners == null) {
            this.mouseMotionListeners = new ArrayList(2);
        }
        this.mouseMotionListeners.add(mouseMotionListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.mouseMotionListeners != null) {
            this.mouseMotionListeners.remove(mouseMotionListener);
            if (this.mouseMotionListeners.size() == 0) {
                this.mouseMotionListeners = null;
            }
        }
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        MouseMotionListener[] mouseMotionListenerArray = new MouseMotionListener[]{};
        if (this.mouseMotionListeners != null) {
            Object[] objectArray = this.mouseMotionListeners.toArray();
            mouseMotionListenerArray = new MouseMotionListener[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                mouseMotionListenerArray[i] = (MouseMotionListener)objectArray[i];
            }
        }
        return mouseMotionListenerArray;
    }

    public Shape getShape() {
        Shape shape = this.currentStatePanel.getShape();
        if (shape == null) {
            return null;
        }
        Point point = SwingUtilities.convertPoint(this.currentStatePanel, 0, 0, this);
        return new TranslatingShape(shape, point.x, point.y);
    }

    protected void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (tabbedPanel == null) {
            HoverManager.getInstance().removeHoverable(this.eventPanel);
        }
        super.setTabbedPanel(tabbedPanel);
        if (tabbedPanel != null) {
            HoverManager.getInstance().addHoverable(this.eventPanel);
        }
    }

    private Insets getBorderInsets(Border border) {
        return border == null ? InsetsUtil.EMPTY_INSETS : border.getBorderInsets(this);
    }

    private void updateBorders() {
        Direction direction = this.getTabAreaOrientation();
        int n = this.properties.getHighlightedRaised();
        Insets insets = InsetsUtil.setInset(InsetsUtil.EMPTY_INSETS, direction, n);
        EmptyBorder emptyBorder = new EmptyBorder(insets);
        Insets insets2 = this.properties.getBorderSizePolicy() == TitledTabBorderSizePolicy.INDIVIDUAL_SIZE ? null : InsetsUtil.max(this.getBorderInsets(this.properties.getNormalProperties().getComponentProperties().getBorder()), InsetsUtil.max(this.getBorderInsets(this.properties.getHighlightedProperties().getComponentProperties().getBorder()), this.getBorderInsets(this.properties.getDisabledProperties().getComponentProperties().getBorder())));
        Insets insets3 = InsetsUtil.rotate(this.properties.getNormalProperties().getDirection(), this.properties.getNormalProperties().getComponentProperties().getInsets());
        Insets insets4 = InsetsUtil.rotate(this.properties.getDisabledProperties().getDirection(), this.properties.getDisabledProperties().getComponentProperties().getInsets());
        int n2 = Math.min(InsetsUtil.getInset(insets3, direction.getOpposite()), InsetsUtil.getInset(insets4, direction.getOpposite()));
        int n3 = Math.min(n2, n);
        Border border = this.getInnerBorder(this.properties.getNormalProperties(), direction, -n3, insets2);
        Border border2 = this.getInnerBorder(this.properties.getHighlightedProperties(), direction, n - n3, insets2);
        Border border3 = this.getInnerBorder(this.properties.getDisabledProperties(), direction, -n3, insets2);
        this.normalStatePanel.setBorders(emptyBorder, border);
        this.highlightedStatePanel.setBorders(null, border2);
        this.disabledStatePanel.setBorders(emptyBorder, border3);
    }

    private void doUpdateTab(Map map) {
        boolean bl = false;
        if (map == null) {
            bl = true;
            this.setFocusableComponent(this.properties.getFocusable() ? this : null);
            this.focusBorder.setEnabled(this.properties.getFocusMarkerEnabled());
            this.updateHoverListener(this.properties.getHoverListener());
            this.layout.setUseSelectedComponentSize(this.properties.getSizePolicy() == TitledTabSizePolicy.INDIVIDUAL_SIZE);
        } else {
            Map map2 = (Map)map.get(this.properties.getMap());
            if (map2 != null) {
                Set set = map2.keySet();
                if (set.contains(TitledTabProperties.FOCUSABLE)) {
                    this.setFocusableComponent(this.properties.getFocusable() ? this : null);
                }
                if (set.contains(TitledTabProperties.FOCUS_MARKER_ENABLED)) {
                    this.focusBorder.setEnabled(this.properties.getFocusMarkerEnabled());
                    this.currentStatePanel.getLabel().repaint();
                }
                if (set.contains(TitledTabProperties.HOVER_LISTENER)) {
                    this.updateHoverListener((HoverListener)((ValueChange)map2.get(TitledTabProperties.HOVER_LISTENER)).getNewValue());
                }
                if (set.contains(TitledTabProperties.SIZE_POLICY)) {
                    this.layout.setUseSelectedComponentSize((TitledTabSizePolicy)((ValueChange)map2.get(TitledTabProperties.SIZE_POLICY)).getNewValue() == TitledTabSizePolicy.INDIVIDUAL_SIZE);
                }
                if (set.contains(TitledTabProperties.HIGHLIGHTED_RAISED_AMOUNT) || set.contains(TitledTabProperties.BORDER_SIZE_POLICY)) {
                    bl = true;
                }
            }
        }
        bl = this.normalStatePanel.updateState(map, this.properties.getNormalProperties()) || bl;
        bl = this.highlightedStatePanel.updateState(map, this.properties.getHighlightedProperties()) || bl;
        boolean bl2 = bl = this.disabledStatePanel.updateState(map, this.properties.getDisabledProperties()) || bl;
        if (bl) {
            this.updateBorders();
        }
    }

    private void updateHoverListener(HoverListener hoverListener) {
        HoverListener hoverListener2 = this.hoverListener;
        this.hoverListener = hoverListener;
        if (HoverManager.getInstance().isHovered(this.eventPanel)) {
            if (hoverListener2 != null) {
                hoverListener2.mouseExited(new HoverEvent(this));
            }
            if (this.hoverListener != null) {
                this.hoverListener.mouseEntered(new HoverEvent(this));
            }
        }
    }

    private Border getInnerBorder(TitledTabStateProperties titledTabStateProperties, Direction direction, int n, Insets insets) {
        Direction direction2 = titledTabStateProperties.getDirection();
        Insets insets2 = InsetsUtil.rotate(direction2, titledTabStateProperties.getComponentProperties().getInsets());
        if (insets != null) {
            insets2 = InsetsUtil.add(insets2, InsetsUtil.sub(insets, this.getBorderInsets(titledTabStateProperties.getComponentProperties().getBorder())));
        }
        Border border = titledTabStateProperties.getComponentProperties().getBorder();
        EmptyBorder emptyBorder = new EmptyBorder(InsetsUtil.add(insets2, InsetsUtil.setInset(InsetsUtil.EMPTY_INSETS, direction.getOpposite(), n)));
        return border == null ? emptyBorder : new CompoundBorder(border, emptyBorder);
    }

    private Direction getTabAreaOrientation() {
        return this.getTabbedPanel() == null ? this.lastTabAreaOrientation : this.getTabbedPanel().getProperties().getTabAreaOrientation();
    }

    private void updateTabAreaOrientation(Direction direction) {
        if (this.lastTabAreaOrientation != direction) {
            this.lastTabAreaOrientation = direction;
            this.updateBorders();
            this.normalStatePanel.updateShapedPanel(this.properties.getNormalProperties());
            this.highlightedStatePanel.updateShapedPanel(this.properties.getHighlightedProperties());
            this.disabledStatePanel.updateShapedPanel(this.properties.getDisabledProperties());
        }
    }

    private void updateCurrentStatePanel() {
        StatePanel statePanel = this.normalStatePanel;
        if (!this.isEnabled()) {
            statePanel = this.disabledStatePanel;
        } else if (this.isHighlighted()) {
            statePanel = this.highlightedStatePanel;
        }
        this.eventPanel.setToolTipText(statePanel.getToolTipText());
        if (this.currentStatePanel != statePanel) {
            if (this.currentStatePanel != null) {
                this.currentStatePanel.deactivate();
            }
            this.currentStatePanel = statePanel;
            this.currentStatePanel.activate();
        }
        this.layout.showComponent(this.currentStatePanel);
    }

    private MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((JComponent)mouseEvent.getSource(), mouseEvent.getPoint(), this);
        return new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)point.getX(), (int)point.getY(), mouseEvent.getClickCount(), !mouseEvent.isConsumed() && mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public void setUI(PanelUI panelUI) {
        if (this.getUI() != UI) {
            super.setUI(UI);
        }
    }

    public void updateUI() {
        this.setUI(UI);
    }

    public void setOpaque(boolean bl) {
    }

    private class HoverablePanel
    extends SimplePanel
    implements Hoverable {
        public HoverablePanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public void hoverEnter() {
            if (TitledTab.this.hoverListener != null && TitledTab.this.getTabbedPanel() != null) {
                TitledTab.this.hoverListener.mouseEntered(new HoverEvent(TitledTab.this));
            }
        }

        public void hoverExit() {
            if (TitledTab.this.hoverListener != null) {
                TitledTab.this.hoverListener.mouseExited(new HoverEvent(TitledTab.this));
            }
        }

        public boolean acceptHover(ArrayList arrayList) {
            return true;
        }
    }

    private class StatePanel
    extends SimplePanel {
        private ShapedPanel panel = new ShapedPanel();
        private SimplePanel titleComponentPanel = new SimplePanel();
        private RotatableLabel label = new RotatableLabel(this, null, null){
            private final /* synthetic */ StatePanel this$1;
            {
                this.this$1 = statePanel;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                String string = this.getText();
                Icon icon = this.getIcon();
                if (string == null || icon == null) {
                    this.setText(" ");
                    this.setIcon(StatePanel.access$000(this.this$1));
                    dimension = this.getDirection().isHorizontal() ? new Dimension(dimension.width, super.getPreferredSize().height) : new Dimension(super.getPreferredSize().width, dimension.height);
                    this.setText(string);
                    this.setIcon(icon);
                }
                return dimension;
            }
        };
        private JComponent titleComponent;
        private Direction currentLayoutDirection;
        private int currentLayoutGap = -1;
        private Alignment currentLayoutAlignment;
        private String toolTipText;
        private Icon icon;

        public StatePanel(Border border) {
            super(new BorderLayout());
            this.label.setBorder(border);
            this.label.setMinimumSize(new Dimension(0, 0));
            this.panel.add((Component)this.label, "Center");
            this.add((Component)this.panel, "Center");
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public JComponent getTitleComponent() {
            return this.titleComponent;
        }

        public Shape getShape() {
            return this.panel.getShape();
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setTitleComponent(JComponent jComponent, TitledTabStateProperties titledTabStateProperties) {
            JComponent jComponent2 = this.titleComponent;
            this.titleComponent = null;
            if (jComponent2 != null && jComponent2.getParent() == this.titleComponentPanel) {
                this.titleComponentPanel.remove(jComponent2);
            }
            this.titleComponent = jComponent;
            this.updateLayout(titledTabStateProperties, true);
        }

        public void activateTitleComponent() {
            if (this.titleComponent != null) {
                if (this.titleComponent.getParent() != this.titleComponentPanel) {
                    if (this.titleComponent.getParent() != null) {
                        this.titleComponent.getParent().remove(this.titleComponent);
                    }
                    this.titleComponentPanel.add((Component)this.titleComponent, "Center");
                }
            } else {
                this.titleComponentPanel.removeAll();
            }
        }

        public void activate() {
            this.remove(this.panel);
            TitledTab.this.eventPanel.add((Component)this.panel, "Center");
            this.add((Component)TitledTab.this.eventPanel, "Center");
        }

        public void deactivate() {
            this.remove(TitledTab.this.eventPanel);
            TitledTab.this.eventPanel.remove(this.panel);
            this.add((Component)this.panel, "Center");
        }

        public Dimension getPreferredSize() {
            this.activateTitleComponent();
            return this.getAdjustedSize(super.getPreferredSize());
        }

        public Dimension getMinimumSize() {
            this.activateTitleComponent();
            return this.getAdjustedSize(super.getMinimumSize());
        }

        public Dimension getMaximumSize() {
            this.activateTitleComponent();
            return super.getMaximumSize();
        }

        private Dimension getAdjustedSize(Dimension dimension) {
            DimensionProvider dimensionProvider = TitledTab.this.properties.getMinimumSizeProvider();
            if (dimensionProvider == null) {
                return dimension;
            }
            Dimension dimension2 = TitledTab.this.properties.getMinimumSizeProvider().getDimension(this);
            if (dimension2 == null) {
                return dimension;
            }
            return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
        }

        public JComponent getFocusableComponent() {
            return this.label;
        }

        private void updateLayout(TitledTabStateProperties titledTabStateProperties, boolean bl) {
            if (this.titleComponent != null && titledTabStateProperties.getTitleComponentVisible()) {
                Direction direction = titledTabStateProperties.getDirection();
                int n = titledTabStateProperties.getIconVisible() || titledTabStateProperties.getTextVisible() ? titledTabStateProperties.getTextTitleComponentGap() : 0;
                Alignment alignment = titledTabStateProperties.getTitleComponentTextRelativeAlignment();
                if (this.titleComponentPanel.getComponentCount() == 0 || this.titleComponentPanel.getComponentCount() > 0 && this.titleComponentPanel.getComponent(0) != this.titleComponent || bl || n != this.currentLayoutGap || alignment != this.currentLayoutAlignment || direction != this.currentLayoutDirection) {
                    bl = false;
                    this.currentLayoutDirection = direction;
                    this.currentLayoutGap = n;
                    this.currentLayoutAlignment = alignment;
                    this.panel.remove(this.titleComponentPanel);
                    if (direction == Direction.UP) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "South" : "North");
                        this.titleComponentPanel.setBorder(new EmptyBorder(alignment == Alignment.LEFT ? n : 0, 0, alignment == Alignment.LEFT ? 0 : n, 0));
                    } else if (direction == Direction.LEFT) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "East" : "West");
                        this.titleComponentPanel.setBorder(new EmptyBorder(0, alignment == Alignment.LEFT ? n : 0, 0, alignment == Alignment.LEFT ? 0 : n));
                    } else if (direction == Direction.DOWN) {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "North" : "South");
                        this.titleComponentPanel.setBorder(new EmptyBorder(alignment == Alignment.LEFT ? 0 : n, 0, alignment == Alignment.LEFT ? n : 0, 0));
                    } else {
                        this.panel.add((Component)this.titleComponentPanel, alignment == Alignment.LEFT ? "West" : "East");
                        this.titleComponentPanel.setBorder(new EmptyBorder(0, alignment == Alignment.LEFT ? 0 : n, 0, alignment == Alignment.LEFT ? n : 0));
                    }
                    this.panel.revalidate();
                }
            } else {
                this.panel.remove(this.titleComponentPanel);
                this.titleComponentPanel.removeAll();
                this.panel.revalidate();
            }
        }

        public void updateShapedPanel(TitledTabStateProperties titledTabStateProperties) {
            Direction direction = TitledTab.this.getTabAreaOrientation();
            ShapedPanelProperties shapedPanelProperties = titledTabStateProperties.getShapedPanelProperties();
            InternalPropertiesUtil.applyTo(shapedPanelProperties, this.panel, direction.getNextCW());
            this.panel.setHorizontalFlip(direction == Direction.DOWN || direction == Direction.LEFT ? !shapedPanelProperties.getHorizontalFlip() : shapedPanelProperties.getHorizontalFlip());
        }

        public void setBorders(Border border, Border border2) {
            this.setBorder(border);
            this.panel.setBorder(border2);
        }

        public boolean updateState(Map map, TitledTabStateProperties titledTabStateProperties) {
            boolean bl = false;
            if (map == null) {
                this.label.setText(titledTabStateProperties.getTextVisible() ? titledTabStateProperties.getText() : null);
                this.icon = titledTabStateProperties.getIcon();
                this.label.setIcon(titledTabStateProperties.getIconVisible() ? titledTabStateProperties.getIcon() : null);
                this.label.setIconTextGap(titledTabStateProperties.getIconTextGap());
                this.label.setDirection(titledTabStateProperties.getDirection());
                Alignment alignment = titledTabStateProperties.getIconTextRelativeAlignment();
                this.label.setHorizontalTextPosition(alignment == Alignment.LEFT ? 4 : 2);
                alignment = titledTabStateProperties.getHorizontalAlignment();
                this.label.setHorizontalAlignment(alignment == Alignment.LEFT ? 2 : (alignment == Alignment.CENTER ? 0 : 4));
                alignment = titledTabStateProperties.getVerticalAlignment();
                this.label.setVerticalAlignment(alignment == Alignment.TOP ? 1 : (alignment == Alignment.CENTER ? 0 : 3));
                String string = this.toolTipText = titledTabStateProperties.getToolTipEnabled() ? titledTabStateProperties.getToolTipText() : null;
                if (this.toolTipText != null && this.toolTipText.length() == 0) {
                    this.toolTipText = null;
                }
                if (TitledTab.this.currentStatePanel == this) {
                    TitledTab.this.eventPanel.setToolTipText(this.toolTipText);
                }
                this.updateLayout(titledTabStateProperties, true);
                ComponentProperties componentProperties = titledTabStateProperties.getComponentProperties();
                this.label.setFont(componentProperties.getFont());
                Color color = componentProperties.getForegroundColor();
                this.label.setForeground(color);
                this.setForeground(color);
                this.updateShapedPanel(titledTabStateProperties);
                bl = true;
            } else {
                Serializable serializable;
                Set set;
                Map map2 = (Map)map.get(titledTabStateProperties.getMap());
                if (map2 != null) {
                    set = map2.keySet();
                    if (set.contains(TitledTabStateProperties.TEXT) || set.contains(TitledTabStateProperties.TEXT_VISIBLE)) {
                        this.label.setText(titledTabStateProperties.getTextVisible() ? titledTabStateProperties.getText() : null);
                    }
                    if (set.contains(TitledTabStateProperties.ICON) || set.contains(TitledTabStateProperties.ICON_VISIBLE)) {
                        this.icon = titledTabStateProperties.getIcon();
                        this.label.setIcon(titledTabStateProperties.getIconVisible() ? titledTabStateProperties.getIcon() : null);
                    }
                    if (set.contains(TitledTabStateProperties.ICON_TEXT_GAP)) {
                        this.label.setIconTextGap((Integer)((ValueChange)map2.get(TitledTabStateProperties.ICON_TEXT_GAP)).getNewValue());
                    }
                    if (set.contains(TitledTabStateProperties.ICON_TEXT_RELATIVE_ALIGNMENT)) {
                        serializable = (Alignment)((ValueChange)map2.get(TitledTabStateProperties.ICON_TEXT_RELATIVE_ALIGNMENT)).getNewValue();
                        this.label.setHorizontalTextPosition(serializable == Alignment.LEFT ? 4 : 2);
                    }
                    if (set.contains(TitledTabStateProperties.HORIZONTAL_ALIGNMENT)) {
                        serializable = (Alignment)((ValueChange)map2.get(TitledTabStateProperties.HORIZONTAL_ALIGNMENT)).getNewValue();
                        this.label.setHorizontalAlignment(serializable == Alignment.LEFT ? 2 : (serializable == Alignment.CENTER ? 0 : 4));
                    }
                    if (set.contains(TitledTabStateProperties.VERTICAL_ALIGNMENT)) {
                        serializable = (Alignment)((ValueChange)map2.get(TitledTabStateProperties.VERTICAL_ALIGNMENT)).getNewValue();
                        this.label.setVerticalAlignment(serializable == Alignment.TOP ? 1 : (serializable == Alignment.CENTER ? 0 : 3));
                    }
                    if (set.contains(TitledTabStateProperties.TOOL_TIP_TEXT) || set.contains(TitledTabStateProperties.TOOL_TIP_ENABLED)) {
                        String string = this.toolTipText = titledTabStateProperties.getToolTipEnabled() ? titledTabStateProperties.getToolTipText() : null;
                        if (this.toolTipText != null && this.toolTipText.length() == 0) {
                            this.toolTipText = null;
                        }
                        if (TitledTab.this.currentStatePanel == this) {
                            TitledTab.this.eventPanel.setToolTipText(this.toolTipText);
                        }
                    }
                    if (set.contains(TitledTabStateProperties.DIRECTION) || set.contains(TitledTabStateProperties.TITLE_COMPONENT_TEXT_RELATIVE_ALIGNMENT) || set.contains(TitledTabStateProperties.TITLE_COMPONENT_VISIBLE) || set.contains(TitledTabStateProperties.TEXT_TITLE_COMPONENT_GAP) || set.contains(TitledTabStateProperties.ICON_VISIBLE) || set.contains(TitledTabStateProperties.TEXT_VISIBLE)) {
                        this.label.setDirection(titledTabStateProperties.getDirection());
                        this.updateLayout(titledTabStateProperties, set.contains(TitledTabStateProperties.TITLE_COMPONENT_VISIBLE));
                    }
                    if (set.contains(TitledTabStateProperties.DIRECTION)) {
                        bl = true;
                    }
                }
                if ((map2 = (Map)map.get(titledTabStateProperties.getComponentProperties().getMap())) != null) {
                    set = map2.keySet();
                    if (set.contains(ComponentProperties.FONT)) {
                        this.label.setFont((Font)((ValueChange)map2.get(ComponentProperties.FONT)).getNewValue());
                    }
                    if (set.contains(ComponentProperties.FOREGROUND_COLOR)) {
                        serializable = (Color)((ValueChange)map2.get(ComponentProperties.FOREGROUND_COLOR)).getNewValue();
                        this.label.setForeground((Color)serializable);
                        this.setForeground((Color)serializable);
                    }
                    if (set.contains(ComponentProperties.BACKGROUND_COLOR)) {
                        serializable = (Color)((ValueChange)map2.get(ComponentProperties.BACKGROUND_COLOR)).getNewValue();
                        this.panel.setBackground((Color)serializable);
                    }
                    if (set.contains(ComponentProperties.INSETS) || set.contains(ComponentProperties.BORDER)) {
                        bl = true;
                    }
                }
                if ((map2 = (Map)map.get(titledTabStateProperties.getShapedPanelProperties().getMap())) != null) {
                    this.updateShapedPanel(titledTabStateProperties);
                }
            }
            return bl;
        }

        static /* synthetic */ Icon access$000(StatePanel statePanel) {
            return statePanel.icon;
        }
    }
}

