/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryReinvestDivX;
import jgnash.engine.TransactionFactory;
import jgnash.ui.UIApplication;
import jgnash.ui.components.AccountSecurityComboBox;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.invest.AbstractInvTransactionPanel;
import jgnash.ui.register.invest.FeePanel;
import jgnash.ui.register.invest.GainsPanel;
import jgnash.ui.util.ValidationFactory;

public class ReinvestDividendPanel
extends AbstractInvTransactionPanel {
    private DatePanel datePanel;
    private JFloatField priceField;
    private JFloatField quantityField;
    private FeePanel feePanel;
    private GainsPanel gainsPanel;
    private JTextField memoField;
    private JFloatField totalField;
    private AccountSecurityComboBox securityCombo;
    private Logger logger = UIApplication.getLogger();

    protected ReinvestDividendPanel(Account account) {
        super(account);
        this.datePanel = new DatePanel();
        this.feePanel = new FeePanel(account);
        this.gainsPanel = new GainsPanel(account);
        this.memoField = AutoCompleteFactory.getMemoField();
        this.priceField = new JFloatField(0, 6, (int)account.getCurrencyNode().getScale());
        this.quantityField = new JFloatField(0, 6, 2);
        this.totalField = new JFloatField(account.getCurrencyNode());
        this.totalField.setEditable(false);
        this.totalField.setFocusable(false);
        this.securityCombo = new AccountSecurityComboBox(account);
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.layoutMainPanel();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ReinvestDividendPanel.this.updateTotalField();
            }
        };
        this.feePanel.addFocusListener(focusListener);
        this.quantityField.addFocusListener(focusListener);
        this.priceField.addFocusListener(focusListener);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.feePanel.addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.priceField.addKeyListener(this.keyListener);
        this.quantityField.addKeyListener(this.keyListener);
        this.securityCombo.addKeyListener(this.keyListener);
        this.reconciledButton.addKeyListener(this.keyListener);
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(65dlu;min)", "f:d, $lgap, f:d, $lgap, f:d, $lgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        JPanel subPanel = this.buildHorizontalSubPanel("max(48dlu;min):g(0.5), 8dlu, d, $lcgap, max(48dlu;min):g(0.5), 8dlu, d, 4dlu, max(48dlu;min)", new Object[]{ValidationFactory.wrap(this.priceField), "Label.Quantity", ValidationFactory.wrap(this.quantityField), "Label.Gains", this.gainsPanel});
        this.add("Label.Security", (Object)cc.xy(1, 1));
        this.add((Component)ValidationFactory.wrap(this.securityCombo), (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Price", (Object)cc.xy(1, 3));
        this.add((Component)subPanel, (Object)cc.xy(3, 3));
        this.add("Label.Fees", (Object)cc.xy(5, 3));
        this.add((Component)this.feePanel, (Object)cc.xy(7, 3));
        this.add("Label.Memo", (Object)cc.xy(1, 5));
        this.add((Component)this.memoField, (Object)cc.xy(3, 5));
        this.add("Label.Total", (Object)cc.xy(5, 5));
        this.add((Component)this.totalField, (Object)cc.xy(7, 5));
        this.add((Component)this.reconciledButton, (Object)cc.xyw(1, 7, 5));
    }

    void updateTotalField() {
        BigDecimal fee = this.feePanel.getDecimal();
        BigDecimal quantity = this.quantityField.getDecimal();
        BigDecimal price = this.priceField.getDecimal();
        BigDecimal value = quantity.multiply(price);
        value = value.subtract(fee);
        this.totalField.setDecimal(value);
    }

    @Override
    public void modifyTransaction(Transaction tran) {
        if (!(tran instanceof InvestmentTransaction)) {
            throw new IllegalArgumentException("bad tranType");
        }
        this.clearForm();
        this.datePanel.setDate(tran.getDate());
        List<TransactionEntry> entries = tran.getTransactionEntries();
        this.feePanel.setTransactionEntries(((InvestmentTransaction)tran).getInvestmentFeeEntries());
        this.gainsPanel.setTransactionEntries(((InvestmentTransaction)tran).getInvestmentGainLossEntries());
        for (TransactionEntry e : entries) {
            if (!(e instanceof TransactionEntryReinvestDivX)) continue;
            AbstractInvestmentTransactionEntry entry = (AbstractInvestmentTransactionEntry)e;
            this.memoField.setText(e.getMemo());
            this.priceField.setDecimal(entry.getPrice());
            this.quantityField.setDecimal(entry.getQuantity());
            this.securityCombo.setSelectedNode(entry.getSecurityNode());
        }
        this.updateTotalField();
        this.modTrans = tran;
        this.reconciledButton.setSelected(tran.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
    }

    @Override
    public Transaction buildTransaction() {
        List<TransactionEntry> fees = this.feePanel.getTransactions();
        List<TransactionEntry> gains = this.gainsPanel.getTransactions();
        return TransactionFactory.generateReinvDividendXTransaction(this.account, (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected(), fees, gains);
    }

    @Override
    public void clearForm() {
        this.modTrans = null;
        if (!ReinvestDividendPanel.getRememberLastDate()) {
            this.datePanel.setDate(new Date());
        }
        this.memoField.setText(null);
        this.priceField.setDecimal(null);
        this.quantityField.setDecimal(null);
        this.feePanel.clearForm();
        this.gainsPanel.clearForm();
        this.reconciledButton.setSelected(false);
        this.updateTotalField();
    }

    @Override
    public boolean validateForm() {
        if (this.securityCombo.getSelectedNode() == null) {
            this.logger.warning(this.rb.getString("Message.Error.SecuritySelection"));
            this.showValidationError(this.rb.getString("Message.Error.SecuritySelection"), this.securityCombo);
            return false;
        }
        if (this.priceField.getText().equals("")) {
            this.logger.warning(this.rb.getString("Message.Error.SecurityPrice"));
            this.showValidationError(this.rb.getString("Message.Error.SecurityPrice"), this.priceField);
            return false;
        }
        if (this.quantityField.getText().equals("")) {
            this.logger.warning(this.rb.getString("Message.Error.SecurityQuantity"));
            this.showValidationError(this.rb.getString("Message.Error.SecurityQuantity"), this.quantityField);
            return false;
        }
        return true;
    }

    @Override
    protected void cancelAction() {
        this.clearForm();
    }
}

