/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.ui.UIApplication;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.TransactionNumberComboBox;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class DateChkNumberDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private JButton okButton;
    private JButton cancelButton;
    DatePanel datePanel;
    TransactionNumberComboBox numberCombo;
    private Account account;
    private boolean result = false;

    protected DateChkNumberDialog(Account a, String title) {
        super((Window)UIApplication.getFrame(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(UIApplication.getFrame());
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.account = a;
        this.buildPanel();
        if (a != null) {
            this.numberCombo.setText(a.getNextTransactionNumber());
        }
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void initComponents() {
        this.datePanel = new DatePanel();
        this.numberCombo = new TransactionNumberComboBox(this.account);
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void buildPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("max(20dlu;d), 4dlu, 75dlu:grow(1.0)", "f:d, 3dlu, f:d, 10dlu, f:d");
        CellConstraints cc = new CellConstraints();
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        JPanel p = new JPanel((LayoutManager)layout);
        p.setBorder(Borders.DIALOG_BORDER);
        p.add((Component)new JLabel(this.rb.getString("Label.Date")), cc.xy(1, 1));
        p.add((Component)this.datePanel, cc.xy(3, 1));
        p.add((Component)new JLabel(this.rb.getString("Label.Number")), cc.xy(1, 3));
        p.add((Component)this.numberCombo, cc.xy(3, 3));
        p.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), cc.xyw(1, 5, 3));
        this.getContentPane().add((Component)p, "Center");
    }

    void okAction() {
        this.result = true;
        this.closeDialog();
    }

    public Date getDate() {
        return this.datePanel.getDate();
    }

    public String getNumber() {
        return this.numberCombo.getText();
    }

    public boolean getResult() {
        return this.result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.okAction();
        } else if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        }
    }
}

