/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.plaf;

import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class NimbusUtils {
    static float growthPercentage = 1.0f;

    public static int getBaseFontSize() {
        int baseSize = 12;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Object object = defaults.get("Label.font");
        if (object != null) {
            if (object instanceof Font) {
                baseSize = ((Font)object).getSize();
            } else if (object instanceof FontUIResource) {
                baseSize = ((FontUIResource)object).getSize();
            }
        }
        return baseSize;
    }

    public static void changeFontSize(int size) {
        String key;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        float baseSize = NimbusUtils.getBaseFontSize();
        growthPercentage = (float)size / baseSize;
        for (Object keyObj : defaults.keySet()) {
            Font derived;
            if (!(keyObj instanceof String) || !(key = (String)keyObj).contains("font")) continue;
            Object object = defaults.get(key);
            if (object instanceof Font) {
                Font font = (Font)object;
                derived = font.deriveFont((float)size);
                defaults.put(key, derived);
                continue;
            }
            if (!(object instanceof FontUIResource)) continue;
            FontUIResource resource = (FontUIResource)object;
            derived = new FontUIResource(resource.deriveFont((float)size));
            defaults.put(key, derived);
        }
        for (Object keyObj : defaults.keySet()) {
            if (!(keyObj instanceof String) || !(key = (String)keyObj).contains("contentMargins") && !key.contains("padding")) continue;
            Insets derived = (Insets)((Insets)defaults.get(key)).clone();
            if (derived.left > 0) {
                derived.left = (int)Math.ceil((float)derived.left * growthPercentage);
            }
            if (derived.right > 0) {
                derived.right = (int)Math.ceil((float)derived.right * growthPercentage);
            }
            if (derived.top > 0) {
                derived.top = (int)Math.ceil((float)derived.top * growthPercentage);
            }
            if (derived.bottom > 0) {
                derived.bottom = (int)Math.ceil((float)derived.bottom * growthPercentage);
            }
            defaults.put(key, derived);
        }
        for (Object keyObj : defaults.keySet()) {
            if (!(keyObj instanceof String) || !(key = (String)keyObj).contains("textIconGap") && !key.contains("size") && !key.contains("thumbWidth") && !key.contains("thumbHeight")) continue;
            Integer integer = (Integer)defaults.get(key);
            Integer derived = (int)Math.ceil((float)integer.intValue() * growthPercentage);
            defaults.put(key, derived);
        }
    }

    public static Icon scaleIcon(ImageIcon icon) {
        int scaledWidth = (int)Math.floor((float)icon.getIconWidth() * growthPercentage);
        int scaledHeight = (int)Math.floor((float)icon.getIconHeight() * growthPercentage);
        Image scaledInstance = icon.getImage().getScaledInstance(scaledWidth, scaledHeight, 4);
        return new ImageIcon(scaledInstance);
    }

    public static void reduceNimbusButtonMargin(JButton button) {
        UIDefaults buttonDefaults = new UIDefaults();
        buttonDefaults.put("Button.contentMargins", new Insets(6, 6, 6, 6));
        button.putClientProperty("Nimbus.Overrides", buttonDefaults);
        button.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
    }

    private NimbusUtils() {
    }
}

