/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.option;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgnash.net.ConnectionFactory;
import jgnash.net.NetworkAuthenticator;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.util.Resource;

class NetworkOptions
extends JPanel
implements ActionListener,
FocusListener {
    private final Resource rb = Resource.get();
    private JCheckBox authCheckBox;
    private JTextField hostField;
    private JTextField nameField;
    private JPasswordField passwordField;
    private JIntegerField portField;
    private JCheckBox proxyCheckBox;
    private JSpinner connectionTimeout;

    protected NetworkOptions() {
        this.layoutMainPanel();
        this.showState();
        this.proxyAction();
        this.authAction();
        this.proxyCheckBox.addActionListener(this);
        this.authCheckBox.addActionListener(this);
        this.hostField.addFocusListener(this);
        this.portField.addFocusListener(this);
        this.nameField.addFocusListener(this);
        this.passwordField.addFocusListener(this);
        this.connectionTimeout.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConnectionFactory.setConnectionTimeout(((SpinnerNumberModel)NetworkOptions.this.connectionTimeout.getModel()).getNumber().intValue());
            }
        });
    }

    private void initComponents() {
        this.proxyCheckBox = new JCheckBox(this.rb.getString("Button.UseProxy"));
        this.hostField = new JTextFieldEx();
        this.portField = new JIntegerField();
        this.authCheckBox = new JCheckBox(this.rb.getString("Button.HTTPAuth"));
        this.nameField = new JTextFieldEx();
        this.passwordField = new JPasswordField();
        SpinnerNumberModel model = new SpinnerNumberModel(ConnectionFactory.getConnectionTimeout(), 10, 120, 1);
        this.connectionTimeout = new JSpinner(model);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("right:p, $lcgap, max(55dlu;p), $lcgap, min:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setRowGroupingEnabled(true);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.HTTPProxy"));
        builder.append((Component)this.proxyCheckBox, 5);
        builder.append(this.rb.getString("Label.Host"), (Component)this.hostField, 3);
        builder.append(this.rb.getString("Label.Port"), (Component)this.portField, 3);
        builder.append((Component)this.authCheckBox, 5);
        builder.append(this.rb.getString("Label.UserName"), (Component)this.nameField, 3);
        builder.append(this.rb.getString("Label.Password"), (Component)this.passwordField, 3);
        builder.appendSeparator(this.rb.getString("Title.Connection"));
        builder.append(this.rb.getString("Label.ConnTimeout"), (Component)this.connectionTimeout);
        builder.append(this.rb.getString("Word.Seconds"));
    }

    private void showState() {
        this.proxyCheckBox.setSelected(NetworkAuthenticator.isProxyUsed());
        this.hostField.setText(NetworkAuthenticator.getHost());
        this.portField.setIntValue(NetworkAuthenticator.getPort());
        this.authCheckBox.setSelected(NetworkAuthenticator.isAuthenticationUsed());
        this.nameField.setText(NetworkAuthenticator.getName());
        this.passwordField.setText(NetworkAuthenticator.getPassword());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.proxyCheckBox) {
            this.proxyAction();
        } else if (e.getSource() == this.authCheckBox) {
            this.authAction();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.portField) {
            this.portAction();
        } else if (e.getSource() == this.hostField) {
            this.hostAction();
        } else if (e.getSource() == this.nameField) {
            this.nameAction();
        } else if (e.getSource() == this.passwordField) {
            this.passwordAction();
        }
    }

    private void proxyAction() {
        NetworkAuthenticator.setUseProxy(this.proxyCheckBox.isSelected());
        if (this.proxyCheckBox.isSelected()) {
            this.hostField.setEnabled(true);
            this.portField.setEnabled(true);
            System.getProperties().put("http.proxyPort", this.portField.getText());
            System.getProperties().put("http.proxyHost", this.hostField.getText());
        } else {
            this.hostField.setEnabled(false);
            this.portField.setEnabled(false);
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.proxyHost");
        }
    }

    private void portAction() {
        int port = this.portField.intValue();
        NetworkAuthenticator.setPort(port);
        if (this.portField.getText().length() != 0 && port > 0) {
            System.getProperties().put("http.proxyPort", (Object)port);
        } else {
            System.getProperties().remove("http.proxyPort");
        }
    }

    private void hostAction() {
        String host = this.hostField.getText();
        NetworkAuthenticator.setHost(host);
        if (host.length() != 0) {
            System.getProperties().put("http.proxyHost", host);
        } else {
            System.getProperties().remove("http.proxyHost");
        }
    }

    private void authAction() {
        NetworkAuthenticator.setUseAuthentication(this.authCheckBox.isSelected());
        if (this.authCheckBox.isSelected()) {
            this.nameField.setEnabled(true);
            this.passwordField.setEnabled(true);
        } else {
            this.nameField.setEnabled(false);
            this.passwordField.setEnabled(false);
        }
    }

    private void nameAction() {
        NetworkAuthenticator.setName(this.nameField.getText());
    }

    private void passwordAction() {
        NetworkAuthenticator.setPassword(new String(this.passwordField.getPassword()));
    }
}

