/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import jgnash.util.Resource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;

public class SubstanceFontSlider
extends JPanel {
    private static final String ADJUSTMENT_KEY = "adjustment";
    private static final String SUBSTANCE_FONT_SET = "Substance";
    private JLabel fontSizeLabel;
    private static int baseSize = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont().getSize();

    public SubstanceFontSlider() {
        FormLayout layout = new FormLayout("fill:pref, 1dlu, 50dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout((LayoutManager)layout);
        this.fontSizeLabel = new JLabel();
        this.fontSizeLabel.setText(baseSize + " pt.");
        builder.append((Component)this.fontSizeLabel);
        final JSlider slider = new JSlider(-3, 6, 0);
        slider.setFocusable(false);
        slider.setMinorTickSpacing(1);
        slider.setSnapToTicks(true);
        slider.setToolTipText(Resource.get().getString("ToolTip.FontSize"));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceFontSlider.this.fontSizeLabel.setText(slider.getValue() + baseSize + " pt.");
                    }
                });
                if (!slider.getModel().getValueIsAdjusting()) {
                    int adjust = slider.getValue();
                    SubstanceFontSlider.this.adjustSize(adjust);
                    Preferences.userNodeForPackage(SubstanceFontSlider.class).putInt(SubstanceFontSlider.ADJUSTMENT_KEY, adjust);
                }
            }
        });
        builder.append((Component)slider);
        int adjust = Preferences.userNodeForPackage(SubstanceFontSlider.class).getInt(ADJUSTMENT_KEY, 0);
        if (adjust != 0) {
            this.adjustSize(adjust);
        }
    }

    private void adjustSize(final int adjust) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceLookAndFeel.setFontPolicy(null);
                final FontSet substanceCoreFontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet(SubstanceFontSlider.SUBSTANCE_FONT_SET, null);
                FontPolicy newFontPolicy = new FontPolicy(){

                    public FontSet getFontSet(String lafName, UIDefaults table) {
                        return new WrapperFontSet(substanceCoreFontSet, adjust);
                    }
                };
                SubstanceLookAndFeel.setFontPolicy((FontPolicy)newFontPolicy);
                SubstanceFontSlider.this.fontSizeLabel.setText(adjust + baseSize + " pt.");
            }
        });
    }

    private static class WrapperFontSet
    implements FontSet {
        private int adjust;
        private FontSet delegate;

        public WrapperFontSet(FontSet delegate, int adjust) {
            this.delegate = delegate;
            this.adjust = adjust;
        }

        private FontUIResource getWrappedFont(FontUIResource systemFont) {
            return new FontUIResource(systemFont.getFontName(), systemFont.getStyle(), systemFont.getSize() + this.adjust);
        }

        public FontUIResource getControlFont() {
            return this.getWrappedFont(this.delegate.getControlFont());
        }

        public FontUIResource getMenuFont() {
            return this.getWrappedFont(this.delegate.getMenuFont());
        }

        public FontUIResource getMessageFont() {
            return this.getWrappedFont(this.delegate.getMessageFont());
        }

        public FontUIResource getSmallFont() {
            return this.getWrappedFont(this.delegate.getSmallFont());
        }

        public FontUIResource getTitleFont() {
            return this.getWrappedFont(this.delegate.getTitleFont());
        }

        public FontUIResource getWindowTitleFont() {
            return this.getWrappedFont(this.delegate.getWindowTitleFont());
        }
    }
}

