/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JButton;
import javax.swing.JDialog;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.ui.MainFrame;
import jgnash.ui.components.ExceptionDialog;
import jgnash.ui.report.FontRegistry;
import jgnash.ui.splash.AboutDialog;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class UIApplication
implements Thread.UncaughtExceptionHandler {
    private static final String helpHS = "default/jhelpset.hs";
    private static final String ACCEPT_LICENSE = "licenseaccepted";
    public static final String NEWACCOUNT_ID = "NewAccount";
    public static final String INTRODUCTION_ID = "Introduction";
    public static final String REPORTS_ID = "Reports";
    private final Preferences pref = Preferences.userNodeForPackage(UIApplication.class);
    private static MainFrame frame;
    private static HelpBroker helpBroker;
    private static Logger logger;

    public UIApplication(final File file) {
        if (this.initFrame()) {
            FontRegistry.registerFonts();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (file != null) {
                        frame.loadFile(file);
                    } else if (EngineFactory.openLastOnStartup()) {
                        frame.loadLast();
                    }
                }
            });
        }
    }

    public UIApplication(final String host, final int port, final String user, final String password) {
        if (this.initFrame()) {
            FontRegistry.registerFonts();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.openRemote(host, port, user, password);
                }
            });
        }
    }

    private boolean initFrame() {
        boolean result = false;
        Thread.setDefaultUncaughtExceptionHandler(this);
        if (!this.pref.getBoolean(ACCEPT_LICENSE, false)) {
            if (AboutDialog.showAcceptLicenseDialog()) {
                this.pref.putBoolean(ACCEPT_LICENSE, true);
            } else {
                System.err.println(Resource.get().getString("Message.ErrorLicense"));
            }
        }
        if (this.pref.getBoolean(ACCEPT_LICENSE, false)) {
            result = true;
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frame = new MainFrame();
                        frame.setVisible(true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static MainFrame getFrame() {
        return frame;
    }

    public static HelpBroker getHelpBroker() {
        if (helpBroker == null) {
            ClassLoader cl = UIApplication.class.getClassLoader();
            try {
                URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
                HelpSet hs = new HelpSet(null, hsURL);
                helpBroker = hs.createHelpBroker();
            }
            catch (Exception ee) {
                System.err.println("HelpSet " + ee.getMessage());
                System.err.println("HelpSet default/jhelpset.hs not found");
            }
        }
        return helpBroker;
    }

    public static void enableHelpOnButton(JButton button, final String id) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIApplication.showHelp(id);
            }
        });
    }

    public static void showHelp(String id) {
        HelpBroker broker = UIApplication.getHelpBroker();
        if (broker != null) {
            JHelp jHelp = new JHelp(broker.getHelpSet());
            try {
                if (id != null) {
                    jHelp.setCurrentID(id);
                }
            }
            catch (BadIDException e) {
                System.err.println("Invalid help ID: " + id);
            }
            Frame frame = UIApplication.getFrame();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getActiveWindow();
            if (window != null && window instanceof Frame) {
                frame = (Frame)window;
            }
            JDialog dialog = new JDialog(frame, Resource.get().getString("Title.Help"), true);
            dialog.setDefaultCloseOperation(2);
            dialog.getContentPane().add((Component)jHelp, 0);
            dialog.setMinimumSize(new Dimension(500, 400));
            dialog.setSize(new Dimension(500, 640));
            dialog.setLocationRelativeTo(UIApplication.getFrame());
            DialogUtils.addBoundsListener(dialog);
            dialog.setVisible(true);
        }
    }

    public static void repaint() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.repaint();
            }
        });
    }

    @Override
    public void uncaughtException(Thread t, final Throwable e) {
        if (e.getStackTrace()[0].getClassName().contains("help.plaf")) {
            return;
        }
        e.printStackTrace();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExceptionDialog((Frame)UIApplication.getFrame(), e).setVisible(true);
            }
        });
    }

    public static void restartUI() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                helpBroker = null;
                frame.setVisible(false);
                frame.dispose(false);
                frame = new MainFrame();
                frame.dispose(false);
                frame = new MainFrame();
                frame.setVisible(true);
                if (EngineFactory.getEngine("default") != null) {
                    MessageBus messageBus = MessageBus.getInstance(EngineFactory.getEngine("default").getName());
                    Message message = new Message(MessageChannel.SYSTEM, ChannelEvent.UI_RESTARTED, EngineFactory.getEngine("default"));
                    messageBus.fireEvent(message);
                }
            }
        });
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        logger = Logger.getLogger(UIApplication.class.getName());
    }
}

