/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import com.jgoodies.looks.Options;
import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import jgnash.ui.UIApplication;
import jgnash.ui.plaf.NimbusUtils;
import jgnash.util.Resource;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class ThemeManager {
    private static long animationDuration = 200L;
    private final Resource rb = Resource.get();
    private JMenu themesMenu = null;
    private ArrayList<Object> themeList = new ArrayList();
    private static final String SUBSTANCE_ANIMATIONS = "substanceAnimations";
    private static final String NIMBUS_FONT_SIZE = "nimbusFontSize";
    private static final String STEEL = "javax.swing.plaf.metal.DefaultMetalTheme";
    private static final String OCEAN = "javax.swing.plaf.metal.OceanTheme";
    private static String DEFAULT_THEME = "javax.swing.plaf.metal.OceanTheme";
    private static final String LF = "lookandfeel3";
    private static final String THEME = "theme3";
    private static final String[] KNOWN = new String[]{"com.jgoodies.looks.plastic.PlasticLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel", "com.sun.java.swing.plaf.mac.MacLookAndFeel", "com.nilo.plaf.nimrod.NimRODLookAndFeel", "de.muntjak.tinylookandfeel.TinyLookAndFeel"};

    protected ThemeManager(JFrame frame) {
        UIManager.getLookAndFeelDefaults().put("ClassLoader", frame.getClass().getClassLoader());
        try {
            Options.setPopupDropShadowEnabled((boolean)true);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
        ThemeManager.setLookAndFeel(pref.get(LF, UIManager.getCrossPlatformLookAndFeelClassName()));
    }

    public static boolean isLookAndFeelOSX() {
        return UIManager.getLookAndFeel().getName().startsWith("Mac");
    }

    public static boolean isLookAndFeelNimbus() {
        return UIManager.getLookAndFeel().getName().startsWith("Nimbus");
    }

    public static boolean isLookAndFeelJGoodies() {
        return UIManager.getLookAndFeel().getClass().getName().contains("jgoodies");
    }

    public static boolean isLookAndFeelMotif() {
        return UIManager.getLookAndFeel().getClass().getName().contains("motif");
    }

    public static boolean isLookAndFeelSubstance() {
        return UIManager.getLookAndFeel().getClass().getName().contains("Substance");
    }

    private static void setTheme(String theme) {
        try {
            Class<?> themeClass = Class.forName(theme);
            MetalTheme themeObject = (MetalTheme)themeClass.newInstance();
            MetalLookAndFeel.setCurrentTheme(themeObject);
        }
        catch (Exception e) {
            Logger.getLogger(ThemeManager.class.getName()).severe("Could not install theme: " + theme + "\n" + e.toString());
        }
    }

    private static void setLookAndFeel(String lookAndFeel) {
        Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
        String theme = pref.get(THEME, DEFAULT_THEME);
        try {
            Class<?> lafClass = Class.forName(lookAndFeel);
            Object lafInstance = lafClass.newInstance();
            if (lafInstance instanceof SubstanceSkin) {
                UIManager.put("substancelaf.addWidgets", Boolean.TRUE);
                if (ThemeManager.isSubstanceAnimationsEnabled()) {
                    AnimationConfigurationManager.getInstance().setTimelineDuration(animationDuration);
                } else {
                    AnimationConfigurationManager.getInstance().setTimelineDuration(0L);
                }
                SubstanceLookAndFeel.setSkin((String)lookAndFeel);
            } else if (lafInstance instanceof NimbusLookAndFeel) {
                UIManager.setLookAndFeel((LookAndFeel)lafInstance);
                NimbusUtils.changeFontSize(ThemeManager.getNimbusFontSize());
            } else if (lafInstance instanceof MetalLookAndFeel) {
                UIManager.setLookAndFeel((LookAndFeel)lafInstance);
                ThemeManager.setTheme(theme);
            } else if (lafInstance instanceof LookAndFeel) {
                UIManager.setLookAndFeel((LookAndFeel)lafInstance);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ThemeManager.class.getName()).log(Level.WARNING, null, e);
        }
    }

    protected JMenu buildLookAndFeelMenu() {
        String activeLookAndFeelName = UIManager.getLookAndFeel().getName();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu lfMenu = new JMenu();
        lfMenu.setText(this.rb.getString("Menu.LookAndFeel.Name"));
        lfMenu.setMnemonic(this.rb.getMnemonic("Menu.LookAndFeel.Mnemonic"));
        lfMenu.add(this.buildSubstanceMenu());
        ArrayList<Object> lookAndFeels = new ArrayList<Object>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!ThemeManager.isLookAndFeelAvailable(info.getClassName())) continue;
            lookAndFeels.add(info.getClassName());
        }
        for (String lookAndFeel : KNOWN) {
            if (!ThemeManager.isLookAndFeelAvailable(lookAndFeel)) continue;
            lookAndFeels.add(lookAndFeel);
        }
        Collections.sort(lookAndFeels);
        for (String string : lookAndFeels) {
            try {
                Class<?> lnfClass = Class.forName(string);
                LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
                JRadioButtonMenuItem button = new JRadioButtonMenuItem();
                button.setText(newLAF.getName());
                button.setActionCommand(string);
                button.setName(newLAF.getName());
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
                        pref.put(ThemeManager.LF, e.getActionCommand());
                        ThemeManager.this.restartUI();
                    }
                });
                buttonGroup.add(button);
                lfMenu.add(button);
                if (!newLAF.getName().equals(activeLookAndFeelName)) continue;
                button.setSelected(true);
            }
            catch (Exception e) {
                Logger.getLogger(ThemeManager.class.getName()).log(Level.WARNING, null, e);
            }
        }
        return lfMenu;
    }

    private void buildThemeList() {
        this.addTheme(OCEAN);
        this.addTheme(STEEL);
        this.addTheme("jgnash.ui.plaf.theme.CDETheme");
        this.addTheme("jgnash.ui.plaf.theme.TinyMetalTheme");
        this.addTheme("com.jgoodies.looks.plastic.theme.BrownSugar");
        this.addTheme("com.jgoodies.looks.plastic.theme.DarkStar");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertBlue");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertBluer");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertGreen");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertRed");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertYellow");
        this.addTheme("com.jgoodies.looks.plastic.theme.ExperienceBlue");
        this.addTheme("com.jgoodies.looks.plastic.theme.ExperienceGreen");
        this.addTheme("com.jgoodies.looks.plastic.theme.ExperienceRoyale");
        this.addTheme("com.jgoodies.looks.plastic.theme.LightGray");
        this.addTheme("com.jgoodies.looks.plastic.theme.Silver");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyBlue");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyBluer");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyGreen");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyKrupp");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyPink");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyRed");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyYellow");
    }

    private void addTheme(String theme) {
        try {
            Class<?> c = Class.forName(theme);
            this.themeList.add(c.newInstance());
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("Could not add theme: " + theme);
        }
    }

    protected JMenu buildThemeMenu() {
        Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
        String currentTheme = pref.get(THEME, DEFAULT_THEME);
        this.themesMenu = new JMenu();
        this.themesMenu.setText(this.rb.getString("Menu.Themes.Name"));
        this.themesMenu.setMnemonic(this.rb.getMnemonic("Menu.Themes.Mnemonic"));
        ButtonGroup themeButtonGroup = new ButtonGroup();
        this.buildThemeList();
        for (Object aThemeList : this.themeList) {
            MetalTheme theme = (MetalTheme)aThemeList;
            JRadioButtonMenuItem button = new JRadioButtonMenuItem();
            button.setText(theme.getName());
            button.setActionCommand(theme.getClass().getName());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
                    pref.put(ThemeManager.THEME, e.getActionCommand());
                    ThemeManager.this.restartUI();
                }
            });
            themeButtonGroup.add(button);
            this.themesMenu.add(button);
            if (!aThemeList.getClass().getName().equals(currentTheme)) continue;
            button.setSelected(true);
        }
        this.refreshThemesState();
        return this.themesMenu;
    }

    protected JMenu buildSubstanceMenu() {
        JMenu substanceMenu = new JMenu(this.rb.getString("Menu.SubstanceThemes.Name"));
        for (SkinInfo info : SubstanceLookAndFeel.getAllSkins().values()) {
            JRadioButtonMenuItem button = new JRadioButtonMenuItem();
            button.setText(info.getDisplayName());
            button.setActionCommand(info.getClassName());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
                    pref.put(ThemeManager.LF, e.getActionCommand());
                    ThemeManager.this.restartUI();
                }
            });
            substanceMenu.add(button);
        }
        return substanceMenu;
    }

    private void refreshThemesState() {
        if (this.themesMenu != null) {
            try {
                LookAndFeel laf = UIManager.getLookAndFeel();
                if (laf instanceof MetalLookAndFeel) {
                    this.themesMenu.setEnabled(true);
                } else {
                    this.themesMenu.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isLookAndFeelAvailable(String laf) {
        try {
            Class<?> lnfClass = Class.forName(laf);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void restartUI() {
        this.themeList.clear();
        this.themesMenu.removeAll();
        this.themesMenu = null;
        UIApplication.restartUI();
    }

    public static void setSubstanceAnimationsEnabled(boolean enabled) {
        Preferences p = Preferences.userNodeForPackage(ThemeManager.class);
        p.putBoolean(SUBSTANCE_ANIMATIONS, enabled);
        if (enabled) {
            AnimationConfigurationManager.getInstance().setTimelineDuration(animationDuration);
        } else {
            AnimationConfigurationManager.getInstance().setTimelineDuration(0L);
        }
    }

    public static boolean isSubstanceAnimationsEnabled() {
        Preferences p = Preferences.userNodeForPackage(ThemeManager.class);
        return p.getBoolean(SUBSTANCE_ANIMATIONS, true);
    }

    public static void setNimbusFontSize(int size) {
        Preferences p = Preferences.userNodeForPackage(ThemeManager.class);
        p.putInt(NIMBUS_FONT_SIZE, size);
    }

    public static int getNimbusFontSize() {
        Preferences p = Preferences.userNodeForPackage(ThemeManager.class);
        int preferredSize = p.getInt(NIMBUS_FONT_SIZE, 0);
        if (preferredSize == 0) {
            LookAndFeel old = UIManager.getLookAndFeel();
            try {
                UIManager.setLookAndFeel((LookAndFeel)new NimbusLookAndFeel());
                preferredSize = NimbusUtils.getBaseFontSize();
                p.putInt(NIMBUS_FONT_SIZE, preferredSize);
                UIManager.setLookAndFeel(old);
            }
            catch (Exception e) {
                Logger.getLogger(ThemeManager.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
        }
        return preferredSize;
    }

    static {
        animationDuration = AnimationConfigurationManager.getInstance().getTimelineDuration();
    }
}

