/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.recurring;

import java.util.Date;
import jgnash.engine.Account;
import jgnash.engine.StoredObject;
import jgnash.engine.Transaction;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.ReminderType;
import jgnash.util.DateUtils;

public abstract class Reminder
extends StoredObject
implements Comparable<Reminder>,
Cloneable {
    private static final long serialVersionUID = 585114642710839171L;
    private int daysAdvance;
    private boolean autoCreate;
    private boolean autoCreateNotify;
    private String description;
    private boolean enabled = true;
    private Date endDate = null;
    private int increment = 0;
    private Date lastDate = null;
    private String notes = null;
    private boolean removable = false;
    private Date startDate = new Date();
    private Account account;
    private Transaction transaction;

    @Override
    public int compareTo(Reminder reminder) {
        int result = this.description.compareTo(reminder.description);
        if (result != 0) {
            return result;
        }
        result = this.getReminderType().compareTo(reminder.getReminderType());
        if (result != 0) {
            return result;
        }
        return this.getUuid().compareTo(reminder.getUuid());
    }

    public int getDaysAdvance() {
        return this.daysAdvance;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    public abstract RecurringIterator getIterator();

    public Date getLastDate() {
        if (this.lastDate != null) {
            return (Date)this.lastDate.clone();
        }
        return null;
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    public Transaction getTransaction() {
        if (this.transaction != null) {
            try {
                return (Transaction)this.transaction.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public abstract ReminderType getReminderType();

    @Override
    public final int hashCode() {
        return this.getUuid().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.getUuid().equals(((Reminder)obj).getUuid());
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public boolean isAutoCreateNotify() {
        return this.autoCreateNotify;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setDaysAdvance(int advanceRemindDays) {
        this.daysAdvance = advanceRemindDays;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public void setAutoCreateNotify(boolean autoCreateNotify) {
        this.autoCreateNotify = autoCreateNotify;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate != null ? (Date)endDate.clone() : null;
    }

    private void setLastDate(Date lastDate) {
        this.lastDate = (Date)lastDate.clone();
    }

    public Date setLastDate() {
        this.setLastDate(this.getIterator().next());
        return this.getLastDate();
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public void setStartDate(Date startDate) {
        this.startDate = DateUtils.levelDate(startDate);
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public String toString() {
        return this.description;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Reminder r = (Reminder)super.clone();
        r.setEndDate(this.getEndDate());
        r.setStartDate(this.getStartDate());
        if (this.getLastDate() != null) {
            r.setLastDate(this.getLastDate());
        }
        if (this.getTransaction() != null) {
            r.setTransaction(this.getTransaction());
        }
        return r;
    }
}

