/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jgnash.engine.Account;
import jgnash.engine.ReconciledState;
import jgnash.engine.StoredObject;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionTag;
import jgnash.engine.TransactionType;
import jgnash.util.DateUtils;

public class Transaction
extends StoredObject
implements Comparable<Transaction>,
Cloneable {
    private static final long serialVersionUID = 6312043631736158707L;
    private static final transient String EMPTY = "";
    private Date date = new Date();
    private Date dateEntered = new Date();
    private String number;
    private String payee;
    private String fitid;
    private String memo;
    List<TransactionEntry> transactionEntries = new ArrayList<TransactionEntry>();
    private transient ReadWriteLock lock = new ReentrantReadWriteLock(true);

    ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Account> getAccounts() {
        TreeSet<Account> accounts = new TreeSet<Account>();
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                accounts.add(e.getCreditAccount());
                accounts.add(e.getDebitAccount());
            }
        }
        finally {
            l.unlock();
        }
        return accounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getCommonAccount() {
        Account account;
        block6: {
            account = null;
            Lock l = this.getLock().readLock();
            l.lock();
            try {
                if (this.size() >= 2) {
                    Set<Account> accounts = this.getAccounts();
                    for (Account a : accounts) {
                        boolean success = true;
                        for (TransactionEntry e : this.transactionEntries) {
                            if (e.getCreditAccount().equals(a) || e.getDebitAccount().equals(a)) continue;
                            success = false;
                            break;
                        }
                        if (!success) continue;
                        account = a;
                        break block6;
                    }
                    break block6;
                }
                account = this.transactionEntries.get(0).getCreditAccount();
            }
            finally {
                l.unlock();
            }
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionEntry(TransactionEntry entry) {
        assert (entry != null);
        assert (!this.transactionEntries.contains(entry));
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            this.transactionEntries.add(entry);
            Collections.sort(this.transactionEntries);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionEntry(TransactionEntry entry) {
        assert (entry != null);
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            this.transactionEntries.remove(entry);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            int n = this.transactionEntries.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    public void setDate(Date date) {
        assert (date != null);
        this.date = DateUtils.levelDate(date);
    }

    public Date getDate() {
        return this.date;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public String getPayee() {
        String result = EMPTY;
        if (this.payee != null) {
            result = this.payee;
        }
        return result;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        String result = EMPTY;
        if (this.number != null) {
            result = this.number;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getAmount(Account account) {
        BigDecimal balance = BigDecimal.ZERO;
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            for (TransactionEntry entry : this.transactionEntries) {
                balance = balance.add(entry.getAmount(account));
            }
        }
        finally {
            l.unlock();
        }
        return balance;
    }

    @Override
    public int compareTo(Transaction tran) {
        if (tran == this) {
            return 0;
        }
        int result = this.date.compareTo(tran.date);
        if (result != 0) {
            return result;
        }
        result = this.getNumber().compareTo(tran.getNumber());
        if (result != 0) {
            return result;
        }
        result = this.dateEntered.compareTo(tran.dateEntered);
        if (result != 0) {
            return result;
        }
        return this.getUuid().compareTo(tran.getUuid());
    }

    public boolean equalsIgnoreDate(Transaction tran) {
        if (tran == this) {
            return true;
        }
        if (!this.getTransactionType().equals((Object)tran.getTransactionType())) {
            return false;
        }
        if (!this.date.equals(tran.date)) {
            return false;
        }
        if (!this.getPayee().equalsIgnoreCase(tran.getPayee())) {
            return false;
        }
        return this.getNumber().equalsIgnoreCase(tran.getNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionEntry> getTransactionEntries() {
        ArrayList<TransactionEntry> list = null;
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            list = new ArrayList<TransactionEntry>(this.transactionEntries);
        }
        finally {
            l.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TransactionEntry> getTransactionEntriesByTag(TransactionTag tag) {
        ArrayList<TransactionEntry> list = new ArrayList<TransactionEntry>();
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                if (e.getTransactionTag() != tag) continue;
                list.add(e);
            }
        }
        finally {
            l.unlock();
        }
        return list;
    }

    public void addTransactionEntries(Collection<TransactionEntry> entries) {
        for (TransactionEntry entry : entries) {
            this.addTransactionEntry(entry);
        }
    }

    public Date getDateEntered() {
        return this.dateEntered;
    }

    public void setDateEntered(Date dateEntered) {
        assert (dateEntered != null);
        this.dateEntered = (Date)dateEntered.clone();
    }

    public TransactionType getTransactionType() {
        if (this.size() == 1) {
            TransactionEntry entry = this.transactionEntries.get(0);
            if (entry.isSingleEntry()) {
                return TransactionType.SINGLENTRY;
            }
            return TransactionType.DOUBLEENTRY;
        }
        if (this.size() > 1) {
            return TransactionType.SPLITENTRY;
        }
        return TransactionType.INVALID;
    }

    public String getMemo() {
        if (this.memo != null) {
            return this.memo;
        }
        return this.getTransactionEntries().get(0).getMemo();
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getFitid() {
        return this.fitid;
    }

    public void setFitid(String fitid) {
        this.fitid = fitid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconciled(Account account, ReconciledState state) {
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                e.setReconciled(account, state);
            }
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconciled(ReconciledState state) {
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                e.setCreditReconciled(state);
                e.setDebitReconciled(state);
            }
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconciledState getReconciled(Account account) {
        ReconciledState state = null;
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                if (e.getCreditAccount().equals(account)) {
                    state = e.getCreditReconciled();
                } else {
                    if (!e.getDebitAccount().equals(account)) continue;
                    state = e.getDebitReconciled();
                }
                break;
            }
        }
        finally {
            l.unlock();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        Transaction tran;
        Lock l = this.getLock().readLock();
        l.lock();
        try {
            tran = (Transaction)super.clone();
            tran.transactionEntries = new ArrayList<TransactionEntry>();
            tran.lock = new ReentrantReadWriteLock(true);
            for (TransactionEntry entry : this.transactionEntries) {
                tran.addTransactionEntry((TransactionEntry)entry.clone());
            }
        }
        finally {
            l.unlock();
        }
        return tran;
    }

    protected Object readResolve() {
        this.lock = new ReentrantReadWriteLock(true);
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Transaction UUID: ").append(this.getUuid()).append('\n');
        b.append("Number:           ").append(this.getNumber()).append('\n');
        b.append("Payee:            ").append(this.getPayee()).append('\n');
        b.append("Memo:             ").append(this.getMemo()).append('\n');
        b.append('\n');
        for (TransactionEntry entry : this.getTransactionEntries()) {
            b.append(entry.toString()).append('\n');
        }
        return b.toString();
    }
}

