/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

class FunkyJar
extends JarOutputStream {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_DIR = "META-INF/";
    private static final CRC32 crc32 = new CRC32();
    private boolean compress;
    private JarEntry currEntry;
    private Size size;
    private Set dirs;

    public FunkyJar(File file, boolean compress, String version, String author) throws IOException {
        super(new FileOutputStream(file));
        this.compress = compress;
        if (compress) {
            this.setMethod(8);
        } else {
            this.setMethod(0);
        }
        Manifest manifest = new Manifest();
        Attributes global = manifest.getMainAttributes();
        if (global.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            global.put(Attributes.Name.MANIFEST_VERSION, version);
        }
        if (global.getValue(new Attributes.Name("Created-By")) == null) {
            global.put(new Attributes.Name("Created-By"), author);
        }
        JarEntry entry = new JarEntry(MANIFEST_DIR);
        entry.setTime(System.currentTimeMillis());
        entry.setSize(0L);
        entry.setCrc(0L);
        this.putNextEntry(entry);
        entry = new JarEntry(MANIFEST);
        entry.setTime(System.currentTimeMillis());
        if (!compress) {
            final Size size = new Size();
            crc32.reset();
            manifest.write(new OutputStream(){

                public void write(int r) throws IOException {
                    crc32.update(r);
                    ++size.value;
                }

                public void write(byte[] b) throws IOException {
                    crc32.update(b, 0, b.length);
                    size.value += (long)b.length;
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    crc32.update(b, off, len);
                    size.value += (long)(len - off);
                }
            });
            entry.setSize(size.value);
            entry.setCrc(crc32.getValue());
        }
        this.putNextEntry(entry);
        manifest.write(this);
        this.closeEntry();
    }

    public void newEntry(String name) throws IOException {
        this.makeDirs(name);
        this.currEntry = new JarEntry(name);
        this.currEntry.setTime(System.currentTimeMillis());
        if (this.compress) {
            this.currEntry.setMethod(8);
        } else {
            this.currEntry.setMethod(0);
        }
        this.putNextEntry(this.currEntry);
        crc32.reset();
        this.size = new Size();
    }

    private void makeDirs(String key) throws IOException {
        if (this.dirs == null) {
            this.dirs = new HashSet();
        }
        int idx = 0;
        int last = 0;
        while ((last = key.indexOf(47, idx + 1)) != -1) {
            String aDir = key.substring(0, last + 1);
            if (!this.dirs.contains(aDir)) {
                this.dirs.add(aDir);
                this.putNextEntry(new ZipEntry(aDir));
                this.closeEntry();
            }
            idx = last;
        }
    }

    public void write(int r) throws IOException {
        super.write(r);
        if (!this.compress && this.size != null) {
            crc32.update(r);
            ++this.size.value;
        }
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        if (!this.compress && this.size != null) {
            crc32.update(b, 0, b.length);
            this.size.value += (long)b.length;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (!this.compress && this.size != null) {
            crc32.update(b, off, len);
            this.size.value += (long)(len - off);
        }
    }

    public void close() throws IOException {
        if (!this.compress && this.size != null) {
            this.currEntry.setSize(this.size.value);
            this.currEntry.setCrc(crc32.getValue());
        }
        this.currEntry = null;
        this.size = null;
        this.closeEntry();
    }

    public void done() throws IOException {
        super.close();
    }

    class Size {
        long value = 0L;

        Size() {
        }
    }
}

