/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import java.util.Hashtable;

public abstract class DescendVisitor
extends TreeVisitor {
    Hashtable useInfoMap;
    Hashtable defInfoMap;
    boolean found;
    Node beginNode;
    LocalExpr start;
    int exchangeFactor;

    public DescendVisitor(Hashtable useInfoMap, Hashtable defInfoMap) {
        this.useInfoMap = useInfoMap;
        this.defInfoMap = defInfoMap;
    }

    public boolean search(Node beginNode, LocalExpr start) {
        this.beginNode = beginNode;
        this.start = start;
        this.exchangeFactor = 0;
        this.found = false;
        beginNode.visit(this);
        return this.found;
    }

    public void visitExprStmt(ExprStmt stmt) {
        stmt.expr().visit(this);
    }

    public void visitIfStmt(IfStmt stmt) {
        if (stmt instanceof IfCmpStmt) {
            this.visitIfCmpStmt((IfCmpStmt)stmt);
        } else if (stmt instanceof IfZeroStmt) {
            this.visitIfZeroStmt((IfZeroStmt)stmt);
        }
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        stmt.left().visit(this);
        if (!this.found) {
            ++this.exchangeFactor;
            if (stmt.left().type().isWide()) {
                ++this.exchangeFactor;
            }
            if (this.exchangeFactor < 3) {
                stmt.right().visit(this);
            }
        }
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        stmt.expr().visit(this);
    }

    public void visitInitStmt(InitStmt stmt) {
    }

    public void visitGotoStmt(GotoStmt stmt) {
    }

    public void visitLabelStmt(LabelStmt stmt) {
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
    }

    public void visitPhiStmt(PhiStmt stmt) {
        if (stmt instanceof PhiCatchStmt) {
            this.visitPhiCatchStmt((PhiCatchStmt)stmt);
        } else if (stmt instanceof PhiJoinStmt) {
            this.visitPhiJoinStmt((PhiJoinStmt)stmt);
        }
    }

    public void visitCatchExpr(CatchExpr expr) {
    }

    public void visitDefExpr(DefExpr expr) {
        if (expr instanceof MemExpr) {
            this.visitMemExpr((MemExpr)expr);
        }
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
    }

    public void visitPhiCatchStmt(PhiCatchStmt stmt) {
    }

    public void visitPhiJoinStmt(PhiJoinStmt stmt) {
    }

    public void visitRetStmt(RetStmt stmt) {
    }

    public void visitReturnExprStmt(ReturnExprStmt stmt) {
    }

    public void visitReturnStmt(ReturnStmt stmt) {
    }

    public void visitAddressStoreStmt(AddressStoreStmt stmt) {
    }

    public void visitStoreExpr(StoreExpr expr) {
        MemExpr target = expr.target();
        if (target instanceof ArrayRefExpr) {
            ((ArrayRefExpr)target).array().visit(this);
            if (!this.found) {
                ++this.exchangeFactor;
                if (this.exchangeFactor < 3) {
                    ((ArrayRefExpr)target).index().visit(this);
                    if (!this.found) {
                        ++this.exchangeFactor;
                        if (this.exchangeFactor < 3) {
                            expr.expr().visit(this);
                        }
                    }
                }
            }
        } else if (target instanceof FieldExpr) {
            ((FieldExpr)target).object().visit(this);
            if (!this.found) {
                ++this.exchangeFactor;
                if (this.exchangeFactor < 3) {
                    expr.expr().visit(this);
                }
            }
        } else if (target instanceof StaticFieldExpr) {
            expr.expr.visit(this);
        } else if (target instanceof LocalExpr) {
            expr.expr.visit(this);
        }
    }

    public void visitJsrStmt(JsrStmt stmt) {
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
    }

    public void visitThrowStmt(ThrowStmt stmt) {
    }

    public void visitStmt(Stmt stmt) {
    }

    public void visitSCStmt(SCStmt stmt) {
    }

    public void visitSRStmt(SRStmt stmt) {
    }

    public void visitArithExpr(ArithExpr expr) {
        expr.left().visit(this);
        if (!this.found) {
            ++this.exchangeFactor;
            if (expr.left().type().isWide()) {
                ++this.exchangeFactor;
            }
            if (this.exchangeFactor < 3) {
                expr.right().visit(this);
            }
        }
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        expr.array().visit(this);
    }

    public void visitMemExpr(MemExpr expr) {
        if (expr instanceof LocalExpr) {
            this.visitLocalExpr((LocalExpr)expr);
        }
    }

    public void visitMemRefExpr(MemRefExpr expr) {
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
    }

    public void visitCallExpr(CallExpr expr) {
        if (expr instanceof CallMethodExpr) {
            this.visitCallMethodExpr((CallMethodExpr)expr);
        } else if (expr instanceof CallStaticExpr) {
            this.visitCallStaticExpr((CallStaticExpr)expr);
        }
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        expr.receiver().visit(this);
        Expr[] params = expr.params();
        if (!this.found && this.exchangeFactor < 2 && params.length > 0) {
            ++this.exchangeFactor;
            params[0].visit(this);
        }
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        Expr[] params = expr.params();
        if (params.length > 0) {
            params[0].visit(this);
        }
        if (!this.found && this.exchangeFactor < 2 && params.length > 1) {
            ++this.exchangeFactor;
            params[1].visit(this);
        }
    }

    public void visitCastExpr(CastExpr expr) {
        expr.expr().visit(this);
    }

    public void visitConstantExpr(ConstantExpr expr) {
    }

    public void visitFieldExpr(FieldExpr expr) {
        expr.object.visit(this);
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        expr.expr().visit(this);
    }

    public abstract void visitLocalExpr(LocalExpr var1);

    public void visitNegExpr(NegExpr expr) {
        expr.expr().visit(this);
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        expr.size().visit(this);
    }

    public void visitNewExpr(NewExpr expr) {
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        Expr[] dims = expr.dimensions();
        if (dims.length > 0) {
            dims[0].visit(this);
        }
        if (!this.found && this.exchangeFactor < 2 && dims.length > 1) {
            ++this.exchangeFactor;
            dims[1].visit(this);
        }
    }

    public void visitCheckExpr(CheckExpr expr) {
        if (expr instanceof ZeroCheckExpr) {
            this.visitZeroCheckExpr((ZeroCheckExpr)expr);
        } else if (expr instanceof RCExpr) {
            this.visitRCExpr((RCExpr)expr);
        } else if (expr instanceof UCExpr) {
            this.visitUCExpr((UCExpr)expr);
        }
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
    }

    public void visitRCExpr(RCExpr expr) {
    }

    public void visitUCExpr(UCExpr expr) {
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
    }

    public void visitShiftExpr(ShiftExpr expr) {
    }

    public void visitVarExpr(VarExpr expr) {
        if (expr instanceof LocalExpr) {
            this.visitLocalExpr((LocalExpr)expr);
        }
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
    }

    public void visitExpr(Expr expr) {
    }
}

