/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.jasper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgnash.ui.components.WaitMessagePanel;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.ui.report.jasper.DynamicJasperReportPanel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXStatusBar;

class DynamicJasperReportFrame
extends JFrame {
    protected DynamicJasperReportPanel viewer = null;
    private JPanel mainPanel;
    private WaitMessagePanel waitPanel;
    private LogHandler logHandler = new LogHandler();
    private JTextField statusField;

    private DynamicJasperReportFrame(DynamicJasperReport report) {
        this.setReportName(report.getReportName());
        this.init();
        this.registerLogHandler();
        this.viewer = new DynamicJasperReportPanel(this, report);
        this.mainPanel.add((Component)this.viewer, "Center");
    }

    void setReportName(final String name) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicJasperReportFrame.this.setTitle("jGnash - " + name);
            }
        });
    }

    private void unregisterLogHandler() {
        Logger.getLogger(DynamicJasperReport.class.getName()).removeHandler(this.logHandler);
    }

    private void registerLogHandler() {
        Logger.getLogger(DynamicJasperReport.class.getName()).addHandler(this.logHandler);
    }

    private void init() {
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        this.statusField.setFont(this.statusField.getFont().deriveFont(this.statusField.getFont().getSize2D() - 1.0f));
        this.statusField.setHorizontalAlignment(0);
        JXStatusBar statusBar = new JXStatusBar();
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        statusBar.add((Component)this.statusField, (Object)c1);
        statusBar.setResizeHandleEnabled(true);
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.waitPanel = new WaitMessagePanel();
        this.setGlassPane((Component)((Object)this.waitPanel));
        this.mainPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DynamicJasperReportFrame.this.unregisterLogHandler();
                DynamicJasperReportFrame.this.viewer.clear();
                DynamicJasperReportFrame.this.getContentPane().removeAll();
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)statusBar, "South");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 440));
        this.pack();
        DialogUtils.addBoundsListener(this);
    }

    protected static void viewReport(DynamicJasperReport report) {
        DynamicJasperReportFrame jasperViewer = new DynamicJasperReportFrame(report);
        jasperViewer.setVisible(true);
    }

    protected void displayWaitMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicJasperReportFrame.this.waitPanel.setMessage(message);
                DynamicJasperReportFrame.this.waitPanel.setWaiting(true);
            }
        });
    }

    protected void stopWaitMessage() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicJasperReportFrame.this.waitPanel.setWaiting(false);
            }
        });
    }

    protected void setStatus(String status) {
        this.statusField.setText(status);
    }

    private class LogHandler
    extends Handler {
        private LogHandler() {
        }

        @Override
        public void publish(final LogRecord record) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DynamicJasperReportFrame.this.waitPanel.setMessage(record.getMessage());
                }
            });
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

