/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.ui.register.DateChkNumberDialog;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class DuplicateTransactionDialog
extends DateChkNumberDialog
implements ActionListener {
    private Transaction transaction;

    protected static DuplicateTransactionDialog showDialog(Account a, Transaction t) {
        if (t != null) {
            DuplicateTransactionDialog d = new DuplicateTransactionDialog(a, t);
            d.setVisible(true);
            d.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                }
            });
            return d;
        }
        return null;
    }

    private DuplicateTransactionDialog(Account a, Transaction t) {
        super(a, Resource.get().getString("Title.DuplicateTransaction"));
        if (a == null) {
            throw new IllegalArgumentException("Account parameter was null");
        }
        if (t == null) {
            throw new IllegalArgumentException("Transaction parameter was null");
        }
        this.transaction = t;
        if (t.getNumber() != null && t.getNumber().length() > 0) {
            String n = a.getNextTransactionNumber();
            if (n != null) {
                this.numberCombo.setText(n);
            } else {
                this.numberCombo.setText(t.getNumber());
            }
        } else {
            this.numberCombo.setText(null);
        }
    }

    @Override
    public void okAction() {
        Transaction clone = (Transaction)this.transaction.clone();
        Date today = DateUtils.levelDate(new Date());
        if (today.equals(this.datePanel.getDate())) {
            clone.setDate(new Date());
        } else {
            clone.setDate(this.datePanel.getDate());
        }
        clone.setNumber(this.numberCombo.getText());
        clone.setReconciled(ReconciledState.NOT_RECONCILED);
        EngineFactory.getEngine("default").addTransaction(clone);
        this.transaction = clone;
        super.okAction();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

