/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components.wizard;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.util.Resource;

public class WizardDialog
extends JDialog
implements ActionListener {
    private boolean valid = false;
    private CardLayout layout;
    private DefaultListModel model;
    private int selectedIndex = 0;
    private JButton backButton;
    private JButton cancelButton;
    private JButton finishButton;
    private JButton nextButton;
    private JPanel pagePanel;
    private JList taskList;
    protected final Resource rb = Resource.get();
    private Map<Enum<?>, Object> settings = new HashMap();
    private static final String KEY = "TASK";

    protected WizardDialog(Frame parent) {
        super(parent, true);
        this.layoutMainPanel();
        this.backButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.taskList.setSelectionMode(0);
        this.layout = (CardLayout)this.pagePanel.getLayout();
        this.model = new DefaultListModel();
        this.taskList.setModel(this.model);
        this.updateButtonState();
        this.setDefaultCloseOperation(2);
    }

    public Object getSetting(Enum<?> key) {
        return this.settings.get(key);
    }

    public void setSetting(Enum<?> key, Object value) {
        this.settings.put(key, value);
        for (int i = 0; i < this.model.size(); ++i) {
            WizardPage p = (WizardPage)this.model.getElementAt(i);
            p.getSettings(this.settings);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            int count = this.model.size();
            for (int i = count - 1; i >= 0; --i) {
                this.taskList.setSelectedIndex(i);
                this.pack();
            }
        }
        this.setMinimumSize(this.getSize());
        super.setVisible(visible);
    }

    private void initComponents() {
        this.pagePanel = new JPanel(new CardLayout());
        this.backButton = new JButton(this.rb.getString("Button.Back"));
        this.backButton.setIcon(Resource.getIcon("/jgnash/resource/go-previous.png"));
        this.nextButton = new JButton(this.rb.getString("Button.Next"));
        this.nextButton.setIcon(Resource.getIcon("/jgnash/resource/go-next.png"));
        this.nextButton.setHorizontalTextPosition(10);
        this.finishButton = new JButton(this.rb.getString("Button.Finish"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.taskList = new JList();
        this.taskList.setBorder(new EtchedBorder());
        this.taskList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WizardDialog.this.selectionAction(evt);
            }
        });
        this.taskList.setCellRenderer(new WizardPageRenderer(this.taskList.getCellRenderer()));
    }

    private void layoutMainPanel() {
        this.initComponents();
        CellConstraints cc = new CellConstraints();
        FormLayout lay = new FormLayout("p, 8dlu, min(220dlu;d):g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lay);
        builder.setDefaultDialogBorder();
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)this.buildTaskPanel(), (Component)this.pagePanel);
        builder.appendSeparator();
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow("p");
        builder.add((Component)this.buildButtonPanel(), cc.xyw(1, builder.getRow(), 3));
        this.getContentPane().add(builder.getPanel());
    }

    private JPanel buildButtonPanel() {
        FormLayout lay = new FormLayout("r:p:g, 8dlu, p, 8dlu, p, 25dlu, p", "");
        lay.setColumnGroups((int[][])new int[][]{{1, 3, 5, 7}});
        DefaultFormBuilder builder = new DefaultFormBuilder(lay);
        builder.append((Component)this.backButton, (Component)this.nextButton, (Component)this.finishButton);
        builder.append((Component)this.cancelButton);
        return builder.getPanel();
    }

    private JPanel buildTaskPanel() {
        FormLayout lay = new FormLayout("f:p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lay);
        builder.appendSeparator(this.rb.getString("Title.Steps"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:d:g"));
        builder.append((Component)this.taskList);
        JPanel panel = builder.getPanel();
        panel.setBackground((Color)UIManager.getDefaults().get("List.background"));
        panel.setOpaque(false);
        return panel;
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    void selectionAction(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int oldIndex = this.selectedIndex;
        int newIndex = this.taskList.getSelectedIndex();
        if (oldIndex < newIndex) {
            while (oldIndex < newIndex) {
                this.nextAction();
                ++oldIndex;
            }
        }
        if (oldIndex > newIndex) {
            while (oldIndex > newIndex) {
                this.backAction();
                --oldIndex;
            }
        }
    }

    private void updateButtonState() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.model.size() - 1) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        if (this.selectedIndex == this.model.size() - 1) {
            boolean _valid = true;
            for (int i = 0; i < this.model.size(); ++i) {
                WizardPage page = (WizardPage)this.model.get(i);
                if (page.isPageValid()) continue;
                _valid = false;
            }
            this.finishButton.setEnabled(_valid);
        } else {
            this.finishButton.setEnabled(false);
        }
        if (this.selectedIndex == 0) {
            this.backButton.setEnabled(false);
        } else {
            this.backButton.setEnabled(true);
        }
    }

    public boolean isWizardValid() {
        return this.valid;
    }

    private void nextAction() {
        if (this.selectedIndex < this.model.size() - 1) {
            WizardPage page = (WizardPage)((Object)this.pagePanel.getComponent(this.selectedIndex));
            page.putSettings(this.settings);
            this.layout.next(this.pagePanel);
            ++this.selectedIndex;
            this.taskList.setSelectedIndex(this.selectedIndex);
            this.updateButtonState();
            page = (WizardPage)((Object)this.pagePanel.getComponent(this.selectedIndex));
            page.getSettings(this.settings);
        }
    }

    private void backAction() {
        if (this.selectedIndex > 0) {
            this.layout.previous(this.pagePanel);
            --this.selectedIndex;
            this.taskList.setSelectedIndex(this.selectedIndex);
            this.updateButtonState();
        }
    }

    private void cancelAction() {
        this.valid = false;
        this.closeDialog();
    }

    private void finishAction() {
        this.valid = true;
        for (int i = 0; i < this.model.size(); ++i) {
            WizardPage p = (WizardPage)this.model.getElementAt(i);
            if (!p.isPageValid()) {
                this.valid = false;
                break;
            }
            p.putSettings(this.settings);
        }
        if (this.valid) {
            this.closeDialog();
        }
    }

    protected void addTaskPage(WizardPage p) {
        p.getSettings(this.settings);
        p.putSettings(this.settings);
        this.model.addElement(p);
        int size = this.model.size();
        this.pagePanel.add((Component)((Object)p), KEY + (size - 1));
        this.updateButtonState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.backButton) {
            this.backAction();
        } else if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this.finishButton) {
            this.finishAction();
        } else if (e.getSource() == this.nextButton) {
            this.nextAction();
        }
    }

    private static final class WizardPageRenderer
    implements ListCellRenderer {
        private Color inValidColor = Color.RED;
        private Color validColor = Color.RED;
        private ListCellRenderer delegate;

        public WizardPageRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
            if (delegate instanceof JLabel) {
                this.validColor = ((JLabel)((Object)delegate)).getForeground();
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = this.delegate.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
            if (this.delegate instanceof JLabel) {
                if (((WizardPage)value).isPageValid()) {
                    ((JLabel)((Object)this.delegate)).setForeground(this.validColor);
                } else {
                    ((JLabel)((Object)this.delegate)).setForeground(this.inValidColor);
                }
            }
            return c;
        }
    }
}

