/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.DataStoreType;
import jgnash.engine.EngineFactory;
import jgnash.engine.StoredObject;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.util.FileUtils;
import jgnash.util.Resource;

public class SaveFileAsAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = -8365579381939716138L;
    private static final String CURRENT_DIR = "cwd";

    private static void saveFileAs() {
        final Resource rb = Resource.get();
        Preferences pref = Preferences.userNodeForPackage(SaveFileAsAction.class);
        final File current = new File(EngineFactory.getActiveDatabase());
        JFileChooser chooser = new JFileChooser(pref.get(CURRENT_DIR, null));
        chooser.setDialogTitle(rb.getString("Title.SaveAs"));
        final DataStoreType[] types = DataStoreType.values();
        String[] ext = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ext[i] = types[i].getDataStore().getFileExt();
        }
        StringBuilder description = new StringBuilder(rb.getString("Label.jGnashFiles") + " (");
        for (int i = 0; i < types.length; ++i) {
            description.append("*.");
            description.append(types[i].getDataStore().getFileExt());
            if (i >= types.length - 1) continue;
            description.append(", ");
        }
        description.append(')');
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(description.toString(), ext));
        if (chooser.showSaveDialog(UIApplication.getFrame()) == 0) {
            pref.put(CURRENT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            final String destination = chooser.getSelectedFile().getAbsolutePath();
            final class SaveAs
            extends SwingWorker<Void, Void> {
                SaveAs() {
                }

                @Override
                protected Void doInBackground() throws Exception {
                    File newFile;
                    UIApplication.getFrame().displayWaitMessage(rb.getString("Message.PleaseWait"));
                    String fileExtension = FileUtils.getFileExtension(destination);
                    DataStoreType newFileType = DataStoreType.DB4O;
                    if (fileExtension.length() > 0) {
                        for (DataStoreType type : types) {
                            if (!type.getDataStore().getFileExt().equals(fileExtension)) continue;
                            newFileType = type;
                            break;
                        }
                    }
                    if (!current.equals(newFile = new File(FileUtils.stripFileExtension(destination) + "." + newFileType.getDataStore().getFileExt()))) {
                        Collection<StoredObject> objects = EngineFactory.getEngine("default").getStoredObjects();
                        newFileType.getDataStore().saveAs(newFile, objects);
                        EngineFactory.closeEngine("default");
                        EngineFactory.bootLocalEngine(newFile.getAbsolutePath(), "default");
                        EngineFactory.getEngine("default").getRootAccount();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    UIApplication.getFrame().stopWaitMessage();
                }
            }
            new SaveAs().execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SaveFileAsAction.saveFileAs();
    }
}

