/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.ui.account.AbstractAccountEnabledTreeCellRenderer;
import jgnash.ui.account.AbstractAccountListPane;
import jgnash.ui.account.AccountTreeCellRenderer;
import jgnash.ui.account.AccountTreeModel;

public class AccountListTreePane
extends AbstractAccountListPane
implements TreeSelectionListener {
    protected JTree tree;
    private AccountTreeCellRenderer renderer;

    public AccountListTreePane(String identifier, boolean rootVisable) {
        super(identifier, rootVisable);
        this.renderer = new AccountTreeCellRenderer(this.tree.getCellRenderer());
        this.setAccountTreeCellRenderer(this.renderer);
    }

    @Override
    public JComponent createModelAndView() {
        this.model = new AccountTreeModel();
        this.tree = new JTree(this.model);
        this.tree.setBorder(null);
        this.tree.setEditable(false);
        this.tree.setRootVisible(this.rootVisible);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        return this.tree;
    }

    public void disablePlaceHolders() {
        this.renderer.setPlaceHoldersEnabled(false);
    }

    protected void disableAccount(Account account) {
        this.renderer.addDisabledAccount(account);
    }

    private void setAccountTreeCellRenderer(AbstractAccountEnabledTreeCellRenderer renderer) {
        this.tree.setSelectionModel(renderer.getSelectionModel());
        this.tree.setCellRenderer(renderer);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o != null) {
            this.selectedAccount = (Account)((DefaultMutableTreeNode)o).getUserObject();
        }
    }

    @Override
    protected void _expand() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    @Override
    public void setSelectedAccount(Account account) {
        DefaultMutableTreeNode node;
        if (account != null && (node = this.model.findAccountNode(account)) != null) {
            TreePath path = new TreePath(this.model.getPathToRoot(node));
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    @Override
    public void scrollToTop() {
        RootAccount rootAccount = EngineFactory.getEngine("default").getRootAccount();
        if (rootAccount != null) {
            this.tree.scrollPathToVisible(new TreePath(rootAccount));
        }
    }
}

