/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.CurrencyNode;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryAddX;
import jgnash.engine.TransactionEntryBuyX;
import jgnash.engine.TransactionEntryDividendX;
import jgnash.engine.TransactionEntryMergeX;
import jgnash.engine.TransactionEntryReinvestDivX;
import jgnash.engine.TransactionEntryRemoveX;
import jgnash.engine.TransactionEntrySellX;
import jgnash.engine.TransactionEntrySplitX;
import jgnash.engine.recurring.Reminder;
import jgnash.util.FileMagic;
import jgnash.util.FileUtils;

public class XMLContainer {
    private final List<StoredObject> objects = new ArrayList<StoredObject>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final File file;
    private FileLock fileLock = null;
    private FileChannel lockChannel = null;

    protected XMLContainer(File file) {
        this.file = file;
    }

    private boolean acquireFileLock() {
        try {
            this.lockChannel = new RandomAccessFile(this.file, "rw").getChannel();
            this.fileLock = this.lockChannel.tryLock();
            return true;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (OverlappingFileLockException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private boolean releaseFileLock() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (this.lockChannel != null) {
                this.lockChannel.close();
                this.lockChannel = null;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    void commit() {
        this.writeXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean set(StoredObject object) {
        boolean result = false;
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            if (this.get(object.getUuid()) == null) {
                this.objects.add(object);
            }
            result = true;
        }
        finally {
            l.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(StoredObject object) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.objects.remove(object);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoredObject get(String uuid) {
        StoredObject result = null;
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            for (StoredObject o : this.objects) {
                if (!o.getUuid().equals(uuid)) continue;
                result = o;
            }
        }
        finally {
            l.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends StoredObject> List<T> query(Class<T> clazz) {
        List<T> list = null;
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            list = XMLContainer.query(this.objects, clazz);
        }
        finally {
            l.unlock();
        }
        return list;
    }

    void close() {
        this.releaseFileLock();
    }

    String getFileName() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return null;
    }

    private static <T extends StoredObject> List<T> query(Collection<StoredObject> values, Class<T> clazz) {
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        for (StoredObject o : values) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            list.add(o);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StoredObject> asList() {
        ArrayList<StoredObject> list = null;
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            list = new ArrayList<StoredObject>(this.objects);
        }
        finally {
            l.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeXML() {
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            this.releaseFileLock();
            XMLContainer.writeXML(this.objects, this.file);
        }
        finally {
            this.acquireFileLock();
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(Collection<StoredObject> objects, File file) {
        Logger logger = Logger.getLogger(XMLContainer.class.getName());
        if (file.exists()) {
            File backup = new File(file.getAbsolutePath() + ".backup");
            if (backup.exists() && !backup.delete()) {
                logger.warning("Was not able to delete old backup file: " + backup.getAbsolutePath());
            }
            try {
                FileUtils.copyFile(file, backup);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        list.addAll(XMLContainer.query(objects, Config.class));
        list.addAll(XMLContainer.query(objects, CommodityNode.class));
        list.addAll(XMLContainer.query(objects, ExchangeRate.class));
        list.addAll(XMLContainer.query(objects, RootAccount.class));
        list.addAll(XMLContainer.query(objects, Reminder.class));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StoredObject o = (StoredObject)i.next();
            if (!o.isMarkedForRemoval()) continue;
            i.remove();
        }
        Collections.sort(list, new StoredObjectComparator());
        logger.info("Writing XML file");
        ObjectOutputStream out = null;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            try {
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                writer.write("<?fileVersion 2.03?>\n");
                XStream xstream = XMLContainer.configureXStream(new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new StaxDriver()));
                out = xstream.createObjectOutputStream((HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
                out.writeObject(list);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, null, e);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
        logger.info("Writing XML file complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readXML() throws FileNotFoundException, UnsupportedEncodingException {
        String encoding = System.getProperty("file.encoding");
        String version = FileMagic.getjGnashXMLVersion(this.file);
        if (Float.valueOf(version).floatValue() >= 2.01f) {
            encoding = "UTF-8";
        }
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        ObjectInputStream in = null;
        FileLock readLock = null;
        FileInputStream fis = new FileInputStream(this.file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
        try {
            XStream xstream = XMLContainer.configureXStream(new XStream((ReflectionProvider)new StoredObjectReflectionProvider(this.objects), (HierarchicalStreamDriver)new StaxDriver()));
            readLock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            if (readLock != null) {
                in = xstream.createObjectInputStream((Reader)reader);
                in.readObject();
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    if (readLock != null) {
                        readLock.release();
                    }
                    in.close();
                }
                catch (IOException e) {
                    Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
            }
            this.acquireFileLock();
            l.unlock();
        }
    }

    private static XStream configureXStream(XStream xstream) {
        xstream.setMode(1002);
        xstream.alias("Account", Account.class);
        xstream.alias("RootAccount", RootAccount.class);
        xstream.alias("Config", Config.class);
        xstream.alias("CurrencyNode", CurrencyNode.class);
        xstream.alias("ExchangeRate", ExchangeRate.class);
        xstream.alias("ExchangeRateHistoryNode", ExchangeRateHistoryNode.class);
        xstream.alias("InvestmentTransaction", InvestmentTransaction.class);
        xstream.alias("SecurityNode", SecurityNode.class);
        xstream.alias("SecurityHistoryNode", SecurityHistoryNode.class);
        xstream.alias("Transaction", Transaction.class);
        xstream.alias("TransactionEntry", TransactionEntry.class);
        xstream.alias("TransactionEntryAddX", TransactionEntryAddX.class);
        xstream.alias("TransactionEntryBuyX", TransactionEntryBuyX.class);
        xstream.alias("TransactionEntryDividendX", TransactionEntryDividendX.class);
        xstream.alias("TransactionEntryMergeX", TransactionEntryMergeX.class);
        xstream.alias("TransactionEntryReinvestDivX", TransactionEntryReinvestDivX.class);
        xstream.alias("TransactionEntryRemoveX", TransactionEntryRemoveX.class);
        xstream.alias("TransactionEntrySellX", TransactionEntrySellX.class);
        xstream.alias("TransactionEntrySplitX", TransactionEntrySplitX.class);
        xstream.useAttributeFor(Account.class, "placeHolder");
        xstream.useAttributeFor(Account.class, "locked");
        xstream.useAttributeFor(Account.class, "visible");
        xstream.useAttributeFor(Account.class, "name");
        xstream.useAttributeFor(Account.class, "description");
        xstream.useAttributeFor(CommodityNode.class, "symbol");
        xstream.useAttributeFor(CommodityNode.class, "scale");
        xstream.useAttributeFor(CommodityNode.class, "prefix");
        xstream.useAttributeFor(CommodityNode.class, "suffix");
        xstream.useAttributeFor(CommodityNode.class, "description");
        xstream.useAttributeFor(CurrencyNode.class, "locale");
        xstream.useAttributeFor(SecurityHistoryNode.class, "date");
        xstream.useAttributeFor(SecurityHistoryNode.class, "price");
        xstream.useAttributeFor(SecurityHistoryNode.class, "high");
        xstream.useAttributeFor(SecurityHistoryNode.class, "low");
        xstream.useAttributeFor(SecurityHistoryNode.class, "volume");
        xstream.useAttributeFor(StoredObject.class, "uuid");
        xstream.omitField(StoredObject.class, "markedForRemoval");
        return xstream;
    }

    private static final class StoredObjectReflectionProvider
    extends PureJavaReflectionProvider {
        private final List<StoredObject> objects;

        protected StoredObjectReflectionProvider(List<StoredObject> objects) {
            this.objects = objects;
        }

        public Object newInstance(Class type) {
            Object o = super.newInstance(type);
            if (o instanceof StoredObject) {
                this.objects.add((StoredObject)o);
            }
            return o;
        }
    }
}

