/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.CurrencyNode;
import jgnash.engine.InvestmentPerformanceSummary;
import jgnash.engine.SecurityNode;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

public class PortfolioReport
extends DynamicJasperReport {
    private JCheckBox subAccountCheckBox;
    private JCheckBox verboseCheckBox;
    private AccountListComboBox accountCombo;
    private JButton refreshButton;
    private static final String USE_LONG_NAMES = "useLongNames";
    private static final String RECURSIVE = "recursive";

    public PortfolioReport() {
        Preferences p = this.getPreferences();
        this.subAccountCheckBox = new JCheckBox(this.rb.getString("Button.IncludeSubAccounts"));
        this.subAccountCheckBox.setSelected(p.getBoolean(RECURSIVE, false));
        this.verboseCheckBox = new JCheckBox(this.rb.getString("Button.UseLongNames"));
        this.verboseCheckBox.setSelected(p.getBoolean(USE_LONG_NAMES, false));
        this.accountCombo = AccountListComboBox.getInstanceByType(AccountGroup.getAccountTypes(AccountGroup.INVEST));
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                PortfolioReport.this.refreshReport();
            }
        });
    }

    public PortfolioReport(Account account) {
        this();
        this.accountCombo.setSelectedAccount(account);
    }

    @Override
    protected void refreshReport() {
        Preferences p = this.getPreferences();
        p.putBoolean(RECURSIVE, this.subAccountCheckBox.isSelected());
        p.putBoolean(USE_LONG_NAMES, this.verboseCheckBox.isSelected());
        super.refreshReport();
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        this.logger.info(this.rb.getString("Message.CollectingReportData"));
        Account account = this.accountCombo.getSelectedAccount();
        PortfolioReportTableModel model = new PortfolioReportTableModel(account.getCurrencyNode());
        model.verbose = this.verboseCheckBox.isSelected();
        return this.createJasperPrint(model, formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, $lcgap, p:g, 8dlu, p", "f:d, $lgap, f:d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.Account"), (Component)this.accountCombo);
        builder.append((Component)this.refreshButton);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.buildOptionPanel(), 5);
        layout.addGroupedRow(1);
        layout.addGroupedRow(3);
        return builder.getPanel();
    }

    private JPanel buildOptionPanel() {
        FormLayout layout = new FormLayout("p, 8dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.subAccountCheckBox);
        builder.append((Component)this.verboseCheckBox);
        return builder.getPanel();
    }

    @Override
    public String getReportName() {
        return this.accountCombo.getSelectedAccount().getName() + " - " + this.rb.getString("Title.PortfolioReport");
    }

    @Override
    public String getGrandTotalLegend() {
        return "";
    }

    @Override
    public String getGroupFooterLabel() {
        return null;
    }

    public class PortfolioReportTableModel
    extends AbstractReportTableModel {
        private static final long serialVersionUID = 568338829426628458L;
        boolean verbose;
        private CurrencyNode baseCurrency;
        private InvestmentPerformanceSummary performanceSummary;

        PortfolioReportTableModel(CurrencyNode baseCurrency) {
            this.baseCurrency = baseCurrency;
            this.verbose = PortfolioReport.this.verboseCheckBox.isSelected();
            try {
                this.performanceSummary = new InvestmentPerformanceSummary(PortfolioReport.this.accountCombo.getSelectedAccount(), PortfolioReport.this.subAccountCheckBox.isSelected());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Logger.getAnonymousLogger().info(this.performanceSummary.toString());
        }

        @Override
        public int getColumnCount() {
            return 12;
        }

        @Override
        public int getRowCount() {
            return this.performanceSummary.getSecurities().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SecurityNode cn = this.performanceSummary.getSecurities().get(row);
            InvestmentPerformanceSummary.SecurityPerformanceData pd = this.performanceSummary.getPerformanceData(cn);
            switch (col) {
                case 0: {
                    if (this.verbose) {
                        return pd.getNode().getDescription();
                    }
                    return pd.getNode().getSymbol();
                }
                case 1: {
                    return pd.getSharesHeld();
                }
                case 2: {
                    return pd.getCostBasisPerShare();
                }
                case 3: {
                    return pd.getHeldCostBasis();
                }
                case 4: {
                    return pd.getPrice(this.baseCurrency);
                }
                case 5: {
                    return pd.getMarketValue(this.baseCurrency);
                }
                case 6: {
                    return pd.getUnrealizedGains();
                }
                case 7: {
                    return pd.getRealizedGains();
                }
                case 8: {
                    return pd.getTotalGains();
                }
                case 9: {
                    return pd.getTotalGainsPercentage();
                }
                case 10: {
                    return pd.getPercentPortfolio();
                }
                case 11: {
                    return "group";
                }
            }
            return "ERR";
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PortfolioReport.this.rb.getString("Column.Security");
                }
                case 1: {
                    return PortfolioReport.this.rb.getString("Column.Short.Quantity");
                }
                case 2: {
                    return PortfolioReport.this.rb.getString("Column.CostBasis");
                }
                case 3: {
                    return PortfolioReport.this.rb.getString("Column.TotalCostBasis");
                }
                case 4: {
                    return PortfolioReport.this.rb.getString("Column.Price");
                }
                case 5: {
                    return PortfolioReport.this.rb.getString("Column.Value");
                }
                case 6: {
                    return PortfolioReport.this.rb.getString("Column.Short.UnrealizedGain");
                }
                case 7: {
                    return PortfolioReport.this.rb.getString("Column.Short.RealizedGain");
                }
                case 8: {
                    return PortfolioReport.this.rb.getString("Column.Short.TotalGain");
                }
                case 9: {
                    return PortfolioReport.this.rb.getString("Column.Short.TotalGainPercentage");
                }
                case 10: {
                    return PortfolioReport.this.rb.getString("Column.Short.PercentagePortfolio");
                }
                case 11: {
                    return "group";
                }
            }
            return "ERR";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 11) {
                return String.class;
            }
            return BigDecimal.class;
        }

        @Override
        public CurrencyNode getCurrency() {
            return this.baseCurrency;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ColumnStyle.STRING;
                }
                case 1: {
                    return ColumnStyle.QUANTITY;
                }
                case 2: {
                    return ColumnStyle.BALANCE;
                }
                case 3: {
                    return ColumnStyle.AMOUNT_SUM;
                }
                case 4: {
                    return ColumnStyle.BALANCE;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return ColumnStyle.AMOUNT_SUM;
                }
                case 9: 
                case 10: {
                    return ColumnStyle.PERCENTAGE;
                }
                case 11: {
                    return ColumnStyle.GROUP_NO_HEADER;
                }
            }
            return ColumnStyle.STRING;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            if (columnIndex == 0) {
                return ColumnHeaderStyle.LEFT;
            }
            return ColumnHeaderStyle.RIGHT;
        }

        @Override
        public boolean isColumnFixedWidth(int columnIndex) {
            return columnIndex > 0;
        }
    }
}

