/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.option;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jgnash.engine.EngineFactory;
import jgnash.net.NetworkAuthenticator;
import jgnash.ui.UIApplication;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.register.TransactionNumberDialog;
import jgnash.util.Resource;

class GeneralOptions
extends JPanel
implements ActionListener,
FocusListener {
    private final Resource rb = Resource.get();
    private JTextField accountSeparatorField;
    private JCheckBox authCheckBox;
    private JTextField hostField;
    private JTextField nameField;
    private JPasswordField passwordField;
    private JIntegerField portField;
    private JCheckBox proxyCheckBox;
    private JButton numButton;
    private JDialog parent;
    private JCheckBox selectOnFocusCheckBox;

    protected GeneralOptions(JDialog parent) {
        this.parent = parent;
        this.layoutMainPanel();
        this.showState();
        this.proxyAction();
        this.authAction();
        this.selectOnFocusCheckBox.addActionListener(this);
        this.proxyCheckBox.addActionListener(this);
        this.authCheckBox.addActionListener(this);
        this.numButton.addActionListener(this);
        this.hostField.addFocusListener(this);
        this.portField.addFocusListener(this);
        this.nameField.addFocusListener(this);
        this.passwordField.addFocusListener(this);
        this.accountSeparatorField.addFocusListener(this);
    }

    private void initComponents() {
        this.proxyCheckBox = new JCheckBox(this.rb.getString("Button.UseProxy"));
        this.accountSeparatorField = new JTextField(EngineFactory.getEngine("default").getAccountSeparator());
        this.hostField = new JTextFieldEx();
        this.portField = new JIntegerField();
        this.authCheckBox = new JCheckBox(this.rb.getString("Button.HTTPAuth"));
        this.nameField = new JTextFieldEx();
        this.passwordField = new JPasswordField();
        this.numButton = new JButton(this.rb.getString("Button.EditDefTranNums"));
        this.selectOnFocusCheckBox = new JCheckBox(this.rb.getString("Button.SelectText"));
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("right:p, $lcgap, max(75dlu;p):g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setRowGroupingEnabled(true);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.Display"));
        builder.append(this.rb.getString("Label.AccountSeparator"), (Component)this.accountSeparatorField);
        builder.appendSeparator(this.rb.getString("Title.Defaults"));
        builder.append((Component)this.numButton, 3);
        builder.appendSeparator(this.rb.getString("Title.Entry"));
        builder.append((Component)this.selectOnFocusCheckBox, 3);
        builder.appendSeparator(this.rb.getString("Title.HTTPProxy"));
        builder.append((Component)this.proxyCheckBox, 3);
        builder.append(this.rb.getString("Label.Host"), (Component)this.hostField);
        builder.append(this.rb.getString("Label.Port"), (Component)this.portField);
        builder.append((Component)this.authCheckBox, 3);
        builder.append(this.rb.getString("Label.UserName"), (Component)this.nameField);
        builder.append(this.rb.getString("Label.Password"), (Component)this.passwordField);
    }

    private void showState() {
        this.selectOnFocusCheckBox.setSelected(JTextFieldEx.isSelectOnFocus());
        this.proxyCheckBox.setSelected(NetworkAuthenticator.isProxyUsed());
        this.hostField.setText(NetworkAuthenticator.getHost());
        this.portField.setIntValue(NetworkAuthenticator.getPort());
        this.authCheckBox.setSelected(NetworkAuthenticator.isAuthenticationUsed());
        this.nameField.setText(NetworkAuthenticator.getName());
        this.passwordField.setText(NetworkAuthenticator.getPassword());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.proxyCheckBox) {
            this.proxyAction();
        } else if (e.getSource() == this.authCheckBox) {
            this.authAction();
        } else if (e.getSource() == this.numButton) {
            this.defaultNumAction();
        } else if (e.getSource() == this.selectOnFocusCheckBox) {
            JTextFieldEx.setSelectOnFocus(this.selectOnFocusCheckBox.isSelected());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.portField) {
            this.portAction();
        } else if (e.getSource() == this.hostField) {
            this.hostAction();
        } else if (e.getSource() == this.nameField) {
            this.nameAction();
        } else if (e.getSource() == this.passwordField) {
            this.passwordAction();
        } else if (e.getSource() == this.accountSeparatorField) {
            if (this.accountSeparatorField.getText().length() > 0) {
                EngineFactory.getEngine("default").setAccountSeparator(this.accountSeparatorField.getText());
            } else {
                this.accountSeparatorField.setText(EngineFactory.getEngine("default").getAccountSeparator());
            }
        }
    }

    private void proxyAction() {
        NetworkAuthenticator.setUseProxy(this.proxyCheckBox.isSelected());
        if (this.proxyCheckBox.isSelected()) {
            this.hostField.setEnabled(true);
            this.portField.setEnabled(true);
            System.getProperties().put("http.proxyPort", this.portField.getText());
            System.getProperties().put("http.proxyHost", this.hostField.getText());
        } else {
            this.hostField.setEnabled(false);
            this.portField.setEnabled(false);
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.proxyHost");
        }
    }

    private void portAction() {
        int port = this.portField.intValue();
        NetworkAuthenticator.setPort(port);
        if (this.portField.getText().length() != 0 && port > 0) {
            System.getProperties().put("http.proxyPort", (Object)port);
        } else {
            System.getProperties().remove("http.proxyPort");
        }
    }

    private void hostAction() {
        String host = this.hostField.getText();
        NetworkAuthenticator.setHost(host);
        if (host.length() != 0) {
            System.getProperties().put("http.proxyHost", host);
        } else {
            System.getProperties().remove("http.proxyHost");
        }
    }

    private void authAction() {
        NetworkAuthenticator.setUseAuthentication(this.authCheckBox.isSelected());
        if (this.authCheckBox.isSelected()) {
            this.nameField.setEnabled(true);
            this.passwordField.setEnabled(true);
        } else {
            this.nameField.setEnabled(false);
            this.passwordField.setEnabled(false);
        }
    }

    private void nameAction() {
        NetworkAuthenticator.setName(this.nameField.getText());
    }

    private void passwordAction() {
        NetworkAuthenticator.setPassword(new String(this.passwordField.getPassword()));
    }

    private void defaultNumAction() {
        this.parent.setVisible(false);
        TransactionNumberDialog.showDialog(UIApplication.getFrame());
        this.parent.setVisible(true);
    }
}

