/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import jgnash.engine.dao.RecurringDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;
import jgnash.engine.recurring.Reminder;

class Db4oRecurringDAO
extends AbstractDb4oDAO
implements RecurringDAO {
    private static final String SEMAPHORE_NAME = "ReminderLock";
    private Logger logger = Logger.getLogger(Db4oRecurringDAO.class.getName());

    Db4oRecurringDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
    }

    @Override
    public List<Reminder> getReminderList() {
        if (this.container.ext().setSemaphore(SEMAPHORE_NAME, 20000)) {
            Object list = this.container.query(Reminder.class);
            if (list != null) {
                list = new ArrayList(list);
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    if (!((Reminder)i.next()).isMarkedForRemoval()) continue;
                    i.remove();
                }
            } else {
                list = Collections.emptyList();
            }
            this.container.ext().releaseSemaphore(SEMAPHORE_NAME);
            return list;
        }
        this.logger.severe("Could not obtain global semaphore");
        return Collections.emptyList();
    }

    @Override
    public boolean addReminder(Reminder reminder) {
        boolean result = false;
        if (this.container.ext().setSemaphore(SEMAPHORE_NAME, 20000)) {
            this.container.set((Object)reminder);
            this.commit();
            this.container.ext().releaseSemaphore(SEMAPHORE_NAME);
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean updateReminder(Reminder reminder) {
        boolean result = false;
        if (this.container.ext().setSemaphore(SEMAPHORE_NAME, 20000)) {
            this.container.set((Object)reminder);
            this.commit();
            this.container.ext().releaseSemaphore(SEMAPHORE_NAME);
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public void refreshReminder(Reminder reminder) {
        this.container.ext().refresh((Object)reminder, 2);
    }
}

