/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import java.util.logging.Logger;
import jgnash.engine.Config;
import jgnash.engine.dao.ConfigDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;

class Db4oConfigDAO
extends AbstractDb4oDAO
implements ConfigDAO {
    private static final String CONFIG_SEMAPHORE = "ConfigLock";
    private Logger logger = Logger.getLogger(Db4oConfigDAO.class.getName());

    Db4oConfigDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
    }

    @Override
    public synchronized Config getDefaultConfig() {
        Config defaultConfig = null;
        if (this.container.ext().setSemaphore(CONFIG_SEMAPHORE, 20000)) {
            ObjectSet list = this.container.query((Predicate)new ConfigSearchPredicate("DefaultConfig"));
            if (!list.isEmpty()) {
                defaultConfig = (Config)list.get(0);
            }
            if (defaultConfig == null) {
                defaultConfig = new Config();
                this.container.set((Object)defaultConfig);
                this.commit();
                this.logger.info("Generating new default config");
            }
            this.container.ext().releaseSemaphore(CONFIG_SEMAPHORE);
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return defaultConfig;
    }

    @Override
    public void commit(Config config) {
        if (this.container.ext().setSemaphore(CONFIG_SEMAPHORE, 20000)) {
            this.container.set((Object)config);
            this.commit();
            this.container.ext().releaseSemaphore(CONFIG_SEMAPHORE);
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
    }

    private static class ConfigSearchPredicate
    extends Predicate<Config> {
        private static final long serialVersionUID = -8586141922361861174L;
        private String name;

        ConfigSearchPredicate(String name) {
            this.name = name;
        }

        public boolean match(Config config) {
            return config.getName().equals(this.name);
        }
    }
}

