/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.StoredObject;

public class ExchangeRate
extends StoredObject {
    private static final long serialVersionUID = -2365289994847042288L;
    private List<ExchangeRateHistoryNode> historyNodes = new ArrayList<ExchangeRateHistoryNode>();
    private transient BigDecimal lastRate;
    private String rateId;
    private transient ReadWriteLock lock;

    @Deprecated
    public ExchangeRate() {
    }

    protected ExchangeRate(String rateId) {
        this.rateId = rateId;
    }

    private synchronized ReadWriteLock getLock() {
        if (this.lock == null) {
            this.lock = new ReentrantReadWriteLock(true);
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ExchangeRateHistoryNode node) {
        Lock l = this.getLock().readLock();
        l.lock();
        boolean result = false;
        try {
            result = this.historyNodes.contains(node);
        }
        finally {
            l.unlock();
        }
        return result;
    }

    public List<ExchangeRateHistoryNode> getHistory() {
        return new ArrayList<ExchangeRateHistoryNode>(this.historyNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addHistoryNode(ExchangeRateHistoryNode node) {
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            int index = Collections.binarySearch(this.historyNodes, node);
            if (index < 0) {
                this.historyNodes.add(-index - 1, node);
            } else {
                this.historyNodes.set(index, node);
            }
            this.lastRate = null;
        }
        finally {
            l.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeHistoryNode(ExchangeRateHistoryNode hNode) {
        boolean result = false;
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            result = this.historyNodes.remove(hNode);
            if (result) {
                this.lastRate = null;
            }
        }
        finally {
            l.unlock();
        }
        return result;
    }

    public String getRateId() {
        return this.rateId;
    }

    public BigDecimal getRate() {
        this.getLock().readLock().lock();
        if (this.lastRate == null) {
            this.lastRate = !this.historyNodes.isEmpty() ? this.historyNodes.get(this.historyNodes.size() - 1).getRate() : BigDecimal.ONE;
        }
        this.getLock().readLock().unlock();
        return this.lastRate;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return this == other || other instanceof ExchangeRate && this.rateId.equals(((ExchangeRate)other).rateId);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 67 + this.rateId.hashCode();
    }
}

