/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.foundation.IntArrayList;
import com.db4o.internal.query.processor.Orderable;

class Order
implements Orderable {
    private int i_major;
    private IntArrayList i_minors = new IntArrayList();

    Order() {
    }

    public int compareTo(Object object) {
        if (object instanceof Order) {
            Order order = (Order)object;
            int n = this.i_major - order.i_major;
            if (n != 0) {
                return n;
            }
            return this.compareMinors(order.i_minors);
        }
        return -1;
    }

    public void hintOrder(int n, boolean bl) {
        if (bl) {
            this.i_major = n;
        } else {
            this.appendMinor(n);
        }
    }

    public boolean hasDuplicates() {
        return true;
    }

    public String toString() {
        String string = "Order " + this.i_major;
        for (int i = 0; i < this.i_minors.size(); ++i) {
            string = string + " " + this.i_minors.get(i);
        }
        return string;
    }

    public void swapMajorToMinor() {
        this.insertMinor(this.i_major);
        this.i_major = 0;
    }

    private void appendMinor(int n) {
        this.i_minors.add(n);
    }

    private void insertMinor(int n) {
        this.i_minors.add(0, n);
    }

    private int compareMinors(IntArrayList intArrayList) {
        if (this.i_minors.size() != intArrayList.size()) {
            throw new RuntimeException("Unexpected exception: this..size()=" + this.i_minors.size() + ", other.size()=" + intArrayList.size());
        }
        int n = 0;
        for (int i = 0; i < this.i_minors.size(); ++i) {
            if (this.i_minors.get(i) == intArrayList.get(i)) continue;
            return this.i_minors.get(i) - intArrayList.get(i);
        }
        return n;
    }
}

