/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.marshall.FieldListInfo;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.MarshallingInfo;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public abstract class ObjectMarshaller {
    public MarshallerFamily _family;

    protected final void traverseFields(MarshallingInfo marshallingInfo, TraverseFieldCommand traverseFieldCommand) {
        this.traverseFields(marshallingInfo.classMetadata(), marshallingInfo.buffer(), marshallingInfo, traverseFieldCommand);
    }

    protected final void traverseFields(ClassMetadata classMetadata, Buffer buffer, FieldListInfo fieldListInfo, TraverseFieldCommand traverseFieldCommand) {
        int n = 0;
        while (classMetadata != null && !traverseFieldCommand.cancelled()) {
            int n2 = traverseFieldCommand.fieldCount(classMetadata, buffer);
            for (int i = 0; i < n2 && !traverseFieldCommand.cancelled(); ++i) {
                traverseFieldCommand.processField(classMetadata.i_fields[i], this.isNull(fieldListInfo, n), classMetadata);
                ++n;
            }
            classMetadata = classMetadata.i_ancestor;
        }
    }

    protected abstract boolean isNull(FieldListInfo var1, int var2);

    public abstract void addFieldIndices(ClassMetadata var1, ObjectHeaderAttributes var2, StatefulBuffer var3, Slot var4);

    public abstract TreeInt collectFieldIDs(TreeInt var1, ClassMetadata var2, ObjectHeaderAttributes var3, StatefulBuffer var4, String var5);

    protected StatefulBuffer createWriterForNew(Transaction transaction, ObjectReference objectReference, int n, int n2) {
        int n3 = objectReference.getID();
        Slot slot = new Slot(-1, n2);
        if (transaction instanceof LocalTransaction) {
            slot = ((LocalTransaction)transaction).file().getSlot(n2);
            transaction.slotFreeOnRollback(n3, slot);
        }
        transaction.setPointer(n3, slot);
        return this.createWriterForUpdate(transaction, n, n3, slot.address(), slot.length());
    }

    protected StatefulBuffer createWriterForUpdate(Transaction transaction, int n, int n2, int n3, int n4) {
        n4 = transaction.container().blockAlignedBytes(n4);
        StatefulBuffer statefulBuffer = new StatefulBuffer(transaction, n4);
        statefulBuffer.useSlot(n2, n3, n4);
        statefulBuffer.setUpdateDepth(n);
        return statefulBuffer;
    }

    public abstract void deleteMembers(ClassMetadata var1, ObjectHeaderAttributes var2, StatefulBuffer var3, int var4, boolean var5);

    public abstract boolean findOffset(ClassMetadata var1, FieldListInfo var2, Buffer var3, FieldMetadata var4);

    public final void marshallUpdateWrite(Transaction transaction, Pointer4 pointer4, ObjectReference objectReference, Object object, Buffer buffer) {
        ClassMetadata classMetadata = objectReference.classMetadata();
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.writeUpdate(transaction, pointer4, classMetadata, buffer);
        if (objectReference.isActive()) {
            objectReference.setStateClean();
        }
        objectReference.endProcessing();
        this.objectOnUpdate(transaction, classMetadata, object);
    }

    private void objectOnUpdate(Transaction transaction, ClassMetadata classMetadata, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.callbacks().objectOnUpdate(transaction, object);
        classMetadata.dispatchEvent(transaction, object, 5);
    }

    public abstract Object readIndexEntry(ClassMetadata var1, ObjectHeaderAttributes var2, FieldMetadata var3, StatefulBuffer var4);

    public abstract ObjectHeaderAttributes readHeaderAttributes(Buffer var1);

    public abstract void readVirtualAttributes(Transaction var1, ClassMetadata var2, ObjectReference var3, ObjectHeaderAttributes var4, Buffer var5);

    public abstract void defragFields(ClassMetadata var1, ObjectHeader var2, BufferPair var3);

    public abstract void writeObjectClassID(Buffer var1, int var2);

    public abstract void skipMarshallerInfo(Buffer var1);

    public final void instantiateFields(final UnmarshallingContext unmarshallingContext) {
        TraverseFieldCommand traverseFieldCommand = new TraverseFieldCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                if (bl) {
                    fieldMetadata.set(unmarshallingContext.persistentObject(), null);
                    return;
                }
                boolean bl2 = false;
                try {
                    fieldMetadata.instantiate(unmarshallingContext);
                    bl2 = true;
                }
                finally {
                    if (!bl2) {
                        this.cancel();
                    }
                }
            }
        };
        this.traverseFields(unmarshallingContext, traverseFieldCommand);
    }

    public void marshall(final Object object, final MarshallingContext marshallingContext) {
        final Transaction transaction = marshallingContext.transaction();
        TraverseFieldCommand traverseFieldCommand = new TraverseFieldCommand(){
            private int fieldIndex = -1;

            public int fieldCount(ClassMetadata classMetadata, Buffer buffer) {
                int n = classMetadata.i_fields.length;
                marshallingContext.fieldCount(n);
                return n;
            }

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                marshallingContext.nextField();
                ++this.fieldIndex;
                Object object2 = fieldMetadata.getOrCreate(transaction, object);
                if (object2 == null) {
                    marshallingContext.isNull(this.fieldIndex, true);
                    fieldMetadata.addIndexEntry(transaction, marshallingContext.objectID(), null);
                    return;
                }
                if (object2 instanceof Db4oTypeImpl) {
                    object2 = ((Db4oTypeImpl)object2).storedTo(transaction);
                }
                fieldMetadata.marshall(marshallingContext, object2);
            }
        };
        this.traverseFields(marshallingContext, traverseFieldCommand);
    }

    protected static abstract class TraverseFieldCommand {
        private boolean _cancelled = false;

        protected TraverseFieldCommand() {
        }

        public int fieldCount(ClassMetadata classMetadata, Buffer buffer) {
            return classMetadata.readFieldCount(buffer);
        }

        public boolean cancelled() {
            return this._cancelled;
        }

        protected void cancel() {
            this._cancelled = true;
        }

        public abstract void processField(FieldMetadata var1, boolean var2, ClassMetadata var3);
    }
}

