/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.BlobTransport;
import com.db4o.DatabaseClosedException;
import com.db4o.Db4o;
import com.db4o.Db4oIOException;
import com.db4o.InvalidPasswordException;
import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.ExtClient;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.BlockingQueueStoppedException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.network.LoopbackSocket;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Serializer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.UnicodeStringIO;
import com.db4o.internal.cs.BlobProcessor;
import com.db4o.internal.cs.ClassInfo;
import com.db4o.internal.cs.ClientHeartbeat;
import com.db4o.internal.cs.ClientMessageDispatcher;
import com.db4o.internal.cs.ClientMessageDispatcherImpl;
import com.db4o.internal.cs.ClientQueryResult;
import com.db4o.internal.cs.ClientTransaction;
import com.db4o.internal.cs.LazyClientQueryResult;
import com.db4o.internal.cs.messages.ClientSideMessage;
import com.db4o.internal.cs.messages.MDeleteBlobFile;
import com.db4o.internal.cs.messages.MRuntimeException;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgBlob;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.slots.Pointer4;
import com.db4o.reflect.ReflectClass;
import java.io.File;
import java.io.IOException;

public class ClientObjectContainer
extends ExternalObjectContainer
implements ExtClient,
BlobTransport,
ClientMessageDispatcher {
    final Object blobLock = new Object();
    private BlobProcessor blobThread;
    private Socket4 i_socket;
    private BlockingQueue _messageQueue = new BlockingQueue();
    private final String _password;
    int[] _prefetchedIDs;
    ClientMessageDispatcher _messageDispatcher;
    int remainingIDs;
    private String switchedToFile;
    private boolean _singleThreaded;
    private final String _userName;
    private Db4oDatabase i_db;
    protected boolean _doFinalize = true;
    private int _blockSize = 1;
    private Collection4 _batchedMessages = new Collection4();
    private int _batchedQueueLength = 4;
    private boolean _login;
    private final ClientHeartbeat _heartbeat;

    public ClientObjectContainer(Configuration configuration, Socket4 socket4, String string, String string2, boolean bl) {
        super(configuration, null);
        this._userName = string;
        this._password = string2;
        this._login = bl;
        this._heartbeat = new ClientHeartbeat(this);
        this.setAndConfigSocket(socket4);
        this.open();
    }

    private void setAndConfigSocket(Socket4 socket4) {
        this.i_socket = socket4;
        this.i_socket.setSoTimeout(this._config.timeoutClientSocket());
    }

    protected final void openImpl() {
        this._singleThreaded = this.configImpl().singleThreadedClient();
        if (this._login) {
            this.loginToServer(this.i_socket);
        }
        if (!this._singleThreaded) {
            this.startDispatcherThread(this.i_socket, this._userName);
        }
        this.logMsg(36, this.toString());
        this.startHeartBeat();
        this.readThis();
    }

    private void startHeartBeat() {
        this._heartbeat.start();
    }

    private void startDispatcherThread(Socket4 socket4, String string) {
        this._messageDispatcher = new ClientMessageDispatcherImpl(this, socket4, this._messageQueue);
        this._messageDispatcher.setDispatcherName(string);
        this._messageDispatcher.startDispatcher();
    }

    public void backup(String string) throws NotSupportedException {
        throw new NotSupportedException();
    }

    public void reserve(int n) {
        throw new NotSupportedException();
    }

    public void blockSize(int n) {
        this._blockSize = n;
    }

    public byte blockSize() {
        return (byte)this._blockSize;
    }

    protected void close2() {
        if (!(this._singleThreaded || this._messageDispatcher != null && this._messageDispatcher.isMessageDispatcherAlive())) {
            this.stopHeartBeat();
            this.shutdownObjectContainer();
            return;
        }
        try {
            this.commit1(this._transaction);
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        try {
            this.write(Msg.CLOSE);
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        this.shutDownCommunicationRessources();
        try {
            this.i_socket.close();
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        this.shutdownObjectContainer();
    }

    private void stopHeartBeat() {
        this._heartbeat.stop();
    }

    private void closeMessageDispatcher() {
        try {
            if (!this._singleThreaded) {
                this._messageDispatcher.close();
            }
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
    }

    public final void commit1(Transaction transaction) {
        transaction.commit();
    }

    public int converterVersion() {
        return 6;
    }

    Socket4 createParalellSocket() throws IOException {
        this.write(Msg.GET_THREAD_ID);
        int n = this.expectedByteResponse(Msg.ID_LIST).readInt();
        Socket4 socket4 = this.i_socket.openParalellSocket();
        if (!(this.i_socket instanceof LoopbackSocket)) {
            this.loginToServer(socket4);
        }
        if (this.switchedToFile != null) {
            MsgD msgD = Msg.SWITCH_TO_FILE.getWriterForString(this.systemTransaction(), this.switchedToFile);
            msgD.write(socket4);
            if (!Msg.OK.equals(Msg.readMessage(this, this.systemTransaction(), socket4))) {
                throw new IOException(Messages.get(42));
            }
        }
        Msg.USE_TRANSACTION.getWriterForInt(this._transaction, n).write(socket4);
        return socket4;
    }

    public AbstractQueryResult newQueryResult(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        throw new IllegalStateException();
    }

    public final Transaction newTransaction(Transaction transaction, TransactionalReferenceSystem transactionalReferenceSystem) {
        return new ClientTransaction(this, transaction, transactionalReferenceSystem);
    }

    public boolean createClassMetadata(ClassMetadata classMetadata, ReflectClass reflectClass, ClassMetadata classMetadata2) {
        this.write(Msg.CREATE_CLASS.getWriterForString(this.systemTransaction(), reflectClass.getName()));
        Msg msg = this.getResponse();
        if (msg == null) {
            return false;
        }
        if (msg.equals(Msg.FAILED)) {
            this.sendClassMeta(reflectClass);
            msg = this.getResponse();
        }
        if (msg.equals(Msg.FAILED)) {
            if (this.configImpl().exceptionsOnNotStorable()) {
                throw new ObjectNotStorableException(reflectClass);
            }
            return false;
        }
        if (!msg.equals(Msg.OBJECT_TO_CLIENT)) {
            return false;
        }
        MsgObject msgObject = (MsgObject)msg;
        StatefulBuffer statefulBuffer = msgObject.unmarshall();
        if (statefulBuffer == null) {
            return false;
        }
        statefulBuffer.setTransaction(this.systemTransaction());
        if (!super.createClassMetadata(classMetadata, reflectClass, classMetadata2)) {
            return false;
        }
        classMetadata.setID(msgObject.getId());
        classMetadata.readName1(this.systemTransaction(), statefulBuffer);
        this.classCollection().addClassMetadata(classMetadata);
        this.classCollection().readClassMetadata(classMetadata, reflectClass);
        return true;
    }

    private void sendClassMeta(ReflectClass reflectClass) {
        ClassInfo classInfo = this._classMetaHelper.getClassMeta(reflectClass);
        this.write(Msg.CLASS_META.getWriter(Serializer.marshall(this.systemTransaction(), (Object)classInfo)));
    }

    public long currentVersion() {
        this.write(Msg.CURRENT_VERSION);
        return ((MsgD)this.expectedResponse(Msg.ID_LIST)).readLong();
    }

    public final boolean delete4(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        MsgD msgD = Msg.DELETE.getWriterForInts(this._transaction, new int[]{objectReference.getID(), bl ? 1 : 0});
        this.writeBatchedMessage(msgD);
        return true;
    }

    public boolean detectSchemaChanges() {
        return false;
    }

    protected boolean doFinalize() {
        return this._doFinalize;
    }

    final Buffer expectedByteResponse(Msg msg) {
        Msg msg2 = this.expectedResponse(msg);
        if (msg2 == null) {
            return null;
        }
        return msg2.getByteLoad();
    }

    public final Msg expectedResponse(Msg msg) {
        Msg msg2 = this.getResponse();
        if (msg.equals(msg2)) {
            return msg2;
        }
        this.checkExceptionMessage(msg2);
        throw new IllegalStateException("Unexpected Message:" + msg2 + "  Expected:" + msg);
    }

    private void checkExceptionMessage(Msg msg) {
        if (msg instanceof MRuntimeException) {
            ((MRuntimeException)msg).throwPayload();
        }
    }

    public AbstractQueryResult getAll(Transaction transaction) {
        int n = this.config().queryEvaluationMode().asInt();
        MsgD msgD = Msg.GET_ALL.getWriterForInt(transaction, n);
        this.write(msgD);
        return this.readQueryResult(transaction);
    }

    public Msg getResponse() {
        return this._singleThreaded ? this.getResponseSingleThreaded() : this.getResponseMultiThreaded();
    }

    private Msg getResponseMultiThreaded() {
        Msg msg;
        try {
            msg = (Msg)this._messageQueue.next();
        }
        catch (BlockingQueueStoppedException blockingQueueStoppedException) {
            msg = Msg.ERROR;
        }
        if (msg == Msg.ERROR) {
            this.onMsgError();
        }
        return msg;
    }

    private void onMsgError() {
        this.close();
        throw new DatabaseClosedException();
    }

    private Msg getResponseSingleThreaded() {
        while (this.isMessageDispatcherAlive()) {
            try {
                Msg msg = Msg.readMessage(this, this._transaction, this.i_socket);
                if (msg instanceof ClientSideMessage && ((ClientSideMessage)((Object)msg)).processAtClient()) continue;
                return msg;
            }
            catch (Db4oIOException db4oIOException) {
                this.onMsgError();
            }
        }
        return null;
    }

    public boolean isMessageDispatcherAlive() {
        return this.i_socket != null;
    }

    public ClassMetadata classMetadataForId(int n) {
        ReflectClass reflectClass;
        if (n == 0) {
            return null;
        }
        ClassMetadata classMetadata = super.classMetadataForId(n);
        if (classMetadata != null) {
            return classMetadata;
        }
        MsgD msgD = Msg.CLASS_NAME_FOR_ID.getWriterForInt(this.systemTransaction(), n);
        this.write(msgD);
        MsgD msgD2 = (MsgD)this.expectedResponse(Msg.CLASS_NAME_FOR_ID);
        String string = msgD2.readString();
        if (string != null && string.length() > 0 && (reflectClass = this.reflector().forName(string)) != null) {
            return this.produceClassMetadata(reflectClass);
        }
        return null;
    }

    public boolean needsLockFileThread() {
        return false;
    }

    protected boolean hasShutDownHook() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oDatabase identity() {
        if (this.i_db == null) {
            this.write(Msg.IDENTITY);
            Buffer buffer = this.expectedByteResponse(Msg.ID_LIST);
            this.showInternalClasses(true);
            try {
                this.i_db = (Db4oDatabase)this.getByID(buffer.readInt());
                this.activate(this.systemTransaction(), this.i_db, 3);
            }
            finally {
                this.showInternalClasses(false);
            }
        }
        return this.i_db;
    }

    public boolean isClient() {
        return true;
    }

    private void loginToServer(Socket4 socket4) throws InvalidPasswordException {
        UnicodeStringIO unicodeStringIO = new UnicodeStringIO();
        int n = unicodeStringIO.length(this._userName) + unicodeStringIO.length(this._password);
        MsgD msgD = Msg.LOGIN.getWriterForLength(this.systemTransaction(), n);
        msgD.writeString(this._userName);
        msgD.writeString(this._password);
        msgD.write(socket4);
        Msg msg = this.readLoginMessage(socket4);
        StatefulBuffer statefulBuffer = msg.payLoad();
        this._blockSize = statefulBuffer.readInt();
        int n2 = statefulBuffer.readInt();
        if (n2 == 0) {
            this._handlers.oldEncryptionOff();
        }
    }

    private Msg readLoginMessage(Socket4 socket4) {
        Msg msg = Msg.readMessage(this, this.systemTransaction(), socket4);
        while (Msg.PONG.equals(msg)) {
            msg = Msg.readMessage(this, this.systemTransaction(), socket4);
        }
        if (!Msg.LOGIN_OK.equals(msg)) {
            throw new InvalidPasswordException();
        }
        return msg;
    }

    public boolean maintainsIndices() {
        return false;
    }

    public final int newUserObject() {
        int n = this.config().prefetchIDCount();
        this.ensureIDCacheAllocated(n);
        Buffer buffer = null;
        if (this.remainingIDs < 1) {
            MsgD msgD = Msg.PREFETCH_IDS.getWriterForInt(this._transaction, n);
            this.write(msgD);
            buffer = this.expectedByteResponse(Msg.ID_LIST);
            for (int i = n - 1; i >= 0; --i) {
                this._prefetchedIDs[i] = buffer.readInt();
            }
            this.remainingIDs = n;
        }
        --this.remainingIDs;
        return this._prefetchedIDs[this.remainingIDs];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBlobMessage(MsgBlob msgBlob) {
        Object object = this.blobLock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = this.blobThread == null || this.blobThread.isTerminated();
            if (bl) {
                this.blobThread = new BlobProcessor(this);
            }
            this.blobThread.add(msgBlob);
            if (bl) {
                this.blobThread.start();
            }
        }
    }

    public void raiseVersion(long l) {
        this.write(Msg.RAISE_VERSION.getWriterForLong(this._transaction, l));
    }

    public void readBytes(byte[] byArray, int n, int n2, int n3) {
        throw Exceptions4.virtualException();
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        MsgD msgD = Msg.READ_BYTES.getWriterForInts(this._transaction, new int[]{n, n2});
        this.write(msgD);
        Buffer buffer = this.expectedByteResponse(Msg.READ_BYTES);
        System.arraycopy(buffer._buffer, 0, byArray, 0, n2);
    }

    protected boolean rename1(Config4Impl config4Impl) {
        this.logMsg(58, null);
        return false;
    }

    public final StatefulBuffer readWriterByID(Transaction transaction, int n) {
        MsgD msgD = Msg.READ_OBJECT.getWriterForInt(transaction, n);
        this.write(msgD);
        StatefulBuffer statefulBuffer = ((MsgObject)this.expectedResponse(Msg.OBJECT_TO_CLIENT)).unmarshall();
        if (statefulBuffer != null) {
            statefulBuffer.setTransaction(transaction);
        }
        return statefulBuffer;
    }

    public final StatefulBuffer[] readWritersByIDs(Transaction transaction, int[] nArray) {
        MsgD msgD = Msg.READ_MULTIPLE_OBJECTS.getWriterForIntArray(transaction, nArray, nArray.length);
        this.write(msgD);
        MsgD msgD2 = (MsgD)this.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
        int n = msgD2.readInt();
        StatefulBuffer[] statefulBufferArray = new StatefulBuffer[n];
        for (int i = 0; i < n; ++i) {
            MsgObject msgObject = (MsgObject)Msg.OBJECT_TO_CLIENT.publicClone();
            msgObject.setTransaction(transaction);
            msgObject.payLoad(msgD2.payLoad().readYapBytes());
            if (msgObject.payLoad() == null) continue;
            msgObject.payLoad().incrementOffset(9);
            statefulBufferArray[i] = msgObject.unmarshall(9);
            statefulBufferArray[i].setTransaction(transaction);
        }
        return statefulBufferArray;
    }

    public final Buffer readReaderByID(Transaction transaction, int n) {
        return this.readWriterByID(transaction, n);
    }

    private AbstractQueryResult readQueryResult(Transaction transaction) {
        AbstractQueryResult abstractQueryResult = null;
        Buffer buffer = this.expectedByteResponse(Msg.QUERY_RESULT);
        int n = buffer.readInt();
        abstractQueryResult = n > 0 ? new LazyClientQueryResult(transaction, this, n) : new ClientQueryResult(transaction);
        ((AbstractQueryResult)abstractQueryResult).loadFromIdReader(buffer);
        return abstractQueryResult;
    }

    void readThis() {
        this.write(Msg.GET_CLASSES.getWriter(this.systemTransaction()));
        Buffer buffer = this.expectedByteResponse(Msg.GET_CLASSES);
        this.classCollection().setID(buffer.readInt());
        this.createStringIO(buffer.readByte());
        this.classCollection().read(this.systemTransaction());
        this.classCollection().refreshClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphore(String string) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            if (string == null) {
                throw new NullPointerException();
            }
            this.write(Msg.RELEASE_SEMAPHORE.getWriterForString(this._transaction, string));
        }
    }

    public void releaseSemaphores(Transaction transaction) {
    }

    private void reReadAll(Configuration configuration) {
        this.remainingIDs = 0;
        this.initialize1(configuration);
        this.initializeTransactions();
        this.readThis();
    }

    public final void rollback1(Transaction transaction) {
        if (this._config.batchMessages()) {
            this.clearBatchedObjects();
        }
        this.write(Msg.ROLLBACK);
        transaction.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            if (object != null) {
                this.write(Msg.USER_MESSAGE.getWriter(Serializer.marshall(this._transaction, object)));
            }
        }
    }

    public final void setDirtyInSystemTransaction(PersistentBase persistentBase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSemaphore(String string, int n) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            if (string == null) {
                throw new NullPointerException();
            }
            MsgD msgD = Msg.SET_SEMAPHORE.getWriterForIntString(this._transaction, n, string);
            this.write(msgD);
            Msg msg = this.getResponse();
            return msg.equals(Msg.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToFile(String string) {
        Object object = this._lock;
        synchronized (object) {
            this.commit();
            MsgD msgD = Msg.SWITCH_TO_FILE.getWriterForString(this._transaction, string);
            this.write(msgD);
            this.expectedResponse(Msg.OK);
            this.reReadAll(Db4o.cloneConfiguration());
            this.switchedToFile = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMainFile() {
        Object object = this._lock;
        synchronized (object) {
            this.commit();
            this.write(Msg.SWITCH_TO_MAIN_FILE);
            this.expectedResponse(Msg.OK);
            this.reReadAll(Db4o.cloneConfiguration());
            this.switchedToFile = null;
        }
    }

    public String name() {
        return this.toString();
    }

    public String toString() {
        return "Client Connection " + this._userName;
    }

    public void shutdown() {
    }

    public final void writeDirty() {
    }

    public final boolean write(Msg msg) {
        this.writeMsg(msg, true);
        return true;
    }

    public final void writeBatchedMessage(Msg msg) {
        this.writeMsg(msg, false);
    }

    private final void writeMsg(Msg msg, boolean bl) {
        if (this._config.batchMessages()) {
            if (bl && this._batchedMessages.isEmpty()) {
                this.writeMessageToSocket(msg);
            } else {
                this.addToBatch(msg);
                if (bl || this._batchedQueueLength > this._config.maxBatchQueueSize()) {
                    this.writeBatchedMessages();
                }
            }
        } else {
            this.writeMessageToSocket(msg);
        }
    }

    public boolean writeMessageToSocket(Msg msg) {
        return msg.write(this.i_socket);
    }

    public final void writeNew(Transaction transaction, Pointer4 pointer4, ClassMetadata classMetadata, Buffer buffer) {
        MsgD msgD = Msg.WRITE_NEW.getWriter(transaction, pointer4, classMetadata, buffer);
        this.writeBatchedMessage(msgD);
    }

    public final void writeTransactionPointer(int n) {
    }

    public final void writeUpdate(Transaction transaction, Pointer4 pointer4, ClassMetadata classMetadata, Buffer buffer) {
        MsgD msgD = Msg.WRITE_UPDATE.getWriter(transaction, pointer4, classMetadata, buffer);
        this.writeBatchedMessage(msgD);
    }

    public boolean isAlive() {
        try {
            this.write(Msg.IS_ALIVE);
            return this.expectedResponse(Msg.IS_ALIVE) != null;
        }
        catch (Db4oException db4oException) {
            return false;
        }
    }

    public Socket4 socket() {
        return this.i_socket;
    }

    private void ensureIDCacheAllocated(int n) {
        if (this._prefetchedIDs == null) {
            this._prefetchedIDs = new int[n];
            return;
        }
        if (n > this._prefetchedIDs.length) {
            int[] nArray = new int[n];
            System.arraycopy(this._prefetchedIDs, 0, nArray, 0, this._prefetchedIDs.length);
            this._prefetchedIDs = nArray;
        }
    }

    public SystemInfo systemInfo() {
        throw new NotImplementedException("Functionality not availble on clients.");
    }

    public void writeBlobTo(Transaction transaction, BlobImpl blobImpl, File file) throws IOException {
        MsgBlob msgBlob = (MsgBlob)Msg.READ_BLOB.getWriterForInt(transaction, (int)this.getID(blobImpl));
        msgBlob._blob = blobImpl;
        this.processBlobMessage(msgBlob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlobFrom(Transaction transaction, BlobImpl blobImpl, File file) throws IOException {
        MsgBlob msgBlob = null;
        Object object = this.lock();
        synchronized (object) {
            this.set(blobImpl);
            int n = (int)this.getID(blobImpl);
            msgBlob = (MsgBlob)Msg.WRITE_BLOB.getWriterForInt(transaction, n);
            msgBlob._blob = blobImpl;
            blobImpl.setStatus(-3.0);
        }
        this.processBlobMessage(msgBlob);
    }

    public void deleteBlobFile(Transaction transaction, BlobImpl blobImpl) {
        MDeleteBlobFile mDeleteBlobFile = (MDeleteBlobFile)Msg.DELETE_BLOB_FILE.getWriterForInt(transaction, (int)this.getID(blobImpl));
        this.writeMsg(mDeleteBlobFile, false);
    }

    public long[] getIDsForClass(Transaction transaction, ClassMetadata classMetadata) {
        MsgD msgD = Msg.GET_INTERNAL_IDS.getWriterForInt(transaction, classMetadata.getID());
        this.write(msgD);
        Buffer buffer = this.expectedByteResponse(Msg.ID_LIST);
        int n = buffer.readInt();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = buffer.readInt();
        }
        return lArray;
    }

    public QueryResult classOnlyQuery(Transaction transaction, ClassMetadata classMetadata) {
        long[] lArray = classMetadata.getIDs(transaction);
        ClientQueryResult clientQueryResult = new ClientQueryResult(transaction, lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            clientQueryResult.add((int)lArray[i]);
        }
        return clientQueryResult;
    }

    public QueryResult executeQuery(QQuery qQuery) {
        Transaction transaction = qQuery.getTransaction();
        qQuery.evaluationMode(this.config().queryEvaluationMode());
        qQuery.marshall();
        MsgD msgD = Msg.QUERY_EXECUTE.getWriter(Serializer.marshall(transaction, (Object)qQuery));
        this.write(msgD);
        return this.readQueryResult(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBatchedMessages() {
        Object object = this.lock();
        synchronized (object) {
            if (this._batchedMessages.isEmpty()) {
                return;
            }
            MsgD msgD = Msg.WRITE_BATCHED_MESSAGES.getWriterForLength(this.transaction(), this._batchedQueueLength);
            msgD.writeInt(this._batchedMessages.size());
            Iterator4 iterator4 = this._batchedMessages.iterator();
            while (iterator4.moveNext()) {
                Msg msg = (Msg)iterator4.current();
                if (msg == null) {
                    msgD.writeInt(0);
                    continue;
                }
                msgD.writeInt(msg.payLoad().length());
                msgD.payLoad().append(msg.payLoad()._buffer);
            }
            this.writeMessageToSocket(msgD);
            this.clearBatchedObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToBatch(Msg msg) {
        Object object = this.lock();
        synchronized (object) {
            this._batchedMessages.add(msg);
            this._batchedQueueLength += 4 + msg.payLoad().length();
        }
    }

    private final void clearBatchedObjects() {
        this._batchedMessages.clear();
        this._batchedQueueLength = 4;
    }

    int timeout() {
        return this.configImpl().timeoutClientSocket();
    }

    protected void shutdownDataStorage() {
        this.shutDownCommunicationRessources();
    }

    private void shutDownCommunicationRessources() {
        this.stopHeartBeat();
        this.closeMessageDispatcher();
        this._messageQueue.stop();
    }

    public void setDispatcherName(String string) {
    }

    public void startDispatcher() {
    }

    public ClientMessageDispatcher messageDispatcher() {
        return this._singleThreaded ? this : this._messageDispatcher;
    }

    public void onCommittedListener() {
        if (this._singleThreaded) {
            return;
        }
        this.write(Msg.COMMITTED_CALLBACK_REGISTER);
    }

    public int classMetadataIdForName(String string) {
        MsgD msgD = Msg.CLASS_METADATA_ID_FOR_NAME.getWriterForString(this.systemTransaction(), string);
        msgD.write(this.i_socket);
        MsgD msgD2 = (MsgD)this.expectedResponse(Msg.CLASS_ID);
        return msgD2.readInt();
    }
}

