/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.internal.Buffer;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.marshall.WriteBuffer;

public class MarshallingBuffer
implements WriteBuffer {
    private static final int SIZE_NEEDED = 8;
    private static final int NO_PARENT = -2147483647;
    private Buffer _delegate;
    private int _lastOffSet;
    private int _addressInParent = -2147483647;
    private List4 _children;
    private FieldMetadata _indexedField;

    public int length() {
        return this.offset();
    }

    public int offset() {
        if (this._delegate == null) {
            return 0;
        }
        return this._delegate.offset();
    }

    public void writeByte(byte by) {
        this.prepareWrite();
        this._delegate.writeByte(by);
    }

    public void writeBytes(byte[] byArray) {
        this.prepareWrite(byArray.length);
        this._delegate.writeBytes(byArray);
    }

    public void writeInt(int n) {
        this.prepareWrite();
        this._delegate.writeInt(n);
    }

    public void writeLong(long l) {
        this.prepareWrite();
        this._delegate.writeLong(l);
    }

    private void prepareWrite() {
        this.prepareWrite(8);
    }

    private void prepareWrite(int n) {
        if (this._delegate == null) {
            this._delegate = new Buffer(n);
        }
        this._lastOffSet = this._delegate.offset();
        if (this.remainingSize() < n) {
            this.resize(n);
        }
    }

    private int remainingSize() {
        return this._delegate.length() - this._delegate.offset();
    }

    private void resize(int n) {
        int n2 = this._delegate.length() * 2;
        if (n2 - this._lastOffSet < n) {
            n2 += n;
        }
        Buffer buffer = new Buffer(n2);
        buffer.offset(this._lastOffSet);
        this._delegate.copyTo(buffer, 0, 0, this._delegate.length());
        this._delegate = buffer;
    }

    public void transferLastWriteTo(MarshallingBuffer marshallingBuffer, boolean bl) {
        marshallingBuffer.addressInParent(this._lastOffSet, bl);
        int n = this._delegate.offset() - this._lastOffSet;
        marshallingBuffer.prepareWrite(n);
        int n2 = marshallingBuffer._delegate.offset();
        System.arraycopy(this._delegate._buffer, this._lastOffSet, marshallingBuffer._delegate._buffer, n2, n);
        this._delegate.offset(this._lastOffSet);
        marshallingBuffer._delegate.offset(n2 + n);
        marshallingBuffer._lastOffSet = n2;
    }

    private void addressInParent(int n, boolean bl) {
        this._addressInParent = bl ? n : -n;
    }

    public void transferContentTo(Buffer buffer) {
        this.transferContentTo(buffer, this.length());
    }

    public void transferContentTo(Buffer buffer, int n) {
        System.arraycopy(this._delegate._buffer, 0, buffer._buffer, buffer._offset, n);
        buffer._offset += n;
    }

    public Buffer testDelegate() {
        return this._delegate;
    }

    public MarshallingBuffer addChild() {
        return this.addChild(true, false);
    }

    public MarshallingBuffer addChild(boolean bl, boolean bl2) {
        MarshallingBuffer marshallingBuffer = new MarshallingBuffer();
        marshallingBuffer.addressInParent(this.offset(), bl2);
        this._children = new List4(this._children, marshallingBuffer);
        if (bl) {
            this.reserveChildLinkSpace(bl2);
        }
        return marshallingBuffer;
    }

    public void reserveChildLinkSpace(boolean bl) {
        int n = bl ? 8 : 4;
        this.prepareWrite(n);
        this._delegate.incrementOffset(n);
    }

    public void mergeChildren(MarshallingContext marshallingContext, int n, int n2) {
        MarshallingBuffer.mergeChildren(marshallingContext, n, this, this, n2);
    }

    private static void mergeChildren(MarshallingContext marshallingContext, int n, MarshallingBuffer marshallingBuffer, MarshallingBuffer marshallingBuffer2, int n2) {
        if (marshallingBuffer2._children == null) {
            return;
        }
        Iterator4Impl iterator4Impl = new Iterator4Impl(marshallingBuffer2._children);
        while (iterator4Impl.moveNext()) {
            MarshallingBuffer.merge(marshallingContext, n, marshallingBuffer, marshallingBuffer2, (MarshallingBuffer)iterator4Impl.current(), n2);
        }
    }

    private static void merge(MarshallingContext marshallingContext, int n, MarshallingBuffer marshallingBuffer, MarshallingBuffer marshallingBuffer2, MarshallingBuffer marshallingBuffer3, int n2) {
        int n3 = marshallingBuffer.offset();
        marshallingBuffer.reserve(marshallingBuffer3.blockedLength());
        MarshallingBuffer.mergeChildren(marshallingContext, n, marshallingBuffer, marshallingBuffer3, n2);
        int n4 = marshallingBuffer.offset();
        marshallingBuffer.seek(n3);
        marshallingBuffer3.transferContentTo(marshallingBuffer._delegate);
        marshallingBuffer.seek(n4);
        marshallingBuffer2.writeLink(marshallingBuffer3, n3 + n2, marshallingBuffer3.unblockedLength());
        marshallingBuffer3.writeIndex(marshallingContext, n, n3 + n2);
    }

    public void seek(int n) {
        this._delegate.offset(n);
    }

    private void reserve(int n) {
        this.prepareWrite(n);
        this._delegate.offset(this._delegate.offset() + n);
    }

    private void writeLink(MarshallingBuffer marshallingBuffer, int n, int n2) {
        int n3 = this.offset();
        this._delegate.offset(marshallingBuffer.addressInParent());
        this._delegate.writeInt(n);
        if (marshallingBuffer.storeLengthInLink()) {
            this._delegate.writeInt(n2);
        }
        this._delegate.offset(n3);
    }

    private void writeIndex(MarshallingContext marshallingContext, int n, int n2) {
        if (this._indexedField != null) {
            StatefulBuffer statefulBuffer = new StatefulBuffer(marshallingContext.transaction(), this.unblockedLength());
            int n3 = marshallingContext.container().bytesToBlocks(n2);
            int n4 = n + n3;
            statefulBuffer.setID(n4);
            statefulBuffer.address(n4);
            this.transferContentTo(statefulBuffer, this.unblockedLength());
            this._indexedField.addIndexEntry(marshallingContext.transaction(), marshallingContext.objectID(), statefulBuffer);
        }
    }

    private int addressInParent() {
        if (!this.hasParent()) {
            throw new IllegalStateException();
        }
        if (this._addressInParent < 0) {
            return -this._addressInParent;
        }
        return this._addressInParent;
    }

    public void debugDecrementLastOffset(int n) {
        this._lastOffSet -= n;
    }

    public boolean hasParent() {
        return this._addressInParent != -2147483647;
    }

    private boolean storeLengthInLink() {
        return this._addressInParent > 0;
    }

    public void requestIndexEntry(FieldMetadata fieldMetadata) {
        this._indexedField = fieldMetadata;
    }

    public MarshallingBuffer checkBlockAlignment(MarshallingContext marshallingContext, MarshallingBuffer marshallingBuffer, IntByRef intByRef) {
        this._lastOffSet = this.offset();
        if (this.doBlockAlign()) {
            marshallingBuffer.blockAlign(marshallingContext, intByRef.value);
        }
        if (marshallingBuffer != null) {
            intByRef.value += marshallingBuffer.length();
        }
        marshallingBuffer = this;
        if (this._children != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._children);
            while (iterator4Impl.moveNext()) {
                marshallingBuffer = ((MarshallingBuffer)iterator4Impl.current()).checkBlockAlignment(marshallingContext, marshallingBuffer, intByRef);
            }
        }
        return marshallingBuffer;
    }

    private void blockAlign(MarshallingContext marshallingContext, int n) {
        int n2 = marshallingContext.container().blockAlignedBytes(n + this.length());
        int n3 = n2 - n;
        this.blockAlign(n3);
    }

    public int marshalledLength() {
        int n = this.length();
        if (this._children != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._children);
            while (iterator4Impl.moveNext()) {
                n += ((MarshallingBuffer)iterator4Impl.current()).marshalledLength();
            }
        }
        return n;
    }

    private void blockAlign(int n) {
        if (n > this._delegate.length()) {
            int n2 = n - this._delegate.offset();
            this.prepareWrite(n2);
        }
        this._delegate.offset(n);
    }

    private boolean doBlockAlign() {
        return this.hasParent();
    }

    private int blockedLength() {
        return this.length();
    }

    private int unblockedLength() {
        return this._lastOffSet;
    }
}

