/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectMethod;

public final class EventDispatcher {
    private static final String[] events = new String[]{"objectCanDelete", "objectOnDelete", "objectOnActivate", "objectOnDeactivate", "objectOnNew", "objectOnUpdate", "objectCanActivate", "objectCanDeactivate", "objectCanNew", "objectCanUpdate"};
    static final int CAN_DELETE = 0;
    static final int DELETE = 1;
    static final int SERVER_COUNT = 2;
    static final int ACTIVATE = 2;
    static final int DEACTIVATE = 3;
    static final int NEW = 4;
    public static final int UPDATE = 5;
    static final int CAN_ACTIVATE = 6;
    static final int CAN_DEACTIVATE = 7;
    static final int CAN_NEW = 8;
    static final int CAN_UPDATE = 9;
    static final int COUNT = 10;
    private final ReflectMethod[] methods;

    private EventDispatcher(ReflectMethod[] reflectMethodArray) {
        this.methods = reflectMethodArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispatch(Transaction transaction, Object object, int n) {
        if (this.methods[n] == null) {
            return true;
        }
        Object[] objectArray = new Object[]{transaction.objectContainer()};
        ObjectContainerBase objectContainerBase = transaction.container();
        int n2 = objectContainerBase.stackDepth();
        int n3 = objectContainerBase.topLevelCallId();
        objectContainerBase.stackDepth(0);
        try {
            Object object2 = this.methods[n].invoke(object, objectArray);
            if (object2 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                return bl;
            }
        }
        finally {
            objectContainerBase.stackDepth(n2);
            objectContainerBase.topLevelCallId(n3);
        }
        return true;
    }

    static EventDispatcher forClass(ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        if (objectContainerBase == null || reflectClass == null) {
            return null;
        }
        EventDispatcher eventDispatcher = null;
        int n = 0;
        if (objectContainerBase.configImpl().callbacks()) {
            n = 10;
        } else if (objectContainerBase.configImpl().isServer()) {
            n = 2;
        }
        if (n > 0) {
            ReflectClass[] reflectClassArray = new ReflectClass[]{objectContainerBase._handlers.ICLASS_OBJECTCONTAINER};
            ReflectMethod[] reflectMethodArray = new ReflectMethod[10];
            for (int i = 9; i >= 0; --i) {
                ReflectMethod reflectMethod = reflectClass.getMethod(events[i], reflectClassArray);
                if (null == reflectMethod) {
                    reflectMethod = reflectClass.getMethod(EventDispatcher.toPascalCase(events[i]), reflectClassArray);
                }
                if (reflectMethod == null) continue;
                reflectMethodArray[i] = reflectMethod;
                if (eventDispatcher != null) continue;
                eventDispatcher = new EventDispatcher(reflectMethodArray);
            }
        }
        return eventDispatcher;
    }

    private static String toPascalCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public boolean hasEventRegistered(int n) {
        return this.methods[n] != null;
    }
}

