/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.Db4oIOException;
import com.db4o.foundation.network.BlockingByteChannel;
import com.db4o.foundation.network.LoopbackSocketServer;
import com.db4o.foundation.network.Socket4;

public class LoopbackSocket
implements Socket4 {
    private final LoopbackSocketServer _server;
    private LoopbackSocket _affiliate;
    private BlockingByteChannel _uploadBuffer;
    private BlockingByteChannel _downloadBuffer;

    public LoopbackSocket(LoopbackSocketServer loopbackSocketServer, int n) {
        this._server = loopbackSocketServer;
        this._uploadBuffer = new BlockingByteChannel(n);
        this._downloadBuffer = new BlockingByteChannel(n);
    }

    public LoopbackSocket(LoopbackSocketServer loopbackSocketServer, int n, LoopbackSocket loopbackSocket) {
        this(loopbackSocketServer, n);
        this._affiliate = loopbackSocket;
        loopbackSocket._affiliate = this;
        this._downloadBuffer = loopbackSocket._uploadBuffer;
        this._uploadBuffer = loopbackSocket._downloadBuffer;
    }

    public void close() throws Db4oIOException {
        this.closeAffiliate();
        this.closeSocket();
    }

    private void closeAffiliate() throws Db4oIOException {
        if (this._affiliate != null) {
            LoopbackSocket loopbackSocket = this._affiliate;
            this._affiliate = null;
            loopbackSocket.close();
        }
    }

    private void closeSocket() {
        this._downloadBuffer.close();
        this._uploadBuffer.close();
    }

    public void flush() {
    }

    public boolean isConnected() {
        return this._affiliate != null;
    }

    public int read() throws Db4oIOException {
        return this._downloadBuffer.read();
    }

    public int read(byte[] byArray, int n, int n2) throws Db4oIOException {
        return this._downloadBuffer.read(byArray, n, n2);
    }

    public void setSoTimeout(int n) {
        this._uploadBuffer.setTimeout(n);
        this._downloadBuffer.setTimeout(n);
    }

    public void write(byte[] byArray) throws Db4oIOException {
        this._uploadBuffer.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws Db4oIOException {
        this._uploadBuffer.write(byArray, n, n2);
    }

    public void write(int n) throws Db4oIOException {
        this._uploadBuffer.write(n);
    }

    public Socket4 openParalellSocket() throws Db4oIOException {
        return this._server.openClientSocket();
    }
}

