/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.util.JRPenUtil;

public class LineDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintLine line = (JRPrintLine)element;
        grx.setColor(line.getLinePen().getLineColor());
        Stroke stroke = JRPenUtil.getStroke(line.getLinePen(), 0);
        if (stroke != null) {
            grx.setStroke(stroke);
            float lineWidth = line.getLinePen().getLineWidth().floatValue();
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyle() == 3) {
                        grx.translate(0.5 - (double)(lineWidth / 3.0f), 0.0);
                        grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX, line.getY() + offsetY + line.getHeight());
                        grx.translate(2.0f * lineWidth / 3.0f, 0.0);
                        grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX, line.getY() + offsetY + line.getHeight());
                        grx.translate(-0.5 - (double)(lineWidth / 3.0f), 0.0);
                    } else {
                        grx.translate(0.5, 0.0);
                        grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX, line.getY() + offsetY + line.getHeight());
                        grx.translate(-0.5, 0.0);
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyle() == 3) {
                    grx.translate(0.0, 0.5 - (double)(lineWidth / 3.0f));
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
                    grx.translate(0.0, 2.0f * lineWidth / 3.0f);
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
                    grx.translate(0.0, -0.5 - (double)(lineWidth / 3.0f));
                } else {
                    grx.translate(0.0, 0.5);
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
                    grx.translate(0.0, -0.5);
                }
            } else if (line.getDirection() == 1) {
                if (line.getLinePen().getLineStyle() == 3) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    grx.translate(xtrans, -ytrans);
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY + line.getHeight());
                    grx.translate(-2.0 * xtrans, 2.0 * ytrans);
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY + line.getHeight());
                    grx.translate(xtrans, -ytrans);
                } else {
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY + line.getHeight());
                }
            } else if (line.getLinePen().getLineStyle() == 3) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                grx.translate(-xtrans, -ytrans);
                grx.drawLine(line.getX() + offsetX, line.getY() + offsetY + line.getHeight(), line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
                grx.translate(2.0 * xtrans, 2.0 * ytrans);
                grx.drawLine(line.getX() + offsetX, line.getY() + offsetY + line.getHeight(), line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
                grx.translate(-xtrans, -ytrans);
            } else {
                grx.drawLine(line.getX() + offsetX, line.getY() + offsetY + line.getHeight(), line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
            }
        }
    }
}

