/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.analysis;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.util.BloatUtil;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.TraversingExpressionVisitor;
import com.db4o.nativequery.expr.build.ExpressionBuilder;
import com.db4o.nativequery.expr.cmp.ArithmeticOperator;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ArithmeticExpression;
import com.db4o.nativequery.expr.cmp.operand.ArrayAccessValue;
import com.db4o.nativequery.expr.cmp.operand.CandidateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandAnchor;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.expr.cmp.operand.MethodCallValue;
import com.db4o.nativequery.expr.cmp.operand.PredicateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.StaticFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ThreeWayComparison;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class BloatExprBuilderVisitor
extends TreeVisitor {
    private static final int MAX_DEPTH = 10;
    private static final String[] PRIMITIVE_WRAPPER_NAMES = new String[]{(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BloatExprBuilderVisitor.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = BloatExprBuilderVisitor.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = BloatExprBuilderVisitor.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$lang$Character == null ? (class$java$lang$Character = BloatExprBuilderVisitor.class$("java.lang.Character")) : class$java$lang$Character).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = BloatExprBuilderVisitor.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = BloatExprBuilderVisitor.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = BloatExprBuilderVisitor.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = BloatExprBuilderVisitor.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$String == null ? (class$java$lang$String = BloatExprBuilderVisitor.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$util$Date == null ? (class$java$util$Date = BloatExprBuilderVisitor.class$("java.util.Date")) : class$java$util$Date).getName()};
    private static final ExpressionBuilder BUILDER;
    private static final Map BUILDERS;
    private static final Map OP_SYMMETRY;
    private Expression expr;
    private Object retval;
    private Map seenBlocks = new HashMap();
    private BloatLoaderContext bloatUtil;
    private LinkedList methodStack = new LinkedList();
    private LinkedList localStack = new LinkedList();
    private int retCount = 0;
    private int blockCount = 0;
    private static final Map PRIMITIVE_CLASSES;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    public BloatExprBuilderVisitor(BloatLoaderContext bloatLoaderContext) {
        this.bloatUtil = bloatLoaderContext;
        this.localStack.addLast(new ComparisonOperand[]{PredicateFieldRoot.INSTANCE, CandidateFieldRoot.INSTANCE});
    }

    private Object purgeReturnValue() {
        Object object = this.retval;
        this.retval(null);
        return object;
    }

    private void expression(Expression expression) {
        this.retval(expression);
        this.expr = expression;
    }

    private void retval(Object object) {
        this.retval = object;
    }

    private static ComparisonBuilder builder(int n, boolean bl) {
        return (ComparisonBuilder)BUILDERS.get(new BuilderSpec(n, bl));
    }

    public Expression expression() {
        if (this.expr == null && this.isSingleReturn() && this.retval instanceof ConstValue) {
            this.expression(this.asExpression(this.retval));
        }
        return this.checkComparisons(this.expr) ? this.expr : null;
    }

    private boolean isSingleReturn() {
        return this.retCount == 1 && this.blockCount == 4;
    }

    private boolean checkComparisons(Expression expression) {
        if (expression == null) {
            return true;
        }
        final boolean[] blArray = new boolean[]{true};
        TraversingExpressionVisitor traversingExpressionVisitor = new TraversingExpressionVisitor(){

            public void visit(ComparisonExpression comparisonExpression) {
                if (comparisonExpression.left().root() != CandidateFieldRoot.INSTANCE) {
                    blArray[0] = false;
                }
            }
        };
        expression.accept(traversingExpressionVisitor);
        return blArray[0];
    }

    public void visitIfZeroStmt(IfZeroStmt ifZeroStmt) {
        Object object;
        Object object2;
        ifZeroStmt.expr().visit(this);
        Object object3 = this.purgeReturnValue();
        boolean bl = false;
        if (object3 instanceof FieldValue) {
            object2 = this.identityOrBoolComparisonOrNull(object3);
            if (object2 != null) {
                object3 = object2;
            } else {
                object = (FieldValue)object3;
                String string = (String)((FieldValue)object).tag();
                Integer n = null;
                if (string.length() == 1) {
                    n = new Integer(0);
                }
                object3 = new ComparisonExpression((FieldValue)object, new ConstValue(n), ComparisonOperator.EQUALS);
                bl = true;
            }
        }
        if (object3 instanceof Expression) {
            object2 = (Expression)object3;
            if (ifZeroStmt.comparison() == 0 && !bl || ifZeroStmt.comparison() == 1 && bl) {
                object2 = BUILDER.not((Expression)object2);
            }
            this.expression(this.buildComparison(ifZeroStmt, (Expression)object2));
            return;
        }
        if (!(object3 instanceof ThreeWayComparison)) {
            throw new EarlyExitException();
        }
        object2 = (ThreeWayComparison)object3;
        object = null;
        int n = ifZeroStmt.comparison();
        if (((ThreeWayComparison)object2).swapped()) {
            n = (Integer)OP_SYMMETRY.get(new Integer(n));
        }
        switch (n) {
            case 0: {
                object = new ComparisonExpression(((ThreeWayComparison)object2).left(), ((ThreeWayComparison)object2).right(), ComparisonOperator.EQUALS);
                break;
            }
            case 1: {
                object = BUILDER.not(new ComparisonExpression(((ThreeWayComparison)object2).left(), ((ThreeWayComparison)object2).right(), ComparisonOperator.EQUALS));
                break;
            }
            case 4: {
                object = new ComparisonExpression(((ThreeWayComparison)object2).left(), ((ThreeWayComparison)object2).right(), ComparisonOperator.SMALLER);
                break;
            }
            case 2: {
                object = new ComparisonExpression(((ThreeWayComparison)object2).left(), ((ThreeWayComparison)object2).right(), ComparisonOperator.GREATER);
                break;
            }
            case 5: {
                object = BUILDER.not(new ComparisonExpression(((ThreeWayComparison)object2).left(), ((ThreeWayComparison)object2).right(), ComparisonOperator.GREATER));
                break;
            }
            case 3: {
                object = BUILDER.not(new ComparisonExpression(((ThreeWayComparison)object2).left(), ((ThreeWayComparison)object2).right(), ComparisonOperator.SMALLER));
                break;
            }
        }
        this.expression(this.buildComparison(ifZeroStmt, (Expression)object));
    }

    public void visitIfCmpStmt(IfCmpStmt ifCmpStmt) {
        Object object;
        FieldValue fieldValue;
        ifCmpStmt.left().visit(this);
        Object object2 = this.purgeReturnValue();
        ifCmpStmt.right().visit(this);
        Object object3 = this.purgeReturnValue();
        int n = ifCmpStmt.comparison();
        if (object2 instanceof ComparisonOperand && object3 instanceof FieldValue && (fieldValue = (FieldValue)object3).root() == CandidateFieldRoot.INSTANCE) {
            object = object2;
            object2 = object3;
            object3 = object;
            n = (Integer)OP_SYMMETRY.get(new Integer(n));
        }
        if (!(object2 instanceof FieldValue) || !(object3 instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        fieldValue = (FieldValue)object2;
        object = (ComparisonOperand)object3;
        boolean bl = this.isPrimitiveExpr(ifCmpStmt.left());
        Expression expression = this.buildComparison(ifCmpStmt, BloatExprBuilderVisitor.builder(n, bl).buildComparison(fieldValue, (ComparisonOperand)object));
        this.expression(expression);
    }

    public void visitExprStmt(ExprStmt exprStmt) {
        super.visitExprStmt(exprStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCallExpr(CallExpr callExpr) {
        block26: {
            Object object;
            boolean bl = callExpr instanceof CallStaticExpr;
            if (!bl && callExpr.method().name().equals("<init>")) {
                throw new EarlyExitException();
            }
            if (!bl && callExpr.method().name().equals("equals")) {
                CallMethodExpr callMethodExpr = (CallMethodExpr)callExpr;
                if (this.isPrimitiveWrapper(callMethodExpr.receiver().type())) {
                    this.processEqualsCall(callMethodExpr, ComparisonOperator.EQUALS);
                }
                return;
            }
            if (!bl && callExpr.method().name().equals("activate")) {
                try {
                    object = this.bloatUtil.classEditor(callExpr.method().declaringClass());
                    Type[] typeArray = ((ClassEditor)object).interfaces();
                    for (int i = 0; i < typeArray.length; ++i) {
                        Type type = typeArray[i];
                        if (!"com.db4o.ta.Activatable".equals(BloatUtil.normalizeClassName((Type)type))) continue;
                        return;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            if (callExpr.method().declaringClass().equals(Type.STRING) && this.applyStringHandling(callExpr)) {
                return;
            }
            ComparisonOperandAnchor comparisonOperandAnchor = null;
            if (!bl) {
                ((CallMethodExpr)callExpr).receiver().visit(this);
                comparisonOperandAnchor = (ComparisonOperandAnchor)this.purgeReturnValue();
            }
            if (this.isPrimitiveWrapper(callExpr.method().declaringClass()) && this.applyPrimitiveWrapperHandling(callExpr, comparisonOperandAnchor)) {
                return;
            }
            object = callExpr.method();
            if (this.methodStack.contains(object) || this.methodStack.size() > 10) {
                throw new EarlyExitException();
            }
            this.methodStack.addLast(object);
            boolean bl2 = false;
            try {
                Object object2;
                Object object3;
                ArrayList arrayList = new ArrayList<ComparisonOperand>(callExpr.params().length + 1);
                arrayList.add(comparisonOperandAnchor);
                for (int i = 0; i < callExpr.params().length; ++i) {
                    callExpr.params()[i].visit(this);
                    object3 = (ComparisonOperand)this.purgeReturnValue();
                    if (object3 instanceof ComparisonOperandAnchor && ((ComparisonOperandAnchor)object3).root() == CandidateFieldRoot.INSTANCE) {
                        throw new EarlyExitException();
                    }
                    arrayList.add(object3);
                }
                bl2 = true;
                this.localStack.addLast(arrayList.toArray(new ComparisonOperand[arrayList.size()]));
                if (comparisonOperandAnchor == null || comparisonOperandAnchor.root() != CandidateFieldRoot.INSTANCE) {
                    if (comparisonOperandAnchor == null) {
                        comparisonOperandAnchor = new StaticFieldRoot(BloatUtil.normalizeClassName((Type)callExpr.method().declaringClass()));
                    }
                    arrayList.remove(0);
                    Type[] typeArray = callExpr.method().nameAndType().type().paramTypes();
                    object3 = new Class[typeArray.length];
                    for (int i = 0; i < typeArray.length; ++i) {
                        String string = BloatUtil.normalizeClassName((Type)typeArray[i]);
                        object3[i] = PRIMITIVE_CLASSES.containsKey(string) ? (Class)PRIMITIVE_CLASSES.get(string) : Class.forName(string);
                    }
                    this.retval(new MethodCallValue(comparisonOperandAnchor, callExpr.method().name(), (Class[])object3, arrayList.toArray(new ComparisonOperand[arrayList.size()])));
                    return;
                }
                Type type = ((MemberRef)object).declaringClass();
                if (callExpr instanceof CallMethodExpr && this.isSuperType(type, (Type)(object2 = ((Expr)(object3 = ((CallMethodExpr)callExpr).receiver())).type()))) {
                    type = object2;
                }
                if ((object3 = this.bloatUtil.flowGraph(type.className(), ((MemberRef)object).name(), ((MemberRef)object).type().paramTypes())) == null) {
                    throw new EarlyExitException();
                }
                ((FlowGraph)object3).visit(this);
                object2 = this.purgeReturnValue();
                if (object2 == null) {
                    throw new EarlyExitException();
                }
                this.retval(object2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            finally {
                Object e;
                if (bl2) {
                    this.localStack.removeLast();
                }
                if ((e = this.methodStack.removeLast()).equals(object)) break block26;
                throw new RuntimeException("method stack inconsistent: push=" + object + " , pop=" + e);
            }
        }
    }

    private boolean isSuperType(Type type, Type type2) throws ClassNotFoundException {
        if (type.className().equals(type2.className())) {
            return false;
        }
        ClassEditor classEditor = this.bloatUtil.classEditor(type2.className());
        Type type3 = classEditor.superclass();
        if (type3 != null) {
            if (type3.className().equals(type.className())) {
                return true;
            }
            if (this.isSuperType(type, type3)) {
                return true;
            }
        }
        Type[] typeArray = classEditor.interfaces();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].className().equals(type.className())) {
                return true;
            }
            if (!this.isSuperType(type, typeArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean applyPrimitiveWrapperHandling(CallExpr callExpr, ComparisonOperandAnchor comparisonOperandAnchor) {
        String string = callExpr.method().name();
        if (string.endsWith("Value")) {
            return this.handlePrimitiveWrapperValueCall(comparisonOperandAnchor);
        }
        if (string.equals("compareTo")) {
            return this.handlePrimitiveWrapperCompareToCall(callExpr, comparisonOperandAnchor);
        }
        return false;
    }

    private boolean handlePrimitiveWrapperCompareToCall(CallExpr callExpr, ComparisonOperandAnchor comparisonOperandAnchor) {
        ComparisonOperandAnchor comparisonOperandAnchor2 = comparisonOperandAnchor;
        callExpr.params()[0].visit(this);
        ComparisonOperand comparisonOperand = (ComparisonOperand)this.purgeReturnValue();
        this.retval(new ThreeWayComparison((FieldValue)comparisonOperandAnchor2, comparisonOperand, false));
        return true;
    }

    private boolean handlePrimitiveWrapperValueCall(ComparisonOperandAnchor comparisonOperandAnchor) {
        this.retval(comparisonOperandAnchor);
        if (comparisonOperandAnchor instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)comparisonOperandAnchor;
            if (BloatExprBuilderVisitor.isBooleanField(fieldValue)) {
                this.retval(new ComparisonExpression(fieldValue, new ConstValue(Boolean.TRUE), ComparisonOperator.EQUALS));
            }
            if (fieldValue.root().equals(CandidateFieldRoot.INSTANCE)) {
                return true;
            }
        }
        return false;
    }

    private boolean applyStringHandling(CallExpr callExpr) {
        if (callExpr.method().name().equals("contains")) {
            this.processEqualsCall((CallMethodExpr)callExpr, ComparisonOperator.CONTAINS);
            return true;
        }
        if (callExpr.method().name().equals("startsWith")) {
            this.processEqualsCall((CallMethodExpr)callExpr, ComparisonOperator.STARTSWITH);
            return true;
        }
        if (callExpr.method().name().equals("endsWith")) {
            this.processEqualsCall((CallMethodExpr)callExpr, ComparisonOperator.ENDSWITH);
            return true;
        }
        return false;
    }

    private boolean isPrimitiveWrapper(Type type) {
        return Arrays.binarySearch(PRIMITIVE_WRAPPER_NAMES, BloatUtil.normalizeClassName((Type)type)) >= 0;
    }

    private boolean isPrimitiveExpr(Expr expr) {
        return expr.type().isPrimitive();
    }

    private void processEqualsCall(CallMethodExpr callMethodExpr, ComparisonOperator comparisonOperator) {
        Expr expr = callMethodExpr.receiver();
        Expr expr2 = callMethodExpr.params()[0];
        if (!this.isComparableExprOperand(expr) || !this.isComparableExprOperand(expr2)) {
            throw new EarlyExitException();
        }
        expr.visit(this);
        Object object = this.purgeReturnValue();
        if (!(object instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        ComparisonOperand comparisonOperand = (ComparisonOperand)object;
        expr2.visit(this);
        ComparisonOperand comparisonOperand2 = (ComparisonOperand)this.purgeReturnValue();
        if (comparisonOperator.isSymmetric() && this.isCandidateFieldValue(comparisonOperand2) && !this.isCandidateFieldValue(comparisonOperand)) {
            ComparisonOperand comparisonOperand3 = comparisonOperand;
            comparisonOperand = comparisonOperand2;
            comparisonOperand2 = comparisonOperand3;
        }
        if (!this.isCandidateFieldValue(comparisonOperand) || comparisonOperand2 == null) {
            throw new EarlyExitException();
        }
        this.expression(new ComparisonExpression((FieldValue)comparisonOperand, comparisonOperand2, comparisonOperator));
    }

    private boolean isCandidateFieldValue(ComparisonOperand comparisonOperand) {
        return comparisonOperand instanceof FieldValue && ((FieldValue)comparisonOperand).root() == CandidateFieldRoot.INSTANCE;
    }

    private boolean isComparableExprOperand(Expr expr) {
        return expr instanceof FieldExpr || expr instanceof StaticFieldExpr || expr instanceof CallMethodExpr || expr instanceof CallStaticExpr || expr instanceof ConstantExpr || expr instanceof LocalExpr;
    }

    public void visitFieldExpr(FieldExpr fieldExpr) {
        fieldExpr.object().visit(this);
        Object object = this.purgeReturnValue();
        String string = fieldExpr.field().name();
        if (object instanceof ComparisonOperandAnchor) {
            this.retval(new FieldValue((ComparisonOperandAnchor)object, string, BloatUtil.normalizeClassName((Type)fieldExpr.field().type())));
        }
    }

    public void visitStaticFieldExpr(StaticFieldExpr staticFieldExpr) {
        MemberRef memberRef = staticFieldExpr.field();
        this.retval(new FieldValue(new StaticFieldRoot(BloatUtil.normalizeClassName((Type)memberRef.declaringClass())), memberRef.name(), BloatUtil.normalizeClassName((Type)memberRef.type())));
    }

    public void visitConstantExpr(ConstantExpr constantExpr) {
        super.visitConstantExpr(constantExpr);
        this.retval(new ConstValue(constantExpr.value()));
    }

    public void visitLocalExpr(LocalExpr localExpr) {
        super.visitLocalExpr(localExpr);
        ComparisonOperand[] comparisonOperandArray = (ComparisonOperand[])this.localStack.getLast();
        if (localExpr.index() >= comparisonOperandArray.length) {
            throw new EarlyExitException();
        }
        this.retval(comparisonOperandArray[localExpr.index()]);
    }

    public void visitBlock(Block block) {
        if (!this.seenBlocks.containsKey(block)) {
            super.visitBlock(block);
            this.seenBlocks.put(block, this.retval);
            ++this.blockCount;
        } else {
            this.retval(this.seenBlocks.get(block));
        }
    }

    public void visitFlowGraph(FlowGraph flowGraph) {
        try {
            Expression expression;
            super.visitFlowGraph(flowGraph);
            if (this.expr == null && (expression = this.identityOrBoolComparisonOrNull(this.retval)) != null) {
                this.expression(expression);
            }
        }
        catch (EarlyExitException earlyExitException) {
            this.expression(null);
        }
    }

    private Expression identityOrBoolComparisonOrNull(Object object) {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (!(object instanceof FieldValue)) {
            return null;
        }
        FieldValue fieldValue = (FieldValue)object;
        if (fieldValue.root() != CandidateFieldRoot.INSTANCE) {
            return null;
        }
        String string = (String)fieldValue.tag();
        if (string.length() != 1) {
            return null;
        }
        Boolean bl = null;
        switch (string.charAt(0)) {
            case 'Z': {
                bl = Boolean.TRUE;
                break;
            }
            default: {
                return null;
            }
        }
        return new ComparisonExpression(fieldValue, new ConstValue(bl), ComparisonOperator.EQUALS);
    }

    private static boolean isBooleanField(FieldValue fieldValue) {
        return BloatExprBuilderVisitor.isFieldType(fieldValue, "Z") || BloatExprBuilderVisitor.isFieldType(fieldValue, (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BloatExprBuilderVisitor.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
    }

    private boolean isIntField(FieldValue fieldValue) {
        return BloatExprBuilderVisitor.isFieldType(fieldValue, "I");
    }

    private static boolean isFieldType(FieldValue fieldValue, String string) {
        return string.equals(fieldValue.tag());
    }

    public void visitArithExpr(ArithExpr arithExpr) {
        FieldValue fieldValue;
        arithExpr.left().visit(this);
        Object object = this.purgeReturnValue();
        if (!(object instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        ComparisonOperand comparisonOperand = (ComparisonOperand)object;
        arithExpr.right().visit(this);
        Object object2 = this.purgeReturnValue();
        if (!(object2 instanceof ComparisonOperand)) {
            throw new EarlyExitException();
        }
        ComparisonOperand comparisonOperand2 = (ComparisonOperand)object2;
        boolean bl = false;
        if (comparisonOperand2 instanceof FieldValue && (fieldValue = (FieldValue)comparisonOperand2).root() == CandidateFieldRoot.INSTANCE) {
            ComparisonOperand comparisonOperand3 = comparisonOperand;
            comparisonOperand = comparisonOperand2;
            comparisonOperand2 = comparisonOperand3;
            bl = true;
        }
        switch (arithExpr.operation()) {
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                this.retval(new ArithmeticExpression(comparisonOperand, comparisonOperand2, this.arithmeticOperator(arithExpr.operation())));
                break;
            }
            case 60: 
            case 62: 
            case 63: {
                if (!(comparisonOperand instanceof FieldValue)) break;
                this.retval(new ThreeWayComparison((FieldValue)comparisonOperand, comparisonOperand2, bl));
                break;
            }
            case 94: {
                if (!(comparisonOperand instanceof FieldValue)) break;
                this.retval(BUILDER.not(new ComparisonExpression((FieldValue)comparisonOperand, comparisonOperand2, ComparisonOperator.EQUALS)));
                break;
            }
        }
    }

    public void visitArrayRefExpr(ArrayRefExpr arrayRefExpr) {
        arrayRefExpr.array().visit(this);
        ComparisonOperandAnchor comparisonOperandAnchor = (ComparisonOperandAnchor)this.purgeReturnValue();
        arrayRefExpr.index().visit(this);
        ComparisonOperand comparisonOperand = (ComparisonOperand)this.purgeReturnValue();
        if (comparisonOperandAnchor == null || comparisonOperand == null || comparisonOperandAnchor.root() == CandidateFieldRoot.INSTANCE) {
            throw new EarlyExitException();
        }
        this.retval(new ArrayAccessValue(comparisonOperandAnchor, comparisonOperand));
    }

    public void visitReturnExprStmt(ReturnExprStmt returnExprStmt) {
        returnExprStmt.expr().visit(this);
        ++this.retCount;
    }

    private ArithmeticOperator arithmeticOperator(int n) {
        switch (n) {
            case 43: {
                return ArithmeticOperator.ADD;
            }
            case 45: {
                return ArithmeticOperator.SUBTRACT;
            }
            case 42: {
                return ArithmeticOperator.MULTIPLY;
            }
            case 47: {
                return ArithmeticOperator.DIVIDE;
            }
        }
        return null;
    }

    private Expression buildComparison(IfStmt ifStmt, Expression expression) {
        ifStmt.trueTarget().visit(this);
        Object object = this.purgeReturnValue();
        ifStmt.falseTarget().visit(this);
        Object object2 = this.purgeReturnValue();
        Expression expression2 = this.asExpression(object);
        Expression expression3 = this.asExpression(object2);
        if (expression2 == null || expression3 == null) {
            return null;
        }
        return BUILDER.ifThenElse(expression, expression2, expression3);
    }

    private Expression asExpression(Object object) {
        int n;
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object instanceof ConstValue) {
            Object object2 = ((ConstValue)object).value();
            return this.asExpression(object2);
        }
        if (object instanceof Boolean) {
            return BoolConstExpression.expr((Boolean)object);
        }
        if (object instanceof Integer && ((n = ((Integer)object).intValue()) == 0 || n == 1)) {
            return BoolConstExpression.expr(n == 1);
        }
        return null;
    }

    public void visitStoreExpr(StoreExpr storeExpr) {
        if (!(storeExpr.target() instanceof StackExpr)) {
            throw new EarlyExitException();
        }
        super.visitStoreExpr(storeExpr);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Arrays.sort(PRIMITIVE_WRAPPER_NAMES);
        BUILDER = new ExpressionBuilder();
        BUILDERS = new HashMap();
        OP_SYMMETRY = new HashMap();
        BUILDERS.put(new BuilderSpec(0, false), new ComparisonBuilder(ComparisonOperator.IDENTITY));
        BUILDERS.put(new BuilderSpec(0, true), new ComparisonBuilder(ComparisonOperator.EQUALS));
        BUILDERS.put(new BuilderSpec(1, false), new NegateComparisonBuilder(ComparisonOperator.IDENTITY));
        BUILDERS.put(new BuilderSpec(1, true), new NegateComparisonBuilder(ComparisonOperator.EQUALS));
        BUILDERS.put(new BuilderSpec(4, false), new ComparisonBuilder(ComparisonOperator.SMALLER));
        BUILDERS.put(new BuilderSpec(4, true), BloatExprBuilderVisitor.builder(4, false));
        BUILDERS.put(new BuilderSpec(2, false), new ComparisonBuilder(ComparisonOperator.GREATER));
        BUILDERS.put(new BuilderSpec(2, true), BloatExprBuilderVisitor.builder(2, false));
        BUILDERS.put(new BuilderSpec(5, false), new NegateComparisonBuilder(ComparisonOperator.GREATER));
        BUILDERS.put(new BuilderSpec(5, true), BloatExprBuilderVisitor.builder(5, false));
        BUILDERS.put(new BuilderSpec(3, false), new NegateComparisonBuilder(ComparisonOperator.SMALLER));
        BUILDERS.put(new BuilderSpec(3, true), BloatExprBuilderVisitor.builder(3, false));
        OP_SYMMETRY.put(new Integer(0), new Integer(0));
        OP_SYMMETRY.put(new Integer(1), new Integer(1));
        OP_SYMMETRY.put(new Integer(4), new Integer(2));
        OP_SYMMETRY.put(new Integer(2), new Integer(4));
        OP_SYMMETRY.put(new Integer(5), new Integer(3));
        OP_SYMMETRY.put(new Integer(3), new Integer(5));
        PRIMITIVE_CLASSES = new HashMap();
        PRIMITIVE_CLASSES.put("Z", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("B", Byte.TYPE);
        PRIMITIVE_CLASSES.put("S", Short.TYPE);
        PRIMITIVE_CLASSES.put("C", Character.TYPE);
        PRIMITIVE_CLASSES.put("I", Integer.TYPE);
        PRIMITIVE_CLASSES.put("J", Long.TYPE);
        PRIMITIVE_CLASSES.put("F", Float.TYPE);
        PRIMITIVE_CLASSES.put("D", Double.TYPE);
    }

    private static class EarlyExitException
    extends RuntimeException {
        private EarlyExitException() {
        }
    }

    private static class BuilderSpec {
        private int _op;
        private boolean _primitive;

        public BuilderSpec(int n, boolean bl) {
            this._op = n;
            this._primitive = bl;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this._op;
            n = 31 * n + (this._primitive ? 1231 : 1237);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            BuilderSpec builderSpec = (BuilderSpec)object;
            if (this._op != builderSpec._op) {
                return false;
            }
            return this._primitive == builderSpec._primitive;
        }
    }

    private static class NegateComparisonBuilder
    extends ComparisonBuilder {
        public NegateComparisonBuilder(ComparisonOperator comparisonOperator) {
            super(comparisonOperator);
        }

        public Expression buildComparison(FieldValue fieldValue, ComparisonOperand comparisonOperand) {
            return BUILDER.not(super.buildComparison(fieldValue, comparisonOperand));
        }
    }

    private static class ComparisonBuilder {
        private ComparisonOperator op;

        public ComparisonBuilder(ComparisonOperator comparisonOperator) {
            this.op = comparisonOperator;
        }

        public Expression buildComparison(FieldValue fieldValue, ComparisonOperand comparisonOperand) {
            ConstValue constValue;
            if (BloatExprBuilderVisitor.isBooleanField(fieldValue) && comparisonOperand instanceof ConstValue && (constValue = (ConstValue)comparisonOperand).value() instanceof Integer) {
                Integer n = (Integer)constValue.value();
                Boolean bl = n == 0 ? Boolean.FALSE : Boolean.TRUE;
                comparisonOperand = new ConstValue(bl);
            }
            return new ComparisonExpression(fieldValue, comparisonOperand, this.op);
        }
    }
}

