/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PhiJoinStmt
extends PhiStmt {
    Map operands;
    Block block;

    public PhiJoinStmt(VarExpr target, Block block) {
        super(target);
        this.block = block;
        this.operands = new HashMap();
        Iterator preds = block.graph().preds(block).iterator();
        while (preds.hasNext()) {
            Block pred = (Block)preds.next();
            VarExpr operand = (VarExpr)target.clone();
            this.operands.put(pred, operand);
            operand.setParent(this);
            operand.setDef(null);
        }
    }

    public void setOperandAt(Block block, Expr expr) {
        Expr operand = (Expr)this.operands.get(block);
        if (operand != null) {
            operand.cleanup();
        }
        if (expr != null) {
            this.operands.put(block, expr);
            expr.setParent(this);
        } else {
            this.operands.remove(block);
        }
    }

    public Expr operandAt(Block block) {
        return (Expr)this.operands.get(block);
    }

    public int numOperands() {
        return this.block.graph().preds(this.block).size();
    }

    public Collection preds() {
        return this.block.graph().preds(this.block);
    }

    public Collection operands() {
        if (this.operands != null) {
            this.operands.keySet().retainAll(this.preds());
            return this.operands.values();
        }
        return new ArrayList();
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            this.target.visit(visitor);
        }
        Iterator e = this.operands().iterator();
        while (e.hasNext()) {
            Expr operand = (Expr)e.next();
            operand.visit(visitor);
        }
        if (!visitor.reverse()) {
            this.target.visit(visitor);
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitPhiJoinStmt(this);
    }
}

