/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class CallMethodExpr
extends CallExpr {
    public static final int VIRTUAL = 0;
    public static final int NONVIRTUAL = 1;
    public static final int INTERFACE = 2;
    Expr receiver;
    int kind;

    public CallMethodExpr(int kind, Expr receiver, Expr[] params, MemberRef method, Type type) {
        super(params, method, type);
        this.receiver = receiver;
        this.kind = kind;
        receiver.setParent(this);
    }

    public int kind() {
        return this.kind;
    }

    public Expr receiver() {
        return this.receiver;
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            int i = this.params.length - 1;
            while (i >= 0) {
                this.params[i].visit(visitor);
                --i;
            }
            this.receiver.visit(visitor);
        } else {
            this.receiver.visit(visitor);
            int i = 0;
            while (i < this.params.length) {
                this.params[i].visit(visitor);
                ++i;
            }
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitCallMethodExpr(this);
    }

    public int exprHashCode() {
        int v = 5 + this.kind ^ this.receiver.exprHashCode();
        int i = 0;
        while (i < this.params.length) {
            v ^= this.params[i].exprHashCode();
            ++i;
        }
        return v;
    }

    public boolean equalsExpr(Expr other) {
        return false;
    }

    public Object clone() {
        Expr[] p = new Expr[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            p[i] = (Expr)this.params[i].clone();
            ++i;
        }
        return this.copyInto(new CallMethodExpr(this.kind, (Expr)this.receiver.clone(), p, this.method, this.type));
    }
}

