/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.JumpStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.Iterator;
import java.util.LinkedList;

public class DeadCodeElimination {
    public static boolean DEBUG = false;
    private static final int DEAD = 0;
    private static final int LIVE = 1;
    FlowGraph cfg;
    LinkedList worklist;

    public DeadCodeElimination(FlowGraph cfg) {
        this.cfg = cfg;
    }

    public void transform() {
        this.cfg.visit(new TreeVisitor(){

            public void visitNode(Node node) {
                node.visitChildren(this);
                node.setKey(0);
            }
        });
        this.worklist = new LinkedList();
        this.cfg.visit(new TreeVisitor(){

            public void visitMonitorStmt(MonitorStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitInitStmt(InitStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitJsrStmt(JsrStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitAddressStoreStmt(AddressStoreStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitRetStmt(RetStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitSRStmt(SRStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitSCStmt(SCStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitNewArrayExpr(NewArrayExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitNewExpr(NewExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitStackExpr(StackExpr expr) {
                if (expr.stmt() instanceof PhiStmt) {
                    return;
                }
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitZeroCheckExpr(ZeroCheckExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitRCExpr(RCExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitUCExpr(UCExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitCastExpr(CastExpr expr) {
                if (expr.castType().isReference()) {
                    if (DEBUG) {
                        System.out.println(expr + " is prelive");
                    }
                    DeadCodeElimination.this.makeLive(expr);
                } else {
                    expr.visitChildren(this);
                }
            }

            public void visitArithExpr(ArithExpr expr) {
                if ((expr.operation() == 47 || expr.operation() == 37) && expr.type().isIntegral()) {
                    if (DEBUG) {
                        System.out.println(expr + " is prelive");
                    }
                    DeadCodeElimination.this.makeLive(expr);
                    return;
                }
                expr.visitChildren(this);
            }

            public void visitArrayLengthExpr(ArrayLengthExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitArrayRefExpr(ArrayRefExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitFieldExpr(FieldExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitCallStaticExpr(CallStaticExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitCallMethodExpr(CallMethodExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitCatchExpr(CatchExpr expr) {
                if (DEBUG) {
                    System.out.println(expr + " is prelive");
                }
                DeadCodeElimination.this.makeLive(expr);
            }

            public void visitStackManipStmt(StackManipStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitThrowStmt(ThrowStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitSwitchStmt(SwitchStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitIfStmt(IfStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitGotoStmt(GotoStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitReturnStmt(ReturnStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitReturnExprStmt(ReturnExprStmt stmt) {
                if (DEBUG) {
                    System.out.println(stmt + " is prelive");
                }
                DeadCodeElimination.this.makeLive(stmt);
            }

            public void visitStoreExpr(StoreExpr expr) {
                if (!(expr.target() instanceof LocalExpr)) {
                    if (DEBUG) {
                        System.out.println(expr + " is prelive");
                    }
                    DeadCodeElimination.this.makeLive(expr);
                } else {
                    expr.visitChildren(this);
                }
            }
        });
        while (!this.worklist.isEmpty()) {
            VarExpr expr = (VarExpr)this.worklist.removeFirst();
            DefExpr def = expr.def();
            if (def == null) continue;
            if (DEBUG) {
                System.out.println("making live def of " + expr);
                System.out.println("    def = " + def);
            }
            this.makeLive(def.parent());
        }
        this.cfg.visit(new TreeVisitor(){

            public void visitStoreExpr(StoreExpr expr) {
                MemExpr lhs = expr.target();
                Expr rhs = expr.expr();
                if (lhs.key() == 0 && rhs.key() == 1) {
                    rhs.setParent(null);
                    expr.replaceWith(rhs, false);
                    lhs.cleanup();
                    expr.cleanupOnly();
                    lhs.setKey(0);
                    expr.setKey(0);
                    rhs.visit(this);
                } else {
                    expr.visitChildren(this);
                }
            }
        });
        this.cfg.visit(new TreeVisitor(){

            public void visitStmt(Stmt stmt) {
                if (stmt.key() == 0) {
                    stmt.visitChildren(this);
                }
            }

            public void visitExpr(Expr expr) {
                if (expr.key() == 0) {
                    expr.visitChildren(this);
                    return;
                }
                Node parent = expr.parent();
                if (parent.key() == 1) {
                    return;
                }
                if (parent instanceof ExprStmt) {
                    parent.setKey(1);
                    return;
                }
                Stmt oldStmt = expr.stmt();
                Tree tree = parent.block().tree();
                StackExpr t = tree.newStack(expr.type());
                expr.replaceWith(t, false);
                t.setValueNumber(expr.valueNumber());
                ExprStmt stmt = new ExprStmt(expr);
                stmt.setValueNumber(expr.valueNumber());
                stmt.setKey(1);
                tree.addStmtBefore(stmt, oldStmt);
                Assert.isTrue(oldStmt.key() == 0, oldStmt + " should be dead");
            }
        });
        this.cfg.visit(new TreeVisitor(){

            public void visitTree(Tree tree) {
                Iterator e = tree.stmts().iterator();
                while (e.hasNext()) {
                    Stmt stmt = (Stmt)e.next();
                    if (stmt.key() != 0 || stmt instanceof LabelStmt || stmt instanceof JumpStmt) continue;
                    if (DEBUG) {
                        System.out.println("Removing DEAD " + stmt);
                    }
                    e.remove();
                }
            }
        });
        this.worklist = null;
    }

    void makeLive(Node node) {
        Node parent;
        if (node instanceof StoreExpr) {
            StoreExpr expr = (StoreExpr)node;
            if (expr.key() == 0) {
                if (DEBUG) {
                    System.out.println("making live " + expr + " in " + expr.parent());
                }
                expr.setKey(1);
            }
            if (expr.target().key() == 0) {
                if (DEBUG) {
                    System.out.println("making live " + expr.target() + " in " + expr);
                }
                expr.target().setKey(1);
                if (expr.target() instanceof VarExpr) {
                    this.worklist.add(expr.target());
                }
            }
            if (expr.expr().key() == 0) {
                if (DEBUG) {
                    System.out.println("making live " + expr.expr() + " in " + expr);
                }
                expr.expr().setKey(1);
                if (expr.expr() instanceof VarExpr) {
                    this.worklist.add(expr.expr());
                }
            }
        }
        if (node instanceof Expr && (parent = ((Expr)node).parent()) instanceof ExprStmt) {
            node = parent;
        }
        node.visit(new TreeVisitor(){

            public void visitStoreExpr(StoreExpr expr) {
                if (expr.target() instanceof LocalExpr) {
                    expr.expr().visit(this);
                } else {
                    this.visitExpr(expr);
                }
            }

            public void visitVarExpr(VarExpr expr) {
                if (expr.key() == 0) {
                    if (DEBUG) {
                        System.out.println("making live " + expr + " in " + expr.parent());
                    }
                    expr.setKey(1);
                    DeadCodeElimination.this.worklist.add(expr);
                }
            }

            public void visitExpr(Expr expr) {
                if (expr.key() == 0) {
                    if (DEBUG) {
                        System.out.println("making live " + expr + " in " + expr.parent());
                    }
                    expr.setKey(1);
                }
                expr.visitChildren(this);
            }

            public void visitStmt(Stmt stmt) {
                if (stmt.key() == 0) {
                    if (DEBUG) {
                        System.out.println("making live " + stmt);
                    }
                    stmt.setKey(1);
                }
                stmt.visitChildren(this);
            }
        });
    }
}

