/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.inline.Inline;
import java.util.HashMap;
import java.util.Map;

class Mapper {
    private Map varsMap;
    private Map labelsMap;
    private MethodEditor method;
    private int offset;

    private static void db(String s) {
        if (Inline.DEBUG) {
            System.out.println(s);
        }
    }

    public Mapper(MethodEditor method) {
        this.method = method;
        this.varsMap = new HashMap();
        this.labelsMap = new HashMap();
        this.offset = method.maxLocals() + 1;
    }

    public Label map(Label label) {
        Label newLabel = (Label)this.labelsMap.get(label);
        if (newLabel == null) {
            newLabel = this.method.newLabel();
            newLabel.setStartsBlock(label.startsBlock());
            this.labelsMap.put(label, newLabel);
            Mapper.db("      " + label + " -> " + newLabel + (newLabel.startsBlock() ? " (starts block)" : ""));
        }
        return newLabel;
    }

    public LocalVariable map(LocalVariable var, Type type) {
        LocalVariable newVar = (LocalVariable)this.varsMap.get(var);
        if (newVar == null) {
            newVar = this.method.localAt(var.index() + this.offset);
            this.varsMap.put(var, newVar);
            Mapper.db("      " + var + " (" + var.index() + ") -> " + newVar + "(" + var.index() + "+" + this.offset + ")" + (type.isWide() ? " (" + type + ")" : ""));
        }
        return newVar;
    }

    public LocalVariable map(LocalVariable var, boolean isWide) {
        LocalVariable newVar = (LocalVariable)this.varsMap.get(var);
        if (newVar == null) {
            newVar = this.method.localAt(var.index() + this.offset);
            this.varsMap.put(var, newVar);
            Mapper.db("      " + var + " (" + var.index() + ") -> " + newVar + "(" + var.index() + "+" + this.offset + ")" + (isWide ? " (wide)" : ""));
        }
        return newVar;
    }
}

