/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.dump;

import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import java.util.ArrayList;
import java.util.Iterator;

public class Main
implements Opcode {
    public static void main(String[] args) {
        ClassFileLoader loader = new ClassFileLoader();
        String className = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                Main.usage();
            } else if (args[i].equals("-classpath")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                String classpath = args[i];
                loader.setClassPath(classpath);
            } else if (args[i].startsWith("-")) {
                Main.usage();
            } else {
                if (className != null) {
                    Main.usage();
                }
                className = args[i];
            }
            ++i;
        }
        if (className == null) {
            Main.usage();
        }
        ClassInfo info = null;
        try {
            info = loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Couldn't find class: " + ex.getMessage());
            System.exit(1);
        }
        ArrayList<String> classes = new ArrayList<String>(1);
        classes.add(className);
        CachingBloatContext context = new CachingBloatContext(loader, classes, true);
        if (info != null) {
            Main.printClass(context, info);
        }
    }

    private static void usage() {
        System.err.println("Usage: java EDU.purdue.cs.bloat.dump.Main \n            [-options] class\n\nwhere options include:\n    -help             print out this message\n    -classpath <directories separated by colons>\n                      list directories in which to look for classes");
        System.exit(0);
    }

    private static void printClass(EditorContext context, ClassInfo info) {
        ClassEditor c = context.editClass(info);
        if (c.isPublic()) {
            System.out.print("public ");
        } else if (c.isPrivate()) {
            System.out.print("private ");
        } else if (c.isProtected()) {
            System.out.print("protected ");
        }
        if (c.isStatic()) {
            System.out.print("static ");
        }
        if (c.isFinal()) {
            System.out.print("final ");
        }
        if (c.isInterface()) {
            System.out.print("interface ");
        } else if (c.isAbstract()) {
            System.out.print("abstract class ");
        } else {
            System.out.print("class ");
        }
        System.out.print(c.type().className());
        if (c.superclass() != null) {
            System.out.print(" extends " + c.superclass().className());
        }
        Type[] interfaces = c.interfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (i == 0) {
                System.out.print(" implements");
            } else {
                System.out.print(",");
            }
            System.out.print(" " + interfaces[i].className());
            ++i;
        }
        System.out.println();
        System.out.println("{");
        FieldInfo[] fields = c.fields();
        int i2 = 0;
        while (i2 < fields.length) {
            FieldEditor f = null;
            try {
                f = context.editField(fields[i2]);
            }
            catch (ClassFormatException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
            }
            System.out.print("    ");
            if (f.isPublic()) {
                System.out.print("public ");
            } else if (f.isPrivate()) {
                System.out.print("private ");
            } else if (f.isProtected()) {
                System.out.print("protected ");
            }
            if (f.isTransient()) {
                System.out.print("transient ");
            }
            if (f.isVolatile()) {
                System.out.print("volatile ");
            }
            if (f.isStatic()) {
                System.out.print("static ");
            }
            if (f.isFinal()) {
                System.out.print("final ");
            }
            System.out.println(f.type() + " " + f.name());
            context.release(fields[i2]);
            ++i2;
        }
        if (fields.length != 0) {
            System.out.println();
        }
        MethodInfo[] methods = c.methods();
        int i3 = 0;
        while (i3 < methods.length) {
            MethodEditor m = null;
            try {
                m = context.editMethod(methods[i3]);
            }
            catch (ClassFormatException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
            }
            if (i3 != 0) {
                System.out.println();
            }
            System.out.print("    ");
            if (m.isPublic()) {
                System.out.print("public ");
            } else if (m.isPrivate()) {
                System.out.print("private ");
            } else if (m.isProtected()) {
                System.out.print("protected ");
            }
            if (m.isNative()) {
                System.out.print("native ");
            }
            if (m.isSynchronized()) {
                System.out.print("synchronized ");
            }
            if (m.isAbstract()) {
                System.out.print("abstract ");
            }
            if (m.isStatic()) {
                System.out.print("static ");
            }
            if (m.isFinal()) {
                System.out.print("final ");
            }
            System.out.println(m.type() + " " + m.name());
            Iterator iter = m.code().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                System.out.println("        " + obj);
            }
            context.release(methods[i3]);
            ++i3;
        }
        System.out.println("}");
        context.release(info);
    }
}

