/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXGlassBox;

public class ValidationFactory {
    private static Icon errorIcon = Resource.getIcon("/jgnash/resource/validation-error.png");

    private ValidationFactory() {
    }

    public static void showValidationError(String error, final JComponent origin) {
        JLabel errorLabel = new JLabel(errorIcon);
        errorLabel.setToolTipText(error);
        errorLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        final JXGlassBox validationErrorBox = new JXGlassBox(1.0f);
        validationErrorBox.setDismissOnClick(false);
        validationErrorBox.add((Component)errorLabel);
        final Container glassPane = (Container)origin.getRootPane().getGlassPane();
        Point p = SwingUtilities.convertPoint(origin.getParent(), origin.getX(), origin.getY(), null);
        glassPane.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                validationErrorBox.setVisible(false);
                validationErrorBox.dismiss();
                glassPane.removeMouseListener(this);
                origin.requestFocusInWindow();
            }
        });
        validationErrorBox.showOnGlassPane(glassPane, p.x - errorIcon.getIconWidth(), p.y - origin.getHeight());
    }
}

