/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private BufferedImage gradientImage = null;
    private static RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isOpaque()) {
            super.paintComponent(g);
            return;
        }
        ((Graphics2D)g).setRenderingHints(renderHints);
        if (this.gradientImage == null || this.gradientImage.getWidth() != this.getWidth() || this.gradientImage.getHeight() != this.getHeight()) {
            this.gradientImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g2d = (Graphics2D)this.gradientImage.getGraphics();
            LinearGradientPaint p = new LinearGradientPaint(0.0f, 0.0f, 0.0f, this.getHeight(), new float[]{0.0f, 0.499f, 0.5f, 1.0f}, new Color[]{new Color(120, 120, 120), new Color(60, 60, 60), new Color(40, 40, 40), new Color(10, 10, 10)});
            g2d.setPaint(p);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
        }
        g.drawImage(this.gradientImage, 0, 0, null);
        super.paintComponent(g);
    }

    static {
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }
}

