/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Transaction;
import jgnash.engine.search.PayeeMatcher;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PayeePieChart {
    private static final String STARTDATE = "startDate";
    private static final String FILTERTAG = "filter:";
    private final Resource rb = Resource.get();
    private Preferences pref = Preferences.userNodeForPackage(PayeePieChart.class);
    private AccountListComboBox combo;
    private JCheckBox useFilters;
    private JComboBox filterCombo;
    private Vector<String> filterList;
    private TextField txtAddFilter;
    private boolean filtersChanged;
    private JCheckBox showPercentCheck;
    private Account currentAccount;
    private ChartPanel chartPanel;
    private DatePanel startField;
    private DatePanel endField;
    private PieSectionLabelGenerator defaultLabels;
    private PieSectionLabelGenerator percentLabels;

    public static void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                PayeePieChart chart = new PayeePieChart();
                JPanel p = chart.createPanel();
                GenericCloseDialog d = new GenericCloseDialog(p);
                d.setTitle(rb.getString("Title.AccountBalance"));
                d.pack();
                d.setModal(false);
                d.setVisible(true);
            }
        });
    }

    private JPanel createPanel() {
        JButton refreshButton = new JButton(this.rb.getString("Button.Refresh"));
        JButton addFilterButton = new JButton(this.rb.getString("Button.AddFilter"));
        final JButton saveButton = new JButton(this.rb.getString("Button.SaveFilters"));
        JButton deleteFilterButton = new JButton(this.rb.getString("Button.DeleteFilter"));
        JButton clearPrefButton = new JButton(this.rb.getString("Button.MasterDelete"));
        this.filterCombo = new JComboBox();
        this.startField = new DatePanel();
        this.endField = new DatePanel();
        this.txtAddFilter = new TextField();
        this.filterList = new Vector();
        this.filtersChanged = false;
        this.useFilters = new JCheckBox(this.rb.getString("Label.UseFilters"));
        this.useFilters.setSelected(true);
        this.showPercentCheck = new JCheckBox(this.rb.getString("Label.ShowPercentValues"));
        this.combo = AccountListComboBox.getFullInstance();
        Date dStart = DateUtils.previousYear(DateUtils.firstDayOfMonth(new Date()));
        long start = this.pref.getLong(STARTDATE, dStart.getTime());
        this.startField.setDate(new Date(start));
        this.currentAccount = this.combo.getSelectedAccount();
        JFreeChart chart = this.createPieChart(this.currentAccount);
        this.chartPanel = new ChartPanel(chart, true, true, true, false, true);
        FormLayout layout = new FormLayout("p, 4dlu, 70dlu, 8dlu, p, 4dlu, 70dlu, 8dlu, p, 4dlu:g, left:p", "f:d, 3dlu, f:d, 6dlu, f:p:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        layout.setRowGroups((int[][])new int[][]{{1, 3}});
        builder.append((Component)this.combo, 9);
        builder.append((Component)this.useFilters);
        builder.nextLine();
        builder.nextLine();
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endField);
        builder.append((Component)refreshButton);
        builder.append((Component)this.showPercentCheck);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.chartPanel, 11);
        builder.nextLine();
        builder.append((Component)this.txtAddFilter, 3);
        builder.append((Component)addFilterButton, 3);
        builder.append((Component)saveButton);
        builder.nextLine();
        builder.append((Component)this.filterCombo, 3);
        builder.append((Component)deleteFilterButton, 3);
        builder.append((Component)clearPrefButton);
        builder.nextLine();
        JPanel panel = builder.getPanel();
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                Account newAccount = PayeePieChart.this.combo.getSelectedAccount();
                if (PayeePieChart.this.filtersChanged && (result = JOptionPane.showConfirmDialog(null, PayeePieChart.this.rb.getString("Message.SaveFilters"), "Warning", 0)) == 0) {
                    saveButton.doClick();
                }
                PayeePieChart.this.filtersChanged = false;
                String[] list = PayeePieChart.this.pref.get(PayeePieChart.FILTERTAG + newAccount.hashCode(), "").split("#");
                PayeePieChart.this.filterList.clear();
                for (String filter : list) {
                    if (filter.length() <= 0) continue;
                    PayeePieChart.this.filterList.add(filter);
                }
                PayeePieChart.this.refreshFilters();
                PayeePieChart.this.setCurrentAccount(newAccount);
                PayeePieChart.this.pref.putLong(PayeePieChart.STARTDATE, PayeePieChart.this.startField.getDate().getTime());
            }
        });
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PayeePieChart.this.setCurrentAccount(PayeePieChart.this.currentAccount);
                PayeePieChart.this.pref.putLong(PayeePieChart.STARTDATE, PayeePieChart.this.startField.getDate().getTime());
            }
        });
        clearPrefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(null, PayeePieChart.this.rb.getString("Message.MasterDelete"), "Warning", 0);
                if (result == 0) {
                    try {
                        PayeePieChart.this.pref.clear();
                    }
                    catch (Exception ex) {
                        System.out.println("Exception clearing preferences" + ex);
                    }
                }
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String list = "";
                for (String filter : PayeePieChart.this.filterList) {
                    list = list + filter + "#";
                }
                PayeePieChart.this.pref.put(PayeePieChart.FILTERTAG + PayeePieChart.this.currentAccount.hashCode(), list);
                PayeePieChart.this.filtersChanged = false;
            }
        });
        addFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newFilter = PayeePieChart.this.txtAddFilter.getText();
                PayeePieChart.this.filterList.remove(newFilter);
                if (newFilter.length() > 0) {
                    PayeePieChart.this.filterList.add(newFilter);
                    PayeePieChart.this.filtersChanged = true;
                    PayeePieChart.this.txtAddFilter.setText("");
                }
                PayeePieChart.this.refreshFilters();
            }
        });
        deleteFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PayeePieChart.this.filterList.size() > 0) {
                    String filter = (String)PayeePieChart.this.filterCombo.getSelectedItem();
                    PayeePieChart.this.filterList.remove(filter);
                    PayeePieChart.this.filtersChanged = true;
                }
                PayeePieChart.this.refreshFilters();
            }
        });
        this.useFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PayeePieChart.this.setCurrentAccount(PayeePieChart.this.currentAccount);
            }
        });
        this.showPercentCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PiePlot)PayeePieChart.this.chartPanel.getChart().getPlot()).setLabelGenerator(PayeePieChart.this.showPercentCheck.isSelected() ? PayeePieChart.this.percentLabels : PayeePieChart.this.defaultLabels);
            }
        });
        return panel;
    }

    private void refreshFilters() {
        this.filterCombo.removeAllItems();
        for (String aFilterList : this.filterList) {
            this.filterCombo.addItem(aFilterList);
        }
    }

    private void setCurrentAccount(Account a) {
        try {
            if (a == null) {
                return;
            }
            this.currentAccount = a;
            this.chartPanel.setChart(this.createPieChart(a));
            this.chartPanel.validate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JFreeChart createPieChart(Account a) {
        PieDataset data = this.createPieDataset(a);
        PiePlot plot = new PiePlot(data);
        NumberFormat valueFormat = CommodityFormat.getFullNumberFormat(a.getCurrencyNode());
        DecimalFormat percentFormat = new DecimalFormat("0.0#%");
        this.defaultLabels = new StandardPieSectionLabelGenerator("{0} = {1}", valueFormat, (NumberFormat)percentFormat);
        this.percentLabels = new StandardPieSectionLabelGenerator("{0} = {1}\n{2}", valueFormat, (NumberFormat)percentFormat);
        plot.setLabelGenerator(this.showPercentCheck.isSelected() ? this.percentLabels : this.defaultLabels);
        plot.setLabelGap(0.02);
        plot.setInteriorGap(0.1);
        String title = a.getAccountType() == AccountType.EXPENSE ? this.rb.getString("Title.PercentExpense") : (a.getAccountType() == AccountType.INCOME ? this.rb.getString("Title.PercentIncome") : this.rb.getString("Title.PercentDist"));
        title = title + " - " + a.getPathName();
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        BigDecimal total = a.getTreeBalance(this.startField.getDate(), this.endField.getDate()).abs();
        chart.addSubtitle((Title)new TextTitle(valueFormat.format(total)));
        chart.setBackgroundPaint(null);
        return chart;
    }

    private List<TranTuple> getTransactions(Account account, List<TranTuple> transactions, Date startDate, Date endDate) {
        for (Transaction t : account.getTransactions(startDate, endDate)) {
            TranTuple touple = new TranTuple(account, t);
            transactions.add(touple);
        }
        for (Account child : account.getChildren()) {
            this.getTransactions(child, transactions, startDate, endDate);
        }
        return transactions;
    }

    private PieDataset createPieDataset(Account a) {
        DefaultPieDataset returnValue = new DefaultPieDataset();
        if (a != null) {
            HashMap<String, BigDecimal> names = new HashMap<String, BigDecimal>();
            List<TranTuple> list = this.getTransactions(a, new ArrayList<TranTuple>(), this.startField.getDate(), this.endField.getDate());
            CurrencyNode currency = a.getCurrencyNode();
            for (TranTuple touple : list) {
                Transaction tran = touple.transaction;
                Account account = touple.account;
                String payee = tran.getPayee();
                BigDecimal sum = tran.getAmount(account);
                if (!account.getCurrencyNode().equals(currency)) {
                    sum = sum.multiply(currency.getExchangeRate(account.getCurrencyNode()));
                }
                if (this.useFilters.isSelected()) {
                    for (String aFilterList : this.filterList) {
                        PayeeMatcher pm = new PayeeMatcher(aFilterList, false);
                        if (!pm.matches(tran)) continue;
                        payee = aFilterList;
                        break;
                    }
                }
                if (names.containsKey(payee)) {
                    sum = sum.add((BigDecimal)names.get(payee));
                }
                names.put(payee, sum);
            }
            Iterator<TranTuple> i$ = names.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                String sKey = key = (String)((Object)i$.next());
                BigDecimal value = (BigDecimal)names.get(key);
                if (value.compareTo(BigDecimal.ZERO) == -1) {
                    value = value.negate();
                    sKey = sKey + "(-ve)";
                }
                returnValue.setValue((Comparable)((Object)sKey), (Number)value);
            }
        }
        return returnValue;
    }

    private static class TranTuple {
        Account account;
        Transaction transaction;

        public TranTuple(Account account, Transaction transaction) {
            this.account = account;
            this.transaction = transaction;
        }
    }
}

