/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report;

import ar.com.fdvs.dj.domain.Style;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public class FontUtilities {
    private static Reference<FontRenderContext> contextReference = new SoftReference<Object>(null);

    private FontUtilities() {
    }

    private static int getStringWidth(String text, Font font) {
        FontRenderContext frc = FontUtilities.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(text + " ", frc);
        return (int)Math.ceil(bounds.getWidth()) + 2;
    }

    public static int getStringWidth(String text, Style style) {
        Font font = new Font(style.getFont().getFontName(), 0, style.getFont().getFontSize());
        if (style.getFont().isBold()) {
            font = font.deriveFont(1);
        }
        if (style.getFont().isItalic()) {
            font = font.deriveFont(2);
        }
        return FontUtilities.getStringWidth(text, font);
    }

    private static synchronized FontRenderContext getFontRenderContext() {
        FontRenderContext context = contextReference.get();
        if (context == null) {
            context = new FontRenderContext(null, true, true);
            contextReference = new SoftReference<FontRenderContext>(context);
        }
        return context;
    }
}

