/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.Arrays;
import jgnash.engine.Account;
import jgnash.engine.Comparators;
import jgnash.engine.Transaction;
import jgnash.message.Message;
import jgnash.message.MessageProperty;
import jgnash.ui.register.table.InvestmentRegisterTableModel;
import jgnash.ui.register.table.SortableTableModel;

public class SortedInvestmentTableModel
extends InvestmentRegisterTableModel
implements SortableTableModel {
    private static final long serialVersionUID = -7368576333237936954L;
    private Transaction[] transactions = new Transaction[0];
    private int sortColumn = 0;
    private boolean ascending = true;
    private boolean[] sortedColumnMap;
    private boolean[] sortColumns;
    private final Object mutex = new Object();

    public SortedInvestmentTableModel(Account account) {
        super(account);
        this.getTransactions();
    }

    @Override
    public boolean isSortable(int col) {
        return this.sortedColumnMap[col];
    }

    private boolean[] getSortableColumns() {
        return new boolean[]{true, true, true, false, false, false, false};
    }

    @Override
    protected void buildColumnMap() {
        super.buildColumnMap();
        if (this.sortColumns == null) {
            this.sortColumns = this.getSortableColumns();
        }
        this.sortedColumnMap = new boolean[this.getColumnCount()];
        int index = 0;
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (!this.columnVisible[i]) continue;
            this.sortedColumnMap[index] = this.sortColumns[i];
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTransactions() {
        Object object = this.mutex;
        synchronized (object) {
            int size = this.account.getTransactionCount();
            this.transactions = new Transaction[size];
            for (int i = 0; i < size; ++i) {
                this.transactions[i] = this.account.getTransactionAt(i);
            }
            this.sortColumn(this.sortColumn, this.ascending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.transactions.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction getTransactionAt(int index) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.ascending) {
                return this.transactions[index];
            }
            return this.transactions[this.transactions.length - index - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBalanceAt(int index) {
        BigDecimal balance = BigDecimal.ZERO;
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i <= index; ++i) {
                balance = balance.add(this.getTransactionAt(i).getAmount(this.account));
            }
        }
        return balance;
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT) == this.account) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case TRANSACTION_ADD: 
                        case TRANSACTION_REMOVE: {
                            SortedInvestmentTableModel.this.getTransactions();
                            break;
                        }
                    }
                }
            });
        }
        super.messagePosted(event);
    }

    @Override
    public boolean getAscending() {
        return this.ascending;
    }

    @Override
    public int getSortedColumn() {
        return this.sortColumn;
    }

    @Override
    public void sortColumn(int col, boolean ascending1) {
        this.ascending = ascending1;
        this.sortColumn = col;
        switch (this.getColumnMapping(col)) {
            case 0: {
                Arrays.sort(this.transactions, Comparators.getTransactionByDate());
                break;
            }
            case 1: {
                Arrays.sort(this.transactions, Comparators.getTransactionByType());
                break;
            }
            case 2: {
                Arrays.sort(this.transactions, Comparators.getTransactionBySecurity());
                break;
            }
            default: {
                Arrays.sort(this.transactions, Comparators.getTransactionByDate());
            }
        }
        this.fireTableDataChanged();
    }
}

