/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.ui.UIApplication;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.register.invest.InvestmentTransactionPanel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class InvestmentTransactionDialog
extends JDialog
implements RegisterListener {
    private Account account;
    private InvestmentTransactionPanel transactionPanel;

    public static void showDialog(InvestmentTransaction t) {
        Resource rb = Resource.get();
        InvestmentTransactionDialog d = new InvestmentTransactionDialog(t.getInvestmentAccount());
        d.setTitle(rb.getString("Title.ModifyTransaction"));
        d.setTransaction(t);
        d.setVisible(true);
    }

    private InvestmentTransactionDialog(Account account) {
        super((Frame)((Object)UIApplication.getFrame()), true);
        this.account = account;
        this.transactionPanel = new InvestmentTransactionPanel(this.account);
        this.transactionPanel.addRegisterListener(this);
        this.layoutMainPanel();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo((Component)((Object)UIApplication.getFrame()));
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    private void setTransaction(Transaction t) {
        this.transactionPanel.modifyTransaction(t);
    }

    private void layoutMainPanel() {
        Resource rb = Resource.get();
        FormLayout layout = new FormLayout("right:d, 4dlu, f:d:g", "f:d, 3dlu, f:d, 8dlu, f:d");
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)layout);
        p.add((Component)new JLabel(rb.getString("Label.BaseAccount")), cc.xy(1, 1));
        p.add((Component)new JLabel(this.account.getPathName()), cc.xy(3, 1));
        p.add((Component)this.transactionPanel, cc.xyw(1, 3, 3));
        p.setBorder(Borders.DIALOG_BORDER);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)p, "Center");
        this.pack();
    }

    @Override
    public void registerEvent(RegisterEvent e) {
        if (e.getAction() == RegisterEvent.Action.CANCEL) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getAction() == RegisterEvent.Action.OK) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }
}

