/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.event.ActionListener;
import java.util.Date;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.ui.register.DateChkNumberDialog;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class DuplicateTransactionDialog
extends DateChkNumberDialog
implements ActionListener {
    private Transaction t;

    protected static void showDialog(Account a, Transaction t) {
        if (t != null) {
            DuplicateTransactionDialog d = new DuplicateTransactionDialog(a, t);
            d.setVisible(true);
        }
    }

    private DuplicateTransactionDialog(Account a, Transaction t) {
        super(a, Resource.get().getString("Title.DuplicateTransaction"));
        if (a == null) {
            throw new IllegalArgumentException("Account parameter was null");
        }
        if (t == null) {
            throw new IllegalArgumentException("Transaction parameter was null");
        }
        this.t = t;
        if (t.getNumber() != null && t.getNumber().length() > 0) {
            String n = a.getNextTransactionNumber();
            if (n != null) {
                this.numberCombo.setText(n);
            } else {
                this.numberCombo.setText(t.getNumber());
            }
        }
    }

    @Override
    public void okAction() {
        Transaction c = (Transaction)this.t.clone();
        Date today = DateUtils.levelDate(new Date());
        if (today.equals(this.datePanel.getDate())) {
            c.setDate(new Date());
        } else {
            c.setDate(this.datePanel.getDate());
        }
        c.setNumber(this.numberCombo.getText());
        c.setReconciled(ReconciledState.NOT_RECONCILED);
        EngineFactory.getEngine("default").addTransaction(c);
        super.okAction();
    }
}

