/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.recurring;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.engine.recurring.DailyReminder;
import jgnash.engine.recurring.MonthlyReminder;
import jgnash.engine.recurring.OneTimeReminder;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.recurring.WeeklyReminder;
import jgnash.engine.recurring.YearlyReminder;
import jgnash.ui.UIApplication;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JDateField;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.recurring.DayTab;
import jgnash.ui.recurring.MonthTab;
import jgnash.ui.recurring.NoneTab;
import jgnash.ui.recurring.RecurringTab;
import jgnash.ui.recurring.WeekTab;
import jgnash.ui.recurring.YearTab;
import jgnash.ui.register.TransactionDialog;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

class RecurringEntryDialog
extends JDialog
implements ActionListener {
    private boolean result = false;
    private Reminder reminder = null;
    private DatePanel startDateField;
    private JTextField transactionField;
    private JTextField descriptionField;
    private JButton deleteButton;
    private JButton editButton;
    private JCheckBox enabledCheckBox;
    private JTabbedPane freqTab;
    private JCheckBox autoEnterCheckBox;
    private JIntegerField daysBeforeField;
    private JDateField lastOccurenceField;
    private JButton cancelButton;
    private JButton okButton;
    private JTextArea notesArea;
    private AccountListComboBox accountCombo;
    private final Resource rb = Resource.get();
    private HashMap<Class<?>, Integer> tabMap = new HashMap();
    private Transaction transaction = null;

    public RecurringEntryDialog() {
        this((Reminder)null);
    }

    private RecurringEntryDialog(Reminder reminder) {
        super((Frame)((Object)UIApplication.getFrame()), true);
        if (reminder == null) {
            this.setTitle(this.rb.getString("Title.NewReminder"));
        } else {
            this.setTitle(this.rb.getString("Title.ModifyReminder"));
        }
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        this.setLocationRelativeTo((Component)((Object)UIApplication.getFrame()));
        if (reminder != null) {
            this.displayReminder(reminder);
        }
        this.okButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.autoEnterCheckBox.addActionListener(this);
    }

    protected static Reminder showDialog() {
        return RecurringEntryDialog.showDialog(null);
    }

    protected static Reminder showDialog(Reminder reminder) {
        RecurringEntryDialog d = new RecurringEntryDialog(reminder);
        d.setMinimumSize(d.getSize());
        DialogUtils.addBoundsListener(d, "dialogbounds");
        d.setVisible(true);
        if (d.result) {
            return d.reminder;
        }
        return null;
    }

    private JPanel createTransactionPanel() {
        FormLayout layout = new FormLayout("left:p, 4dlu, p:g, 4dlu, p", "f:p, 3dlu, f:p, 3dlu, f:p, 3dlu, f:40dlu:g");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)layout);
        this.descriptionField = new JTextFieldEx();
        this.accountCombo = new AccountListComboBox();
        this.notesArea = new JTextArea(5, 20);
        this.notesArea.setLineWrap(true);
        this.notesArea.setAutoscrolls(true);
        JScrollPane pane = new JScrollPane(this.notesArea);
        pane.setAutoscrolls(true);
        this.transactionField = new JTextFieldEx();
        this.transactionField.setEditable(false);
        this.editButton = new JButton(this.rb.getString("Button.Edit"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        p.add((Component)new JLabel(this.rb.getString("Label.Account")), cc.xy(1, 1));
        p.add((Component)this.accountCombo, cc.xywh(3, 1, 3, 1));
        p.add((Component)new JLabel(this.rb.getString("Label.Description")), cc.xy(1, 3));
        p.add((Component)this.descriptionField, cc.xywh(3, 3, 3, 1));
        p.add((Component)new JLabel(this.rb.getString("Label.Transaction")), cc.xy(1, 5));
        p.add((Component)this.transactionField, cc.xy(3, 5));
        p.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.editButton, (JButton)this.deleteButton), cc.xy(5, 5));
        p.add((Component)new JLabel(this.rb.getString("Label.Notes")), cc.xy(1, 7));
        p.add((Component)pane, cc.xywh(3, 7, 3, 1));
        return p;
    }

    private JPanel createFreqPanel() {
        FormLayout layout = new FormLayout("right:p, 4dlu, max(48dlu;min), 6dlu, p, f:p:g", "f:p, 3dlu, min");
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)layout);
        this.startDateField = new DatePanel();
        this.enabledCheckBox = new JCheckBox(this.rb.getString("Button.Enabled"));
        this.freqTab = new JTabbedPane();
        this.freqTab.add(this.rb.getString("Tab.None"), new NoneTab());
        this.freqTab.add(this.rb.getString("Tab.Day"), new DayTab());
        this.freqTab.add(this.rb.getString("Tab.Week"), new WeekTab());
        this.freqTab.add(this.rb.getString("Tab.Month"), new MonthTab());
        this.freqTab.add(this.rb.getString("Tab.Year"), new YearTab());
        this.tabMap.put(OneTimeReminder.class, 0);
        this.tabMap.put(DailyReminder.class, 1);
        this.tabMap.put(WeeklyReminder.class, 2);
        this.tabMap.put(MonthlyReminder.class, 3);
        this.tabMap.put(YearlyReminder.class, 4);
        p.add((Component)new JLabel(this.rb.getString("Label.FirstPayDate")), cc.xy(1, 1));
        p.add((Component)this.startDateField, cc.xy(3, 1));
        p.add((Component)this.enabledCheckBox, cc.xy(5, 1));
        p.add((Component)this.freqTab, cc.xywh(1, 3, 6, 1));
        return p;
    }

    private JPanel createEntryPanel() {
        FormLayout layout = new FormLayout("right:p, 4dlu, 45dlu", "f:p, 3dlu, f:p, 3dlu, f:p");
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)layout);
        this.autoEnterCheckBox = new JCheckBox(this.rb.getString("Button.EnterDaysBefore"));
        this.daysBeforeField = new JIntegerField();
        this.lastOccurenceField = new JDateField();
        JIntegerField daysPastDueField = new JIntegerField();
        p.add((Component)this.autoEnterCheckBox, cc.xy(1, 1));
        p.add((Component)this.daysBeforeField, cc.xy(3, 1));
        p.add((Component)new JLabel(this.rb.getString("Label.LastOccurrence")), cc.xy(1, 3));
        p.add((Component)this.lastOccurenceField, cc.xy(3, 3));
        p.add((Component)new JLabel(this.rb.getString("Label.DaysPastDue")), cc.xy(1, 5));
        p.add((Component)daysPastDueField, cc.xy(3, 5));
        this.lastOccurenceField.setValue(null);
        this.lastOccurenceField.setEditable(false);
        daysPastDueField.setEditable(false);
        return p;
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("10dlu, p:g", "p, 3dlu, f:p:g, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 6dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        builder.setBorder(Borders.DIALOG_BORDER);
        builder.addSeparator(this.rb.getString("Title.Transaction"), cc.xyw(1, 1, 2));
        builder.add((Component)this.createTransactionPanel(), cc.xy(2, 3));
        builder.addSeparator(this.rb.getString("Title.Frequency"), cc.xyw(1, 5, 2));
        builder.add((Component)this.createFreqPanel(), cc.xy(2, 7));
        builder.addSeparator(this.rb.getString("Title.Entry"), cc.xyw(1, 9, 2));
        builder.add((Component)this.createEntryPanel(), cc.xy(2, 11));
        builder.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), cc.xy(2, 13));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private Reminder generateReminder() {
        RecurringTab tab = (RecurringTab)((Object)this.freqTab.getSelectedComponent());
        Reminder r = tab.getReminder();
        r.setDescription(this.descriptionField.getText());
        r.setEnabled(this.enabledCheckBox.isSelected());
        r.setStartDate(this.startDateField.getDate());
        r.setNotes(this.notesArea.getText());
        r.setAutoCreate(this.autoEnterCheckBox.isSelected());
        r.setDaysAdvance(this.daysBeforeField.intValue());
        r.setAccount(this.accountCombo.getSelectedAccount());
        r.setTransaction(this.transaction);
        return r;
    }

    private void displayReminder(Reminder r) {
        Account a = r.getAccount();
        if (a != null) {
            this.accountCombo.setSelectedAccount(a);
        } else {
            System.err.println("did not find account");
        }
        this.transaction = r.getTransaction();
        if (this.transaction != null) {
            this.transactionField.setText(this.transaction.getPayee());
        }
        this.descriptionField.setText(r.getDescription());
        this.enabledCheckBox.setSelected(r.isEnabled());
        this.startDateField.setDate(r.getStartDate());
        this.notesArea.setText(r.getNotes());
        this.freqTab.setSelectedIndex(this.tabMap.get(r.getClass()));
        ((RecurringTab)((Object)this.freqTab.getSelectedComponent())).setReminder(r);
        this.lastOccurenceField.setValue(r.getLastDate());
        this.autoEnterCheckBox.setSelected(r.isAutoCreate());
        int days = r.getDaysAdvance();
        this.daysBeforeField.setIntValue(days);
        this.daysBeforeField.setEnabled(this.autoEnterCheckBox.isSelected());
    }

    private void editTransactionAction() {
        Transaction t = TransactionDialog.showDialog(this.accountCombo.getSelectedAccount(), this.transaction);
        if (t != null) {
            this.transaction = t;
            this.transactionField.setText(this.transaction.getPayee());
        }
    }

    private void deleteTransaction() {
        this.transaction = null;
        this.transactionField.setText(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.okButton) {
            this.reminder = this.generateReminder();
            this.result = true;
            this.closeDialog();
        } else if (e.getSource() == this.autoEnterCheckBox) {
            this.daysBeforeField.setEnabled(this.autoEnterCheckBox.isSelected());
        } else if (e.getSource() == this.editButton) {
            this.editTransactionAction();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteTransaction();
        }
    }
}

