/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.option;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgnash.engine.EngineFactory;
import jgnash.net.currency.CurrencyUpdateFactory;
import jgnash.net.security.SecurityUpdateFactory;
import jgnash.util.Resource;

class StartupOptions
extends JPanel
implements ActionListener {
    private final Resource rb = Resource.get();
    private JCheckBox updateCurrenciesButton;
    private JCheckBox updateSecuritiesButton;
    private JCheckBox timeStampButton;
    private JCheckBox removeBackupButton;
    private JSpinner removeBackupCountSpinner;

    public StartupOptions() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.updateCurrenciesButton = new JCheckBox(this.rb.getString("Button.UpdateCurrenciesStartup"));
        this.updateSecuritiesButton = new JCheckBox(this.rb.getString("Button.UpdateSecuritiesStartup"));
        this.removeBackupButton = new JCheckBox("Remove old backups");
        this.timeStampButton = new JCheckBox(this.rb.getString("Button.CreateTimeFile"));
        this.removeBackupCountSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.updateCurrenciesButton.setSelected(CurrencyUpdateFactory.getUpdateOnStartup());
        this.updateSecuritiesButton.setSelected(SecurityUpdateFactory.getUpdateOnStartup());
        this.timeStampButton.setSelected(EngineFactory.exportXMLOnClose());
        this.removeBackupButton.setSelected(EngineFactory.removeOldBackups());
        this.removeBackupCountSpinner.setValue(EngineFactory.maximumBackups());
        this.updateCurrenciesButton.addActionListener(this);
        this.updateSecuritiesButton.addActionListener(this);
        this.timeStampButton.addActionListener(this);
        this.removeBackupButton.addActionListener(this);
        this.removeBackupCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerModel dateModel = StartupOptions.this.removeBackupCountSpinner.getModel();
                if (dateModel instanceof SpinnerNumberModel) {
                    Number count = ((SpinnerNumberModel)dateModel).getNumber();
                    EngineFactory.setMaximumBackups((Integer)count);
                }
            }
        });
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, $lcgap, f:p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setRowGroupingEnabled(true);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.BackgroundUpdate"));
        builder.append((Component)this.updateCurrenciesButton, 3);
        builder.append((Component)this.updateSecuritiesButton, 3);
        builder.appendSeparator(this.rb.getString("Title.Shutdown"));
        builder.append((Component)this.timeStampButton, 3);
        builder.append((Component)this.removeBackupButton, 3);
        builder.append(this.rb.getString("Label.MaxBackupCount"), (Component)this.removeBackupCountSpinner);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateCurrenciesButton) {
            CurrencyUpdateFactory.setUpdateOnStartup(this.updateCurrenciesButton.isSelected());
        } else if (e.getSource() == this.updateSecuritiesButton) {
            SecurityUpdateFactory.setUpdateOnStartup(this.updateSecuritiesButton.isSelected());
        } else if (e.getSource() == this.timeStampButton) {
            EngineFactory.setExportXMLOnClose(this.timeStampButton.isSelected());
        } else if (e.getSource() == this.removeBackupButton) {
            this.removeBackupCountSpinner.setEnabled(this.removeBackupButton.isSelected());
            EngineFactory.setRemoveOldBackups(this.removeBackupButton.isSelected());
        }
    }
}

